/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ScreenshotAppState
extends AbstractAppState
implements ActionListener,
SceneProcessor {
    private static final Logger logger = Logger.getLogger(ScreenshotAppState.class.getName());
    private boolean capture = false;
    private Renderer renderer;
    private ByteBuffer outBuf;
    private String appName;
    private int shotIndex = 0;
    private BufferedImage awtImage;

    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            InputManager inputManager = app.getInputManager();
            inputManager.addMapping("ScreenShot", new Trigger[]{new KeyTrigger(183)});
            inputManager.addListener((InputListener)this, new String[]{"ScreenShot"});
            List vps = app.getRenderManager().getPostViews();
            ViewPort last = (ViewPort)vps.get(vps.size() - 1);
            last.addProcessor((SceneProcessor)this);
            this.appName = app.getClass().getSimpleName();
        }
        super.initialize(stateManager, app);
    }

    public void onAction(String name, boolean value, float tpf) {
        if (value) {
            this.capture = true;
        }
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
        this.awtImage = new BufferedImage(w, h, 6);
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (this.capture) {
            this.capture = false;
            ++this.shotIndex;
            this.renderer.readFrameBuffer(out, this.outBuf);
            Screenshots.convertScreenShot(this.outBuf, this.awtImage);
            try {
                ImageIO.write((RenderedImage)this.awtImage, "png", new File(this.appName + this.shotIndex + ".png"));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while saving screenshot", ex);
            }
        }
    }
}

