/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import mythruna.BlockTypeIndex;
import mythruna.Coordinates;
import mythruna.MovementState;
import mythruna.World;
import mythruna.client.GameClient;
import mythruna.client.PhysicsTask;
import mythruna.client.PhysicsThread;
import mythruna.db.BlueprintData;
import mythruna.db.WorldDatabase;
import mythruna.mathd.Vec3d;
import mythruna.phys.CollisionMesh;
import mythruna.phys.Contact;
import mythruna.phys.MaskStrategies;
import mythruna.phys.MaskStrategy;
import mythruna.sim.FrameTransition;
import mythruna.sim.TimeBuffer;

public abstract class CameraTask
implements PhysicsTask {
    private Vector3f position = new Vector3f();
    private Vector3f working = new Vector3f();
    private Vector3f external;
    private MovementState movement = new MovementState();
    private MovementState workingMovement = new MovementState();
    protected float rotationSpeed;
    protected Vector3f initialUpVec = new Vector3f(0.0f, 1.0f, 0.0f);
    protected boolean walkOnWater = false;
    protected boolean headInWater = false;
    protected Vector3f moveVector = new Vector3f();
    protected Vector3f leftVector = new Vector3f();
    protected World world;
    protected WorldDatabase worldDb;
    protected GameClient gameClient;
    protected TimeBuffer moveHistory = new TimeBuffer(4);
    protected MaskStrategy maskStrat = MaskStrategies.ALL;

    protected CameraTask(World world, GameClient gameClient) {
        this.gameClient = gameClient;
        this.world = world;
        this.worldDb = world.getWorldDatabase();
    }

    public void initialize() {
    }

    public void setCollisionMaskStrategy(MaskStrategy strat) {
        this.maskStrat = strat;
    }

    public void setDirection(Quaternion rotation) {
        this.moveVector.set(rotation.getRotationColumn(2));
        this.leftVector.set(rotation.getRotationColumn(0));
        this.movement.setFacing(rotation);
    }

    public void setMoveState(byte flags) {
        this.movement.setMovementFlags(flags);
    }

    public MovementState getMoveState() {
        return this.movement;
    }

    protected CollisionMesh createPersonMesh() {
        if (!BlockTypeIndex.isInitialized()) {
            throw new RuntimeException("Block types have not been initialized.");
        }
        BlueprintData bp = new BlueprintData();
        bp.id = -1L;
        bp.name = "Person";
        bp.xSize = 1;
        bp.ySize = 1;
        bp.zSize = 5;
        bp.scale = 0.4f;
        bp.cells = new int[bp.xSize][bp.ySize][bp.zSize];
        for (int i = 0; i < bp.xSize; ++i) {
            for (int j = 0; j < bp.ySize; ++j) {
                for (int k = 0; k < bp.zSize; ++k) {
                    bp.cells[i][j][k] = 1;
                }
            }
        }
        CollisionMesh cm = new CollisionMesh(null, bp, new Vec3d(0.2, 0.0, 0.2));
        return cm;
    }

    public void setPosition(float x, float y, float z) {
        this.external = new Vector3f(x, y, z);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setWorldPosition(float x, float y, float z) {
        this.setPosition(x, z, y);
    }

    public Vector3f getWorldPosition(long time) {
        long t = time;
        FrameTransition ft = this.moveHistory.getFrame(t);
        if (ft == null) {
            System.out.println("**** Time buffer accessed while uninitialized. ***");
            return new Vector3f(this.position.x, this.position.z, this.position.y);
        }
        Vector3f pos = ft.getPosition(t, true);
        float flip = pos.y;
        pos.y = pos.z;
        pos.z = flip;
        return pos;
    }

    public Quaternion getFacing(long time) {
        long t = time;
        FrameTransition ft = this.moveHistory.getFrame(t);
        if (ft == null) {
            System.out.println("**** Time buffer accessed while uninitialized. ***");
            return Quaternion.DIRECTION_Z;
        }
        Quaternion rot = ft.getRotation(t, true);
        return rot;
    }

    public Vector3f getVelocity(long time) {
        long t = time;
        FrameTransition ft = this.moveHistory.getFrame(t);
        if (ft == null) {
            System.out.println("**** Time buffer accessed while uninitialized. ***");
            return new Vector3f(this.position.x, this.position.z, this.position.y);
        }
        Vector3f vel = ft.getFrameVelocity();
        float flip = vel.y;
        vel.y = vel.z;
        vel.z = flip;
        return vel;
    }

    public boolean isHeadInWater() {
        return this.headInWater;
    }

    protected int getBlockType(float x, float y, float z) {
        return this.worldDb.getCellType(Coordinates.worldToCell(x), Coordinates.worldToCell(y), Coordinates.worldToCell(z));
    }

    protected void swapWorking() {
        if (this.external != null) {
            this.position = this.external.clone();
            this.working = this.external;
            this.external = null;
        } else {
            this.position = this.working;
            this.working = this.position.clone();
        }
    }

    protected boolean isOn(byte type) {
        return this.workingMovement.isOn(type);
    }

    protected abstract void doMovement(PhysicsThread var1, Vector3f var2, double var3);

    protected boolean isMoving() {
        return this.workingMovement.isMoving();
    }

    public boolean updatePhysics(PhysicsThread anim, double seconds) {
        this.workingMovement = new MovementState(this.movement);
        if (this.external != null) {
            this.swapWorking();
        }
        long time = this.gameClient.getRawTime();
        if (this.isMoving()) {
            this.doMovement(anim, this.working, seconds * 0.25);
            this.swapWorking();
            this.doMovement(anim, this.working, seconds * 0.25);
            this.swapWorking();
            this.doMovement(anim, this.working, seconds * 0.25);
            this.swapWorking();
            this.doMovement(anim, this.working, seconds * 0.25);
            this.swapWorking();
        }
        this.moveHistory.addFrame(time, this.position, this.movement.getFacing());
        this.gameClient.getPlayerState().setRunning(this.movement.isOn((byte)-128));
        return true;
    }

    public static class WalkCameraTask
    extends CameraTask {
        private float baseGravity = 20.0f;
        private float baseFallSpeed = 0.0f;
        private float movementSpeed = 3.0f;
        private float moveAcceleration = 25.0f;
        private float moveDeceleration = 15.0f;
        private float speedForward = 0.0f;
        private float speedSide = 0.0f;
        private float fallAcceleration = this.baseGravity;
        private float fallSpeed = 0.0f;
        private float terminalVelocity = 40.0f;
        private double period = 0.0;
        private double periodSpeed = 0.0;
        private double periodAcceleration = Math.toRadians(600.0);
        private double maxPeriodSpeed = Math.toRadians(720.0);
        private double yBobScale = 0.03f;
        private double xBobScale = 0.04f;
        private double yBob = 0.0;
        private double xBob = 0.0;
        private float headHeight = 1.7f;
        private Vector3f location = new Vector3f();
        private float epsilon = 1.0E-4f;
        private CollisionMesh collisionMesh;
        private float jumpImpulse = 12.0f;
        private float jumpDecay = 40.0f;
        private float jumpVelocity = this.jumpImpulse;
        private boolean jumping = false;
        private boolean jumpReady = true;
        private boolean swimming = false;
        private boolean allInWater = false;
        private float autoClimbSpeed = 3.0f;
        private float correctionSpeed = 2.5f;

        public WalkCameraTask(World world, GameClient gameClient) {
            super(world, gameClient);
        }

        public void initialize() {
            this.collisionMesh = this.createPersonMesh();
        }

        public void setPosition(float x, float y, float z) {
            this.location.set(x, y - this.headHeight, z);
            super.setPosition(x, y, z);
        }

        private void move(float value, Vector3f working) {
            Vector3f vel = this.moveVector.clone();
            float y = vel.y;
            if (!this.allInWater) {
                vel.y = 0.0f;
            }
            vel.multLocal(value * this.speedForward);
            working.addLocal(vel);
        }

        private void strafe(float value, Vector3f working) {
            Vector3f vel = this.leftVector.clone();
            vel.multLocal(value * this.speedSide);
            working.addLocal(vel);
        }

        protected boolean isMoving() {
            return true;
        }

        protected void doMovement(PhysicsThread anim, Vector3f working, double seconds) {
            if (seconds > 1.0) {
                return;
            }
            float value = (float)seconds;
            Vector3f pos = this.location.clone();
            float f = this.movementSpeed = this.isOn((byte)-128) ? 4.5f : 3.0f;
            if (this.isOn((byte)1)) {
                this.speedForward = Math.min(this.movementSpeed, this.speedForward + this.moveAcceleration * value);
            }
            if (this.isOn((byte)2)) {
                this.speedForward = Math.max(-this.movementSpeed, this.speedForward + this.moveAcceleration * -value);
            }
            if (this.isOn((byte)8)) {
                this.speedSide = Math.max(-this.movementSpeed, this.speedSide + this.moveAcceleration * -value);
            }
            if (this.isOn((byte)4)) {
                this.speedSide = Math.min(this.movementSpeed, this.speedSide + this.moveAcceleration * value);
            }
            if (value * this.speedForward > 1.0f) {
                System.out.println("************* YIKES THAT'S MOVING FAST ***********  seconds:" + seconds);
            }
            this.move(value, pos);
            this.strafe(value, pos);
            int typeAtFeet = this.getBlockType(pos.x, pos.z, pos.y);
            int typeAtHead = this.getBlockType(pos.x, pos.z, pos.y + this.headHeight);
            boolean inWater = false;
            boolean oldHeadInWater = this.headInWater;
            if (!(this.walkOnWater || typeAtFeet != 7 && typeAtFeet != 8)) {
                if (typeAtHead == 7) {
                    this.headInWater = true;
                    inWater = true;
                } else if (typeAtHead == 8) {
                    inWater = true;
                    float yHead = pos.y + this.headHeight;
                    float yHeadDelta = yHead - (float)Math.floor(yHead);
                    this.headInWater = yHeadDelta < 0.89f;
                } else {
                    this.headInWater = false;
                }
            } else {
                boolean bl = this.headInWater = typeAtHead == 7 || typeAtHead == 8;
            }
            if (this.headInWater) {
                if (!this.swimming) {
                    this.fallAcceleration = 0.5f;
                }
                this.terminalVelocity = 2.0f;
            } else if (inWater) {
                if (!this.swimming) {
                    this.fallAcceleration = 2.0f;
                }
                this.terminalVelocity = 10.0f;
            } else {
                this.fallAcceleration = this.baseGravity;
                this.terminalVelocity = 40.0f;
            }
            boolean bl = this.allInWater = this.headInWater && inWater;
            if (this.isOn((byte)64)) {
                if (this.jumpReady) {
                    this.jumping = true;
                    this.jumpVelocity = Math.max(0.0f, this.jumpVelocity - this.jumpDecay * value);
                    pos.y += this.jumpVelocity * value;
                    this.fallSpeed = 0.0f;
                    if (this.jumpVelocity == 0.0f) {
                        this.jumpReady = false;
                        this.jumping = false;
                    }
                }
            } else if (this.jumping) {
                this.jumpVelocity = 0.0f;
                pos.y += this.jumpVelocity * value;
                this.fallSpeed = 0.0f;
                if (this.jumpVelocity == 0.0f) {
                    this.jumpReady = false;
                    this.jumping = false;
                }
            }
            this.collisionMesh.position.set(pos.x, pos.y, pos.z);
            long start = System.nanoTime();
            List<Contact> contacts = this.gameClient.getCollisions().getCollisions(this.collisionMesh, this.maskStrat, new ArrayList<Contact>());
            boolean fallStopped = false;
            boolean canJumpIfNotFalling = true;
            Vec3d min = new Vec3d();
            Vec3d max = new Vec3d();
            double highestPushback = 0.0;
            Vector3f moveVec = pos.subtract(this.location);
            for (Contact c : contacts) {
                boolean up;
                Vec3d adjust = c.contactNormal.mult(c.penetration);
                Vec3d normal = c.contactNormal;
                if (c.mesh1 != this.collisionMesh) {
                    adjust.multLocal(-1.0);
                    normal = normal.mult(-1.0);
                    up = c.contactNormal.y < 0.0;
                } else {
                    up = c.contactNormal.y > 0.0;
                }
                Vector3f temp = new Vector3f((float)normal.x, (float)normal.y, (float)normal.z);
                float dot = moveVec.dot(temp);
                if ((double)dot < -0.01 && c.contactPoint.y > highestPushback) {
                    highestPushback = c.contactPoint.y;
                }
                min.x = min.x < adjust.x ? min.x : adjust.x;
                min.y = min.y < adjust.y ? min.y : adjust.y;
                min.z = min.z < adjust.z ? min.z : adjust.z;
                max.x = max.x > adjust.x ? max.x : adjust.x;
                max.y = max.y > adjust.y ? max.y : adjust.y;
                double d = max.z = max.z > adjust.z ? max.z : adjust.z;
                if (!up) continue;
                fallStopped = true;
            }
            Vec3d posd = new Vec3d(pos.x, pos.y, pos.z);
            if (highestPushback > 0.0) {
                if ((highestPushback -= (double)pos.y) < 0.6) {
                    fallStopped = true;
                    posd.y += seconds * (double)this.autoClimbSpeed;
                } else if (highestPushback < 1.0) {
                    fallStopped = true;
                    posd.y += seconds * (double)this.autoClimbSpeed * 0.5;
                    canJumpIfNotFalling = false;
                } else if (highestPushback < 1.5) {
                    fallStopped = true;
                    posd.y += seconds * (double)this.autoClimbSpeed * 0.2;
                    canJumpIfNotFalling = false;
                } else if (highestPushback < 1.71) {
                    fallStopped = true;
                    posd.y += seconds * (double)this.autoClimbSpeed * 0.1;
                    canJumpIfNotFalling = false;
                }
            }
            posd.addLocal(min);
            posd.addLocal(max);
            pos.set((float)posd.x, (float)posd.y, (float)posd.z);
            long end2 = System.nanoTime();
            if (end2 - start > 10000000L) {
                System.out.println("Total contact resolution time:" + (double)(end2 - start) / 1000000.0 + " ms");
            }
            if (fallStopped) {
                this.fallSpeed = 0.0f;
                if (canJumpIfNotFalling) {
                    this.jumpReady = true;
                    this.jumpVelocity = this.jumpImpulse;
                }
            } else {
                this.fallSpeed = Math.max(-this.terminalVelocity, this.fallSpeed - this.fallAcceleration * value);
                if (!this.jumping) {
                    this.jumpReady = false;
                }
            }
            this.speedForward = this.speedForward < 0.0f ? Math.min(0.0f, this.speedForward + this.moveDeceleration * (float)seconds) : Math.max(0.0f, this.speedForward - this.moveDeceleration * (float)seconds);
            this.speedSide = this.speedSide < 0.0f ? Math.min(0.0f, this.speedSide + this.moveDeceleration * (float)seconds) : Math.max(0.0f, this.speedSide - this.moveDeceleration * (float)seconds);
            if (this.isOn((byte)64) && inWater) {
                this.swimming = true;
                if (this.fallSpeed < 0.0f && (double)this.fallSpeed > -1.5) {
                    this.fallSpeed = 0.0f;
                }
                this.fallAcceleration = -4.0f;
            } else if (this.swimming) {
                this.swimming = false;
                if (inWater && this.fallSpeed > 0.0f) {
                    this.fallSpeed = 0.0f;
                }
            }
            if (this.fallSpeed * value > 1.0f) {
                System.out.println("************* YIKES THAT'S FALLING FAST ***********  seconds:" + seconds);
            }
            pos.y += this.fallSpeed * value;
            if (this.speedForward != 0.0f) {
                this.periodSpeed = Math.min(this.maxPeriodSpeed, this.periodSpeed + this.periodAcceleration * (double)value);
            } else {
                this.periodSpeed = 0.0;
                this.periodSpeed = 0.0;
                float xInterpSpeed = Math.max(0.1f, (float)Math.abs(this.xBob)) * 2.0f;
                float yInterpSpeed = Math.max(0.1f, (float)Math.abs(this.yBob)) * 2.0f;
                this.period = 0.0;
                if (this.yBob < 0.0) {
                    this.yBob = Math.min(this.yBob + (double)(yInterpSpeed * value), 0.0);
                } else if (this.yBob > 0.0) {
                    this.yBob = Math.max(this.yBob - (double)(yInterpSpeed * value), 0.0);
                }
                if (this.xBob < 0.0) {
                    this.xBob = Math.min(this.xBob + (double)(xInterpSpeed * value), 0.0);
                } else if (this.xBob > 0.0) {
                    this.xBob = Math.max(this.xBob - (double)(xInterpSpeed * value), 0.0);
                }
            }
            this.period += this.periodSpeed * (double)value;
            Vector3f bobOffset = new Vector3f();
            if (this.period != 0.0) {
                if (this.period >= 12.566370964050293) {
                    this.period -= 12.566370964050293;
                }
                this.yBob = Math.sin(this.period) * this.yBobScale;
                this.xBob = Math.cos(this.period * 0.5 + Math.toRadians(90.0)) * this.xBobScale;
            }
            if (this.xBob != 0.0 || this.yBob != 0.0) {
                bobOffset.set(this.leftVector);
                bobOffset.multLocal((float)this.xBob);
                bobOffset.y += (float)this.yBob;
            }
            if (pos.y < 0.0f) {
                pos.y = 0.0f;
            }
            this.location.set(pos.x, pos.y, pos.z);
            working.set(pos.x + bobOffset.x, pos.y + this.headHeight + bobOffset.y, pos.z + bobOffset.z);
        }
    }

    public static class HoverCameraTask
    extends CameraTask {
        private float movementSpeed = 10.0f;

        public HoverCameraTask(World world, GameClient gameClient) {
            super(world, gameClient);
        }

        private void elevate(float value, Vector3f working) {
            Vector3f vel = new Vector3f(0.0f, value * this.movementSpeed, 0.0f);
            working.addLocal(vel);
        }

        private void move(float value, Vector3f working) {
            Vector3f vel = this.moveVector.clone();
            vel.multLocal(value * this.movementSpeed);
            working.addLocal(vel);
        }

        private void strafe(float value, Vector3f working) {
            Vector3f vel = this.leftVector.clone();
            vel.multLocal(value * this.movementSpeed);
            working.addLocal(vel);
        }

        protected boolean isMoving() {
            return true;
        }

        protected void doMovement(PhysicsThread anim, Vector3f working, double seconds) {
            if (this.isOn((byte)1)) {
                this.move((float)seconds, working);
            }
            if (this.isOn((byte)2)) {
                this.move(-((float)seconds), working);
            }
            if (this.isOn((byte)16)) {
                this.elevate((float)seconds, working);
            }
            if (this.isOn((byte)32)) {
                this.elevate(-((float)seconds), working);
            }
            if (this.isOn((byte)4)) {
                this.strafe((float)seconds, working);
            }
            if (this.isOn((byte)8)) {
                this.strafe(-((float)seconds), working);
            }
        }
    }
}

