/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.GameAppState;
import mythruna.client.GameClient;
import mythruna.client.ui.Label;
import mythruna.client.ui.ObservableState;
import mythruna.client.view.BuilderReference;
import mythruna.client.view.LocalArea;
import mythruna.db.LeafData;
import mythruna.db.LeafInfo;

public class DebugHudState
extends ObservableState {
    private Node hud;
    private BitmapFont guiFont;
    private Node main;
    private GameClient gameClient;
    private LocalArea localArea;
    private BitmapText timeLabel;
    private BitmapText dateLabel;
    private BitmapText lightLabel;
    private BitmapText clipLabel;
    private BitmapText leafLabel;
    private BitmapText loadingLabel;
    private BitmapText locationLabel;
    private BitmapText memoryLabel;
    private List<Label> building = new ArrayList<Label>();
    private int lastHour = 0;
    private int lastMinute = 0;
    private int lastSunLevel = -1;
    private int lastLightLevel = -1;
    private int lastType = -1;
    private int lastClip = -1;
    private String lastLoc = null;
    private LeafData lastLeaf = null;
    private int lastDay = -1;
    private int pending = -1;
    private int lastMemTotal = -1;
    private Runtime runtime = Runtime.getRuntime();
    private boolean showBuilding = false;
    private float panelHeight = 0.0f;
    private boolean bottom = true;

    public DebugHudState(Node hud, BitmapFont guiFont) {
        super("Debug HUD", true);
        this.hud = hud;
        this.guiFont = guiFont;
    }

    public void setBottom(boolean f) {
        if (this.bottom == f) {
            return;
        }
        Application app = this.getApplication();
        this.bottom = f;
        if (this.bottom) {
            this.main.setLocalTranslation((float)app.getCamera().getWidth(), 0.0f, 0.0f);
        } else {
            this.main.setLocalTranslation((float)app.getCamera().getWidth(), (float)app.getCamera().getHeight() - this.panelHeight, 0.0f);
        }
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.gameClient = this.getState(GameAppState.class).getGameClient();
        this.localArea = this.getState(GameAppState.class).getLocalArea();
        this.main = new Node("Debug HUD");
        this.hud.attachChild((Spatial)this.main);
        Camera cam = app.getCamera();
        float debugHudScale = (float)app.getCamera().getWidth() / 1280.0f;
        if (debugHudScale > 1.0f) {
            debugHudScale = 1.0f;
        }
        this.main.setLocalScale(debugHudScale);
        this.main.setLocalTranslation((float)app.getCamera().getWidth(), 0.0f, 0.0f);
        float y = 0.0f;
        this.locationLabel = new BitmapText(this.guiFont, false);
        this.locationLabel.setSize(17.0f);
        this.locationLabel.setText("1000.00, 1000.00, 1000.00");
        y = this.locationLabel.getLineHeight();
        this.locationLabel.setLocalTranslation(-this.locationLabel.getLineWidth() - 20.0f, y, 0.0f);
        this.main.attachChild((Spatial)this.locationLabel);
        this.timeLabel = new BitmapText(this.guiFont, false);
        this.timeLabel.setSize(17.0f);
        this.timeLabel.setText("00:00");
        this.timeLabel.setLocalTranslation(-this.timeLabel.getLineWidth() - 20.0f, y += this.timeLabel.getLineHeight(), 0.0f);
        this.main.attachChild((Spatial)this.timeLabel);
        this.dateLabel = new BitmapText(this.guiFont, false);
        this.dateLabel.setSize(17.0f);
        this.dateLabel.setText("Month Name 99, 9999");
        this.dateLabel.setLocalTranslation(-this.timeLabel.getLineWidth() - this.dateLabel.getLineWidth() - 40.0f, y, 0.0f);
        this.main.attachChild((Spatial)this.dateLabel);
        this.clipLabel = new BitmapText(this.guiFont, false);
        this.clipLabel.setSize(15.0f);
        this.clipLabel.setText("Clip: Nearest");
        this.clipLabel.setLocalTranslation(-this.clipLabel.getLineWidth() - 120.0f, y += this.clipLabel.getLineHeight(), 0.0f);
        this.main.attachChild((Spatial)this.clipLabel);
        this.lightLabel = new BitmapText(this.guiFont, false);
        this.lightLabel.setSize(15.0f);
        this.lightLabel.setText("00/00 @ 00");
        this.lightLabel.setLocalTranslation(-this.lightLabel.getLineWidth() - 20.0f, y, 0.0f);
        this.main.attachChild((Spatial)this.lightLabel);
        this.leafLabel = new BitmapText(this.guiFont, false);
        this.leafLabel.setSize(15.0f);
        this.leafLabel.setText("Leaf: 255, 255, 255 v:12345");
        this.leafLabel.setLocalTranslation(-this.leafLabel.getLineWidth() - 20.0f, y += this.leafLabel.getLineHeight(), 0.0f);
        this.main.attachChild((Spatial)this.leafLabel);
        this.memoryLabel = new BitmapText(this.guiFont, false);
        this.memoryLabel.setSize(15.0f);
        this.memoryLabel.setText("Mem: 100%");
        float x = -this.memoryLabel.getLineWidth() - 10.0f;
        this.memoryLabel.setLocalTranslation(x, y += this.memoryLabel.getLineHeight(), 0.0f);
        long maxMemory = this.runtime.maxMemory();
        if (maxMemory < 512000000L) {
            this.memoryLabel.setColor(ColorRGBA.Red);
        }
        this.main.attachChild((Spatial)this.memoryLabel);
        this.loadingLabel = new BitmapText(this.guiFont, false);
        this.loadingLabel.setSize(15.0f);
        this.loadingLabel.setText("Loading Status");
        x -= this.loadingLabel.getLineWidth();
        this.loadingLabel.setLocalTranslation(x -= 40.0f, y, 0.0f);
        this.main.attachChild((Spatial)this.loadingLabel);
        if (this.showBuilding) {
            y += 15.0f;
            for (int i = 0; i < 10; ++i) {
                Label l = new Label(this.guiFont);
                l.setLocalTranslation(-this.leafLabel.getLineWidth() - 50.0f, y, 0.0f);
                l.setText("Leaf: 255, 255, 255 v:12345");
                l.setCullHint(Spatial.CullHint.Always);
                this.building.add(l);
                this.main.attachChild((Spatial)l);
                y += 15.0f;
            }
        } else {
            y += 15.0f;
        }
        this.panelHeight = y;
    }

    protected void enable() {
        if (this.main.getParent() != null) {
            return;
        }
        this.hud.attachChild((Spatial)this.main);
    }

    protected void disable() {
        this.hud.detachChild((Spatial)this.main);
    }

    public void update(float tpf) {
        long maxMemory;
        long usedMemory;
        int memTotal;
        int day;
        Object m;
        float gameTime = GameAppState.environment.getTime();
        int hour = (int)gameTime;
        int minute = (int)((gameTime - (float)hour) * 60.0f);
        if (hour != this.lastHour || minute != this.lastMinute) {
            String h = hour < 10 ? "0" + hour : "" + hour;
            m = minute < 10 ? "0" + minute : "" + minute;
            this.timeLabel.setText(h + ":" + (String)m);
            this.lastHour = hour;
            this.lastMinute = minute;
        }
        if ((day = this.gameClient.getTimeProvider().getGameDay()) != this.lastDay) {
            this.lastDay = day;
            m = this.gameClient.getTimeProvider().getMonth();
            int d = this.gameClient.getTimeProvider().getMonthDay();
            int y = this.gameClient.getTimeProvider().getYear();
            this.dateLabel.setText((Object)m + " " + (d + 1) + ", " + (100 + y));
        }
        int sunLevel = this.localArea.getCenterSunlightValue();
        int lightLevel = this.localArea.getCenterLocalLightValue();
        int type = this.localArea.getCenterType();
        if (this.lastSunLevel != sunLevel || this.lastLightLevel != lightLevel || this.lastType != type) {
            this.lightLabel.setText(lightLevel + "/" + sunLevel + " @ " + type);
            this.lastSunLevel = sunLevel;
            this.lastLightLevel = lightLevel;
            this.lastType = type;
        }
        if (this.lastLeaf != this.localArea.getCenter()) {
            this.lastLeaf = this.localArea.getCenter();
            if (this.lastLeaf != null) {
                LeafInfo info = this.lastLeaf.getInfo();
                this.leafLabel.setText("Leaf:" + info.x + ", " + info.y + ", " + info.z + " v:" + info.version);
            }
        }
        if (this.pending != this.localArea.getPendingSize()) {
            this.pending = this.localArea.getPendingSize();
            if (this.pending == 0) {
                this.loadingLabel.setText("");
            } else {
                this.loadingLabel.setText("* Loading *");
            }
        }
        if (this.lastClip != this.localArea.getClipDistance()) {
            this.lastClip = this.localArea.getClipDistance();
            this.clipLabel.setText("Clip:" + this.lastClip * 32 + " m");
        }
        Vector3f ourPos = this.localArea.getLocation();
        String loc = String.format("%.2f, %.2f, %.2f", Float.valueOf(ourPos.x), Float.valueOf(ourPos.y), Float.valueOf(ourPos.z));
        if (!loc.equals(this.lastLoc)) {
            this.lastLoc = loc;
            this.locationLabel.setText(loc);
            Camera cam = this.getApplication().getCamera();
            this.locationLabel.setLocalTranslation(-this.locationLabel.getLineWidth() - 20.0f, this.locationLabel.getLineHeight(), 0.0f);
        }
        if (this.lastMemTotal != (memTotal = (int)((usedMemory = this.runtime.totalMemory() - this.runtime.freeMemory()) * 100L / (maxMemory = this.runtime.maxMemory())))) {
            this.lastMemTotal = memTotal;
            this.memoryLabel.setText("Mem: " + this.lastMemTotal + "%");
        }
        if (this.showBuilding) {
            int index = 0;
            Label l = this.building.get(index++);
            l.setText("Pending:" + this.localArea.getLeafBuilder().getPendingSize());
            l.setCullHint(Spatial.CullHint.Never);
            for (BuilderReference ref : this.localArea.getLeafBuilder().getWorking()) {
                l = this.building.get(index++);
                if (index == 9) {
                    l.setText("More...");
                    l.setCullHint(Spatial.CullHint.Never);
                    continue;
                }
                l.setText(String.valueOf(ref));
                l.setCullHint(Spatial.CullHint.Never);
            }
            while (index < 10) {
                l = this.building.get(index++);
                l.setCullHint(Spatial.CullHint.Always);
            }
        }
    }
}

