/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import java.io.File;
import mythruna.DefaultPlayerContext;
import mythruna.DefaultPlayerPermissions;
import mythruna.DefaultWorld;
import mythruna.GameSystems;
import mythruna.PlayerContext;
import mythruna.PlayerData;
import mythruna.PlayerPermissions;
import mythruna.World;
import mythruna.WorldInfo;
import mythruna.client.AbstractGameClient;
import mythruna.client.ClientOptions;
import mythruna.client.LocalWorldDatabase;
import mythruna.client.PhysicsThread;
import mythruna.client.Progress;
import mythruna.client.TimeLog;
import mythruna.client.shell.DefaultConsole;
import mythruna.client.shell.ResetOptionsCommand;
import mythruna.db.ColumnFactory;
import mythruna.db.DefaultBlueprintDatabase;
import mythruna.db.DefaultLeafDatabase;
import mythruna.db.DefaultLeafFileLocator;
import mythruna.db.WorldUtils;
import mythruna.db.user.DefaultUserDatabase;
import mythruna.db.user.UserDatabase;
import mythruna.es.EntityAction;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.sql.SqlEntityData;
import mythruna.event.PlayerEvent;
import mythruna.event.PlayerEvents;
import mythruna.phys.CollisionSystem;
import mythruna.script.ActionParameter;
import mythruna.script.ActionReference;
import mythruna.sim.QueuedCellAccess;
import org.progeeks.tool.console.ShellCommand;

public class LocalGameClient
extends AbstractGameClient {
    private EntityId playerEntity = new EntityId(Integer.MIN_VALUE);
    private EntityData ed;
    private GameSystems gameSystems;
    private PlayerContext playerContext;
    private PlayerPermissions perms;
    private UserDatabase userDb;
    private PlayerData playerData;
    private Progress progress = Progress.get("GameClient");

    public LocalGameClient() {
        this.progress.setMax(0);
    }

    public void initialize() {
        super.initialize();
        TimeLog.log(this.getClass().getSimpleName(), "Creating console");
        this.console = new DefaultConsole();
        this.console.registerCommand("resetopts", (ShellCommand)new ResetOptionsCommand());
        TimeLog.log(this.getClass().getSimpleName(), "Creating world...");
        this.progress.setMessage("Creating World...");
        this.setWorld(this.createWorld(0));
        this.setLocation(512.5f, 512.5f, 80.0f);
        this.console.setLocalVariable("opts", ClientOptions.getInstance());
        TimeLog.log(this.getClass().getSimpleName(), "Creating player permissions.");
        this.perms = new DefaultPlayerPermissions(this.playerEntity, this.ed);
        TimeLog.log(this.getClass().getSimpleName(), "Creating game systems.");
        this.progress.setMessage("Creating Game Systems...");
        this.gameSystems = new GameSystems(this.getWorld());
        TimeLog.log(this.getClass().getSimpleName(), "Setting up scripts");
        this.gameSystems.getScriptManager().addStandardScripts();
        this.gameSystems.getScriptManager().addScript("/mythruna/script/ClientEnvironment.groovy");
        this.gameSystems.getScriptManager().addScript(new File("mods/scripts"));
        this.gameSystems.getScriptManager().setBinding("gameClient", this);
        this.gameSystems.getDialogManager().addRoot(new File("mods/dialog"));
        this.gameSystems.getDialogManager().addRoot("/dialog");
        this.gameSystems.getDialogManager().addStartupScript("/mythruna/script/BaseDialogEnvironment.groovy");
    }

    public GameSystems getGameSystems() {
        return this.gameSystems;
    }

    private World createWorld(int seed) {
        WorldInfo info;
        File baseDir = new File("mythruna.db");
        this.userDb = new DefaultUserDatabase(new File(baseDir, "users"));
        this.playerData = this.userDb.getUser("SinglePlayer");
        if (this.playerData == null) {
            this.playerData = this.userDb.createUser("SinglePlayer", "SinglePlayer");
            this.playerData.set("characterInfo.name", "SinglePlayer");
            this.playerData.save();
        }
        if ((info = WorldInfo.load(baseDir)) == null) {
            info = WorldInfo.create(baseDir, "Mythruna:" + seed, seed);
        } else {
            seed = info.getSeed();
        }
        System.out.println("Loading world with seed:" + seed);
        DefaultLeafDatabase leafDb = new DefaultLeafDatabase(baseDir, seed);
        DefaultBlueprintDatabase bpDb = new DefaultBlueprintDatabase(new File(baseDir, "blueprints"));
        DefaultLeafFileLocator locator = new DefaultLeafFileLocator(baseDir);
        ColumnFactory colFactory = WorldUtils.createDefaultColumnFactory(locator, seed);
        LocalWorldDatabase worldDb = new LocalWorldDatabase(leafDb, colFactory);
        try {
            this.ed = new SqlEntityData("mythruna.db/entities", 100L);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing entity database", e);
        }
        return new DefaultWorld(worldDb, bpDb, this.ed);
    }

    public int getId() {
        return -1;
    }

    public EntityId getPlayer() {
        return this.playerEntity;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public CollisionSystem getCollisions() {
        return this.gameSystems.getCollisions();
    }

    public void start() {
        System.out.println("LocalGameClient.start...........");
        TimeLog.log(this.getClass().getSimpleName(), "Starting game client.");
        World world = this.getWorld();
        world.setCellAccess(new QueuedCellAccess(this.playerEntity, this.gameSystems.getSimulation(), world.getWorldDatabase()));
        this.playerContext = new DefaultPlayerContext(this.gameSystems, this.playerEntity, this.playerData, this.console, this.console.getShell(), this.perms);
        TimeLog.log(this.getClass().getSimpleName(), "Starting game systems...");
        this.progress.setMessage("Starting Game Systems...");
        this.gameSystems.start();
        this.setGameTime(this.gameSystems.getGameTime());
        TimeLog.log(this.getClass().getSimpleName(), "Starting animation thread.");
        this.cameraTask.initialize();
        PhysicsThread.instance.start();
        TimeLog.log(this.getClass().getSimpleName(), "Publishing player joined event.");
        this.gameSystems.getEventDispatcher().publishEvent(PlayerEvents.playerJoined, new PlayerEvent(this.playerContext));
        TimeLog.log(this.getClass().getSimpleName(), "Game client started.");
    }

    public void close() {
        this.gameSystems.getEventDispatcher().publishEvent(PlayerEvents.playerLeft, new PlayerEvent(this.playerContext));
        PhysicsThread.instance.removeTask(this.cameraTask);
        this.gameSystems.shutdown();
        this.ed.close();
        this.world.getWorldDatabase().close();
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isLoggedIn() {
        return true;
    }

    protected long toSimTime(long raw) {
        return raw;
    }

    public PlayerPermissions getPerms() {
        return this.perms;
    }

    public void executeAction(EntityAction action, EntityId target) {
        action.runAction(this, target);
    }

    public void executeRef(ActionReference ref, ActionParameter parm) {
        this.gameSystems.getActionManager().execute(ref.getId(), this.playerContext, parm);
    }

    public void executeRef(ActionReference ref, EntityId target, ActionParameter parm) {
        this.gameSystems.getActionManager().execute(ref.getId(), this.playerContext, target, parm);
    }

    public void execute(String action, EntityId source, ActionParameter target) {
        this.gameSystems.getActionManager().execute(action, this.playerContext, source, target);
    }
}

