/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.Slider;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import mythruna.client.ClientOptions;
import org.progeeks.util.Inspector;

public class OptionsScreen
implements ScreenController {
    private Nifty nifty;
    private Screen screen;
    private ClientOptions options = ClientOptions.getInstance();

    public void bind(Nifty nifty, Screen screen) {
        System.out.println("---------------------bind:" + screen);
        this.nifty = nifty;
        this.screen = screen;
        if ("options".equals(screen.getScreenId())) {
            this.setupOptions();
        }
    }

    public void onStartScreen() {
        System.out.println("---------------------onStartScreen:" + this.screen.getScreenId());
    }

    public void onEndScreen() {
        System.out.println("---------------------onEndScreen:" + this.screen.getScreenId());
        this.options.save();
    }

    public void go(String screen) {
        System.out.println("go(" + screen + ")");
        this.nifty.gotoScreen(screen);
    }

    public void moved(String s) {
        System.out.println("moved(" + s + ")");
        Slider slider = (Slider)this.screen.findNiftyControl(s, Slider.class);
        Inspector ins = new Inspector((Object)ClientOptions.getInstance());
        ins.set(s, (Object)Float.valueOf(slider.getValue() / 100.0f));
    }

    protected void setupOptions() {
        ClientOptions options = ClientOptions.getInstance();
        for (String s : options.options()) {
            Object value = options.getOption(s);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                CheckBox check = (CheckBox)this.screen.findNiftyControl(s, CheckBox.class);
                check.setChecked(b.booleanValue());
                continue;
            }
            if (!(value instanceof Float)) continue;
            Float f = (Float)value;
            Slider slider = (Slider)this.screen.findNiftyControl(s, Slider.class);
            slider.setValue(f.floatValue() * 100.0f);
        }
    }

    public String getOption(String opt) {
        Inspector ins = new Inspector((Object)ClientOptions.getInstance());
        String result = String.valueOf(ins.get(opt));
        return "false";
    }

    public void toggleOption(String opt) {
        Inspector ins = new Inspector((Object)ClientOptions.getInstance());
        CheckBox check = (CheckBox)this.screen.findNiftyControl(opt, CheckBox.class);
        boolean val = !check.isChecked();
        ins.set(opt, (Object)val);
        check.setChecked(val);
    }
}

