/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Vector3i;
import mythruna.client.view.LocalArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldIntersector
implements Iterator<Intersection> {
    private LocalArea localArea;
    private Ray ray;
    private PlaneIntersector[] planeIntersects;
    private float distance;
    private float epsilon = 1.0E-6f;
    private Intersection next;
    private Set<Integer> skip;

    public WorldIntersector(LocalArea localArea, Ray ray, Integer ... skipTypes) {
        this.localArea = localArea;
        this.ray = ray;
        if (skipTypes != null) {
            this.skip = new HashSet<Integer>(Arrays.asList(skipTypes));
        }
        this.planeIntersects = new PlaneIntersector[]{new PlaneIntersector(ray, 0), new PlaneIntersector(ray, 1), new PlaneIntersector(ray, 2)};
    }

    private int minIndex(float ... vals) {
        int minIndex = 0;
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == Float.NaN || !(vals[i] < min)) continue;
            min = vals[i];
            minIndex = i;
        }
        return minIndex;
    }

    protected void fetch() {
        if (this.next != null) {
            return;
        }
        while (this.distance < this.ray.getLimit()) {
            Vector3f better;
            BlockType blockType;
            float[] dists = new float[]{this.planeIntersects[0].getNextLength(), this.planeIntersects[1].getNextLength(), this.planeIntersects[2].getNextLength()};
            int minIndex = this.minIndex(dists);
            this.distance = this.planeIntersects[minIndex].getNextLength();
            Vector3f blockIntersect = this.planeIntersects[minIndex].getNextBlockIntersect();
            Vector3f intersect = this.planeIntersects[minIndex].next();
            int type = this.localArea.getBlockType((int)blockIntersect.x, (int)blockIntersect.y, (int)blockIntersect.z);
            if (type == 0 || this.skip != null && this.skip.contains(type) || !(blockType = BlockTypeIndex.types[type]).intersects(blockIntersect, this.ray.getOrigin(), this.ray.getDirection())) continue;
            int side = -1;
            if (blockIntersect.x == intersect.x) {
                side = 3;
            } else if (blockIntersect.x + 1.0f == intersect.x) {
                side = 2;
            } else if (blockIntersect.y == intersect.y) {
                side = 0;
            } else if (blockIntersect.y + 1.0f == intersect.y) {
                side = 1;
            } else if (blockIntersect.z == intersect.z) {
                side = 5;
            } else if (blockIntersect.z + 1.0f == intersect.z) {
                side = 4;
            }
            if (side < 0) {
                System.out.println("Got an intersect from:" + blockType + " at:" + blockIntersect + " but it doesn't match:" + intersect);
                continue;
            }
            if (!(blockType.isSolid(side) && blockType.isBoundary(side) || (better = blockType.getIntersection(blockIntersect, this.ray.getOrigin(), this.ray.getDirection())) == null)) {
                intersect = better;
            }
            this.next = new Intersection(intersect, new Vector3i(blockIntersect), type, side);
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.next != null;
    }

    @Override
    public Intersection next() {
        Intersection result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported on intersectors.");
    }

    private static class PlaneIntersector {
        private Vector3f start;
        private int axis = 0;
        private int step = 0;
        private float sign;
        private Vector3f dir;
        private float dirLength;
        private float nextLength;

        public PlaneIntersector(Ray ray, int axis) {
            this(ray.getOrigin(), ray.getDirection(), axis);
        }

        public PlaneIntersector(Vector3f pos, Vector3f heading, int axis) {
            this.axis = axis;
            this.sign = Math.signum(heading.get(axis));
            this.dir = heading.mult(this.sign / heading.get(axis));
            this.dirLength = this.sign == 0.0f ? Float.POSITIVE_INFINITY : this.dir.length();
            float grid = (float)Math.floor(pos.get(axis));
            if (this.sign > 0.0f) {
                grid += 1.0f;
            }
            float scale = (grid - pos.get(axis)) / this.sign;
            this.start = this.dir.mult(scale);
            this.nextLength = this.start.length();
            this.start.addLocal(pos);
        }

        public float getSign() {
            return this.sign;
        }

        public float getNextLength() {
            return this.nextLength;
        }

        public Vector3f getNextBlockIntersect() {
            Vector3f pos = this.getNextIntersect();
            Vector3f result = new Vector3f();
            result.x = (int)Math.floor(pos.x);
            result.y = (int)Math.floor(pos.y);
            result.z = (int)Math.floor(pos.z);
            if (this.sign < 0.0f) {
                result.set(this.axis, result.get(this.axis) - 1.0f);
            }
            return result;
        }

        public Vector3f getNextIntersect() {
            return this.start.add(this.dir.mult((float)this.step));
        }

        public Vector3f next() {
            Vector3f last = this.getNextIntersect();
            this.nextLength += this.dirLength;
            ++this.step;
            return last;
        }
    }

    public static class Intersection {
        private Vector3f point;
        private Vector3i block;
        private int type;
        private int side;

        public Intersection(Vector3f point, Vector3i block, int type, int side) {
            this.point = point;
            this.block = block;
            this.type = type;
            this.side = side;
        }

        public int getType() {
            return this.type;
        }

        public Vector3f getPoint() {
            return this.point;
        }

        public int getSide() {
            return this.side;
        }

        public Vector3i getBlock() {
            return this.block;
        }

        public String toString() {
            return "Intersection[block:" + this.block + ", hit:" + this.point + ", type:" + this.type + ", side:" + this.side + "]";
        }
    }
}

