/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.bm;

import java.util.Map;
import java.util.TreeMap;
import mythruna.client.bm.ObjectSelector;
import mythruna.client.bm.ObjectTool;
import mythruna.client.bm.Tool;
import mythruna.client.bm.ToolGroup;
import mythruna.es.BlueprintReference;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import org.progeeks.util.log.Log;

public class ObjectToolGroup
extends ToolGroup {
    static Log log = Log.getLog();
    private EntitySet blueprints;
    private Map<EntityId, ObjectTool> toolMap = new TreeMap<EntityId, ObjectTool>();

    public ObjectToolGroup(String name) {
        super(name);
    }

    public void initialize(ObjectSelector selector) {
        EntityData ed = selector.getWorld().getEntityData();
        this.blueprints = ed.getEntities(new FieldFilter<InContainer>(InContainer.class, "parentId", selector.getGameClient().getPlayer()), InContainer.class, BlueprintReference.class);
        for (Entity e : this.blueprints) {
            this.toolMap.put(e.getId(), new ObjectTool(e));
        }
        this.getTools().addAll(this.toolMap.values());
        int index = 0;
        for (Tool t : this.getTools()) {
            ((ObjectTool)t).setName("Object(" + index++ + ")");
        }
        super.initialize(selector);
    }

    public boolean update() {
        if (this.blueprints.applyChanges()) {
            ObjectTool tool;
            if (log.isTraceEnabled()) {
                log.trace((Object)"******* There are blueprint changes...");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("All:" + this.blueprints));
            }
            for (Entity e : this.blueprints.getAddedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  added:" + e));
                }
                tool = new ObjectTool(e);
                this.toolMap.put(e.getId(), tool);
                tool.initialize(this.getSelector());
            }
            for (Entity e : this.blueprints.getChangedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  changed:" + e));
                }
                tool = this.toolMap.get(e.getId());
                tool.update();
            }
            for (Entity e : this.blueprints.getRemovedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  removed:" + e));
                }
                if ((tool = this.toolMap.remove(e.getId())) == null) continue;
            }
            this.getTools().clear();
            this.getTools().addAll(this.toolMap.values());
            int index = 0;
            for (Tool t : this.getTools()) {
                ((ObjectTool)t).setName("Object(" + index++ + ")");
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "ObjectToolGroup[" + this.getName() + "]";
    }
}

