/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.env;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Random;

public class StarMesh
extends Mesh {
    private Random random = new Random(0L);

    public StarMesh(float radius, int numStars) {
        this.setMode(Mesh.Mode.Points);
        FloatBuffer positions = BufferUtils.createVector3Buffer((int)numStars);
        VertexBuffer pvb = new VertexBuffer(VertexBuffer.Type.Position);
        pvb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, (Buffer)positions);
        this.setBuffer(pvb);
        ByteBuffer colors = BufferUtils.createByteBuffer((int)(numStars * 4));
        VertexBuffer cvb = new VertexBuffer(VertexBuffer.Type.Color);
        cvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.UnsignedByte, (Buffer)colors);
        cvb.setNormalized(true);
        this.setBuffer(cvb);
        FloatBuffer sizes = BufferUtils.createFloatBuffer((int)numStars);
        VertexBuffer svb = new VertexBuffer(VertexBuffer.Type.Size);
        svb.setupData(VertexBuffer.Usage.Stream, 1, VertexBuffer.Format.Float, (Buffer)sizes);
        this.setBuffer(svb);
        FloatBuffer tb = BufferUtils.createFloatBuffer((int)(numStars * 4));
        VertexBuffer tvb = new VertexBuffer(VertexBuffer.Type.TexCoord);
        tvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.Float, (Buffer)tb);
        this.setBuffer(tvb);
        this.createStars(radius, numStars);
    }

    protected void createStars(float radius, int numStars) {
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer positions = (FloatBuffer)pvb.getData();
        VertexBuffer cvb = this.getBuffer(VertexBuffer.Type.Color);
        ByteBuffer colors = (ByteBuffer)cvb.getData();
        VertexBuffer svb = this.getBuffer(VertexBuffer.Type.Size);
        FloatBuffer sizes = (FloatBuffer)svb.getData();
        VertexBuffer tvb = this.getBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer texcoords = (FloatBuffer)tvb.getData();
        positions.rewind();
        colors.rewind();
        sizes.rewind();
        texcoords.rewind();
        for (int i = 0; i < numStars; ++i) {
            float a1 = (float)(this.random.nextDouble() * Math.PI * 4.0);
            float a2 = (float)(this.random.nextDouble() * Math.PI * 2.0 - Math.PI);
            float y = radius * FastMath.sin((float)a2);
            float scale = radius * FastMath.cos((float)a2);
            float x = scale * FastMath.cos((float)a1);
            float z = scale * FastMath.sin((float)a1);
            positions.put(x).put(y).put(z);
            sizes.put((float)this.random.nextDouble() * 5.0f);
            colors.putInt(-1);
            texcoords.put(0.0f).put(0.0f).put(0.06666667f).put(1.0f);
        }
        positions.flip();
        colors.flip();
        sizes.flip();
        texcoords.flip();
        pvb.updateData((Buffer)positions);
        cvb.updateData((Buffer)colors);
        svb.updateData((Buffer)sizes);
        tvb.updateData((Buffer)texcoords);
    }
}

