/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.gm;

import com.jme3.app.Application;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mythruna.client.ConveyerCamera;
import mythruna.client.GameClient;
import mythruna.client.gm.ItemToolState;
import mythruna.client.gm.ObjectGrid;
import mythruna.client.tabs.bp.BlueprintObject;
import mythruna.client.ui.ClickAction;
import mythruna.client.ui.Command;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.ObservableState;
import mythruna.client.view.BlockObject;
import mythruna.db.BlueprintData;
import mythruna.es.BlueprintReference;
import mythruna.es.Entity;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import mythruna.es.ModelInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryState
extends ObservableState {
    private GameClient client;
    private InputObserver inputListener = new InputObserver();
    private GridListener gridListener = new GridListener();
    private EntityId container;
    private EntitySet entities;
    private float additionalObjectScale = 1.0f;
    private ObjectGrid grid;
    private Map<EntityId, BlockObject> objectMap = new HashMap<EntityId, BlockObject>();

    public InventoryState(GameClient client) {
        super("ItemTool", false);
        this.client = client;
        this.container = client.getPlayer();
    }

    public void update(float tpf) {
        if (this.entities.applyChanges()) {
            this.addItems(this.entities.getAddedEntities());
            this.removeItems(this.entities.getRemovedEntities());
            this.updateItems(this.entities.getChangedEntities());
            this.grid.refreshView();
        }
        this.inputListener.update();
    }

    @Override
    public void initialize(Application app) {
        super.initialize(app);
        float baseScale = (float)app.getCamera().getHeight() / 720.0f;
        float maxScale = 1.0f;
        System.out.println("==================Base scale:" + baseScale);
        if (baseScale > maxScale) {
            this.additionalObjectScale = maxScale / baseScale;
            baseScale = maxScale;
        }
        this.grid = new ObjectGrid(this.getState(GuiAppState.class), app.getAssetManager(), "Inventory", 5, 4, 64.0f);
        this.grid.setLocalScale(baseScale);
        this.grid.setLocalTranslation(5.0f, (float)app.getCamera().getHeight() - this.grid.getHeight() - 25.0f, 0.0f);
    }

    public void cleanup() {
    }

    @Override
    protected void enable() {
        Camera cam = this.getState(GuiAppState.class).getCamera();
        this.getState(ConveyerCamera.class).setEnabled(false);
        cam.setLocation(new Vector3f(0.0f, 0.0f, 0.0f));
        cam.lookAtDirection(new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        this.getState(GuiAppState.class).addDependent(this);
        this.getApplication().getInputManager().addRawInputListener((RawInputListener)this.inputListener);
        this.getState(GuiAppState.class).getOrthoRoot().attachChild((Spatial)this.grid);
        FieldFilter<InContainer> filter = new FieldFilter<InContainer>(InContainer.class, "parentId", this.container);
        this.entities = this.client.getEntityData().getEntities(filter, InContainer.class, ModelInfo.class);
        this.addItems(this.entities);
        this.grid.addCommand(this.gridListener);
        this.grid.refreshView();
    }

    @Override
    protected void disable() {
        this.getState(ConveyerCamera.class).setEnabled(true);
        this.grid.removeCommand(this.gridListener);
        this.entities.release();
        this.objectMap.clear();
        this.grid.clear();
        this.getApplication().getInputManager().removeRawInputListener((RawInputListener)this.inputListener);
        this.getState(GuiAppState.class).removeDependent(this);
        this.getState(GuiAppState.class).getOrthoRoot().detachChild((Spatial)this.grid);
    }

    protected void addItems(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            BlockObject icon = this.objectMap.get(e.getId());
            if (icon == null) {
                System.out.println("Creating icon for:" + e);
                icon = this.createBlueprintIcon(e.get(ModelInfo.class));
                icon.setEntity(e.getId());
                this.objectMap.put(e.getId(), icon);
            }
            this.grid.addObject(icon);
        }
    }

    protected void updateItems(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        boolean modelsChanged = false;
        for (Entity e : set) {
            BlockObject icon = this.objectMap.get(e.getId());
            ModelInfo mi = e.get(ModelInfo.class);
            if (mi.getBlueprintId() == icon.getBlueprintId()) continue;
            modelsChanged = true;
            icon.setBlueprintId(mi.getBlueprintId());
            if (icon.isBuilt()) continue;
            icon.build();
            icon.applyUpdates(null);
        }
    }

    protected void removeItems(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            BlockObject bo = this.objectMap.remove(e);
            if (bo == null) continue;
            this.grid.removeObject(bo);
        }
    }

    protected BlockObject createBlueprintIcon(BlueprintReference ref) {
        BlueprintData bp = this.client.getWorld().getBlueprint(ref.getBlueprintId());
        if (bp == null) {
            throw new RuntimeException("No blueprint found for id:" + ref.getBlueprintId());
        }
        BlueprintObject bo = new BlueprintObject(bp);
        bo.pack();
        bp.cells = bo.getCells();
        bp.xSize = bo.getSizeX();
        bp.ySize = bo.getSizeY();
        bp.zSize = bo.getSizeZ();
        return this.createIcon(bp);
    }

    protected BlockObject createBlueprintIcon(ModelInfo mi) {
        BlueprintData bp = this.client.getWorld().getBlueprint(mi.getBlueprintId());
        if (bp == null) {
            throw new RuntimeException("No blueprint found for id:" + mi.getBlueprintId());
        }
        return this.createIcon(bp);
    }

    protected BlockObject createIcon(BlueprintData data) {
        BlockObject bo = new BlockObject(data, false);
        float max = Math.max(data.xSize, Math.max(data.ySize, data.zSize));
        System.out.println("Max dimension:" + max);
        max = (float)((double)max * Math.sqrt(2.0)) + 1.0f;
        float scale = 1.0f / max;
        System.out.println("Setting scale to:" + scale);
        bo.setScale(scale * this.additionalObjectScale);
        bo.setLighting(1.0f, 0.8f);
        bo.build();
        bo.applyUpdates(null);
        return bo;
    }

    private class InputObserver
    implements RawInputListener {
        private InputObserver() {
        }

        public void beginInput() {
        }

        public void endInput() {
        }

        public void onJoyAxisEvent(JoyAxisEvent evt) {
        }

        public void onJoyButtonEvent(JoyButtonEvent evt) {
        }

        public void onKeyEvent(KeyInputEvent evt) {
        }

        public void onMouseButtonEvent(MouseButtonEvent evt) {
        }

        protected void resetHover(long time) {
        }

        public void update() {
        }

        public void onMouseMotionEvent(MouseMotionEvent evt) {
        }

        public void onTouchEvent(TouchEvent evt) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GridListener
    implements Command<ClickAction> {
        private GridListener() {
        }

        @Override
        public void execute(Object source, ClickAction action) {
            System.out.println("*(***** :" + (Object)((Object)action));
            if (action == ClickAction.Enter) {
                BlockObject bo = InventoryState.this.grid.getSelectionModel().getSelected();
                if (bo == null) {
                    ((ItemToolState)InventoryState.this.getState(ItemToolState.class)).setToolEntity(null);
                } else {
                    ((ItemToolState)InventoryState.this.getState(ItemToolState.class)).setToolEntity(bo.getEntity());
                }
            }
        }
    }
}

