/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.gm;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import mythruna.client.CrosshairState;
import mythruna.client.DebugHudState;
import mythruna.client.GameAppState;
import mythruna.client.GameClient;
import mythruna.client.KeyMethodAction;
import mythruna.client.MainStart;
import mythruna.client.WorldIntersector;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.gm.ControlSlot;
import mythruna.client.gm.DefaultTool;
import mythruna.client.gm.Hit;
import mythruna.client.gm.InventoryState;
import mythruna.client.gm.Tool;
import mythruna.client.gm.ToolInputState;
import mythruna.client.gm.ToolOrb;
import mythruna.client.ui.ClickAction;
import mythruna.client.ui.Command;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.GuiUtils;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.PopupMenuState;
import mythruna.client.view.BlockObject;
import mythruna.client.view.DragControl;
import mythruna.client.view.LocalArea;
import mythruna.db.BlueprintData;
import mythruna.es.Entity;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import mythruna.es.ModelInfo;
import mythruna.item.HeldEntities;
import mythruna.script.EntityParameter;
import org.progeeks.util.ObjectUtils;

public class ItemToolState
extends ObservableState {
    private GameClient client;
    private EntitySet us;
    private LocalArea localArea;
    private Tool defaultTool;
    private Node hud;
    private ToolOrb leftOrb;
    private ToolOrb rightOrb;
    private float imageSize;
    private float margin;
    private float additionalObjectScale = 1.0f;
    private KeyMethodAction inventoryKey = new KeyMethodAction((Object)this, "toggleInventory", 23);
    private boolean inventoryEnabled = false;
    private ControlSlot slot = ControlSlot.RightHand;
    private KeyMethodAction slotKey = new KeyMethodAction((Object)this, "setLeftHandOn", 29, true);
    private ToolSlot[] slots = new ToolSlot[2];
    private Node perspectiveHud = null;
    private Quaternion lastCameraRotation;
    private EntitySet entities;

    public ItemToolState(GameClient client, LocalArea localArea, Node hud) {
        super("ItemTool", false);
        this.client = client;
        this.localArea = localArea;
        this.hud = hud;
        this.defaultTool = new DefaultTool(client.getPlayer());
        this.slots[ControlSlot.RightHand.ordinal()] = new ToolSlot();
        this.slots[ControlSlot.LeftHand.ordinal()] = new ToolSlot();
    }

    public GameClient getClient() {
        return this.client;
    }

    public LocalArea getLocalArea() {
        return this.localArea;
    }

    public void setInventoryEnabled(boolean b) {
        this.inventoryEnabled = b;
        if (b) {
            this.getState(PopupMenuState.class).setEnabled(false);
        }
        this.getState(InventoryState.class).setEnabled(b);
        this.getState(ToolInputState.class).setEnabled(!b);
    }

    public boolean isInventoryEnabled() {
        return this.getState(InventoryState.class).isEnabled();
    }

    public void toggleInventory() {
        this.setInventoryEnabled(!this.isInventoryEnabled());
    }

    public void setLeftHandOn(boolean f) {
        System.out.println("==================setLeftHandOn(" + f + ")");
        this.slot = f ? ControlSlot.LeftHand : ControlSlot.RightHand;
    }

    public void setToolEntity(EntityId entity) {
        this.setToolEntity(this.slot, entity);
    }

    public void setToolEntity(ControlSlot s, EntityId entity) {
        if (s == ControlSlot.LeftHand) {
            this.client.execute("setLeftTool", null, new EntityParameter(entity));
        } else {
            this.client.execute("setRightTool", null, new EntityParameter(entity));
        }
    }

    protected ToolSlot getToolSlot(ControlSlot s) {
        return this.slots[s.ordinal()];
    }

    protected ToolSlot getToolSlot() {
        return this.slots[this.slot.ordinal()];
    }

    protected ControlSlot getSlot(ToolOrb orb) {
        if (this.getToolSlot(ControlSlot.LeftHand).orb == orb) {
            return ControlSlot.LeftHand;
        }
        if (this.getToolSlot(ControlSlot.RightHand).orb == orb) {
            return ControlSlot.RightHand;
        }
        return null;
    }

    protected ToolSlot getToolSlot(ToolOrb orb) {
        for (ToolSlot s : this.slots) {
            if (s.orb != orb) continue;
            return s;
        }
        return null;
    }

    protected void setTools(EntityId left, EntityId right) {
        this.getToolSlot(ControlSlot.LeftHand).setToolEntity(left);
        this.getToolSlot(ControlSlot.RightHand).setToolEntity(right);
    }

    protected Tool getTool() {
        return this.getToolSlot().getTool();
    }

    protected void updateSlots() {
        Entity e = this.us.getEntity(this.client.getPlayer());
        System.out.println("-------------------updateslots() e:" + e);
        if (e == null) {
            this.setTools(null, null);
            return;
        }
        HeldEntities held = e.get(HeldEntities.class);
        this.setTools(held.getLeft(), held.getRight());
    }

    public void modelsChanged() {
        if (!this.entities.containsId(this.slots[0].toolEntity)) {
            this.slots[0].setToolEntity(null);
        } else {
            this.slots[0].getTool().updateModel();
        }
        if (!this.entities.containsId(this.slots[1].toolEntity)) {
            this.slots[1].setToolEntity(null);
        } else {
            this.slots[1].getTool().updateModel();
        }
    }

    public void update(float tpf) {
        if (this.us.applyChanges()) {
            this.updateSlots();
        }
        if (this.entities.applyChanges()) {
            this.modelsChanged();
        }
        this.slots[0].update(tpf);
        this.slots[1].update(tpf);
        Camera cam = this.getApplication().getCamera();
        if (this.lastCameraRotation == null || !this.lastCameraRotation.equals((Object)cam.getRotation())) {
            this.lastCameraRotation = cam.getRotation().clone();
            this.perspectiveHud.setLocalRotation(cam.getRotation());
        }
    }

    public void initialize(Application app) {
        super.initialize(app);
        float baseScale = (float)app.getCamera().getHeight() / 720.0f;
        float maxScale = 1.2f;
        if (baseScale > maxScale) {
            this.additionalObjectScale = maxScale / baseScale;
            baseScale = maxScale;
        }
        this.imageSize = baseScale * 80.0f;
        this.margin = baseScale * 5.0f;
        GuiAppState gui = this.getState(GuiAppState.class);
        this.perspectiveHud = new Node("PerspectiveHud");
        this.rightOrb = new ToolOrb(app.getAssetManager(), this.imageSize, gui, gui.getPerspectiveRoot());
        this.rightOrb.setLocalTranslation((float)app.getCamera().getWidth() - this.imageSize - this.margin, this.margin, 0.0f);
        this.getToolSlot(ControlSlot.RightHand).setOrb(this.rightOrb);
        GuiUtils.addCommand((Spatial)this.rightOrb, new RemoveToolCommand());
        this.leftOrb = new ToolOrb(app.getAssetManager(), this.imageSize, gui, gui.getPerspectiveRoot());
        this.leftOrb.setLocalTranslation(this.margin, this.margin, 0.0f);
        this.getToolSlot(ControlSlot.LeftHand).setOrb(this.leftOrb);
        GuiUtils.addCommand((Spatial)this.leftOrb, new RemoveToolCommand());
        app.getStateManager().attach((AppState)new InventoryState(this.client));
        app.getStateManager().attach((AppState)new ToolInputState());
        FieldFilter<HeldEntities> filter = new FieldFilter<HeldEntities>(HeldEntities.class, "id", this.client.getPlayer());
        this.us = this.client.getEntityData().getEntities(filter, HeldEntities.class);
        this.updateSlots();
    }

    public void setDefaultCrosshair() {
        this.getState(CrosshairState.class).setImage("Interface/glass-orb-dark-48.png", 32.0f, 32.0f);
        this.getState(CrosshairState.class).setStyle(null);
    }

    public void setCrosshairImage(String name, float width, float height) {
        this.getState(CrosshairState.class).setImage(name, width, height);
    }

    public void cleanup() {
    }

    protected void enable() {
        System.out.println("ItemToolState enabled");
        this.getState(DebugHudState.class).setBottom(false);
        this.getState(GameAppState.class).setStatsOnBottom(false);
        this.getState(GameAppState.class).setMessageMargin(this.imageSize + this.margin);
        this.getState(GuiAppState.class).addDependent(this);
        Node rootNode = ((MainStart)this.getApplication()).getRootNode();
        rootNode.attachChild((Spatial)this.perspectiveHud);
        for (ToolSlot s : this.slots) {
            s.attach();
        }
        this.getState(GuiAppState.class).getOverlayRoot().attachChild((Spatial)this.leftOrb);
        this.getState(GuiAppState.class).getOverlayRoot().attachChild((Spatial)this.rightOrb);
        this.inventoryKey.attach(this.getApplication().getInputManager());
        this.slotKey.attach(this.getApplication().getInputManager());
        if (this.inventoryEnabled) {
            this.getState(AnimationState.class).add(Animation.enable((AppState)this.getState(InventoryState.class), true, 0.25f));
        } else {
            this.getState(ToolInputState.class).setEnabled(true);
        }
        FieldFilter<InContainer> filter = new FieldFilter<InContainer>(InContainer.class, "parentId", this.client.getPlayer());
        this.entities = this.client.getEntityData().getEntities(filter, InContainer.class, ModelInfo.class);
    }

    protected void disable() {
        System.out.println("ItemToolState disabled");
        this.entities.release();
        this.getState(GuiAppState.class).removeDependent(this);
        for (ToolSlot s : this.slots) {
            s.detach();
        }
        Node rootNode = ((MainStart)this.getApplication()).getRootNode();
        rootNode.detachChild((Spatial)this.perspectiveHud);
        this.getState(GuiAppState.class).getOverlayRoot().detachChild((Spatial)this.leftOrb);
        this.getState(GuiAppState.class).getOverlayRoot().detachChild((Spatial)this.rightOrb);
        this.inventoryKey.detach(this.getApplication().getInputManager());
        this.slotKey.detach(this.getApplication().getInputManager());
        this.getState(InventoryState.class).setEnabled(false);
        this.getState(ToolInputState.class).setEnabled(false);
    }

    protected WorldIntersector.Intersection intersectWorld(Vector3f pos, Vector3f dir) {
        WorldIntersector.Intersection hit;
        block0: {
            WorldIntersector.Intersection isect;
            Ray ray = new Ray(pos, dir);
            ray.setLimit(10.0f);
            WorldIntersector wi = new WorldIntersector(this.localArea, ray, new Integer[0]);
            hit = null;
            if (!wi.hasNext()) break block0;
            hit = isect = wi.next();
        }
        return hit;
    }

    protected CollisionResult intersectObjects(Vector3f pos, Vector3f dir) {
        WorldIntersector.Intersection hit = this.intersectWorld(pos, dir);
        return this.intersectObjects(pos, dir, hit);
    }

    protected CollisionResult intersectObjects(Vector3f pos, Vector3f dir, WorldIntersector.Intersection limit) {
        Ray ray = new Ray(pos.clone(), dir.clone());
        if (limit != null) {
            Vector3f delta = limit.getPoint().subtract(pos);
            ray.setLimit(delta.length());
        } else {
            ray.setLimit(20.0f);
        }
        long start = System.nanoTime();
        CollisionResults results = new CollisionResults();
        ray.origin = new Vector3f(0.0f, 0.0f, 0.0f);
        float y = ray.direction.z;
        ray.direction.z = ray.direction.y;
        ray.direction.y = y;
        LocalArea target = this.localArea;
        target.updateGeometricState();
        target.collideWith((Collidable)ray, results);
        long end = System.nanoTime();
        for (int i = 0; i < results.size(); ++i) {
            float d = results.getCollision(i).getDistance();
            Node parent = results.getCollision(i).getGeometry().getParent();
            Long id = (Long)parent.getUserData("id");
            if (id == null && parent.getControl(DragControl.class) == null) continue;
            return results.getCollision(i);
        }
        return null;
    }

    protected void swapYZ(Vector3f v) {
        float z = v.z;
        v.z = v.y;
        v.y = z;
    }

    public Hit getNearestHit() {
        int cellType;
        Vector3f pos = this.client.getLocation();
        Vector3f dir = this.client.getFacing().mult(new Vector3f(0.0f, 0.0f, 1.0f));
        this.swapYZ(dir);
        WorldIntersector.Intersection hit = this.intersectWorld(pos, dir);
        CollisionResult collision = this.intersectObjects(pos, dir, hit);
        Vector3f contact = null;
        Vector3f normal = null;
        EntityId entity = null;
        int n = cellType = hit != null ? hit.getType() : -1;
        if (collision != null) {
            Node parent = collision.getGeometry().getParent();
            Long id = (Long)parent.getUserData("id");
            if (id != null) {
                entity = new EntityId(id);
            }
            contact = collision.getContactPoint();
            this.swapYZ(contact);
            normal = collision.getContactNormal();
            this.swapYZ(normal);
            return new Hit(contact, normal, entity, cellType);
        }
        if (hit != null) {
            if (hit.getSide() == 4) {
                normal = new Vector3f(0.0f, 0.0f, 1.0f);
            }
            contact = hit.getPoint();
            return new Hit(contact, normal, entity, cellType);
        }
        return null;
    }

    public void mainClick() {
        this.getTool().mainClick(this.slot);
    }

    public void alternateClick() {
        this.getTool().alternateClick(this.slot);
    }

    public void mainButton(boolean down) {
        this.getTool().mainButton(down, this.slot);
    }

    public void alternateButton(boolean down) {
        this.getTool().alternateButton(down, this.slot);
    }

    public boolean mainDrag(int xDelta, int yDelta, int xTotal, int yTotal) {
        return this.getTool().mainDrag(xDelta, yDelta, xTotal, yTotal, this.slot);
    }

    public boolean alternateDrag(int xDelta, int yDelta, int xTotal, int yTotal) {
        return this.getTool().alternateDrag(xDelta, yDelta, xTotal, yTotal, this.slot);
    }

    public void roll(int amount) {
        this.getTool().roll(amount, this.slot);
    }

    public boolean hover(boolean on) {
        return this.getTool().hover(on, this.slot);
    }

    protected BlockObject createIcon(BlueprintData data) {
        if (data == null) {
            return null;
        }
        BlockObject bo = new BlockObject(data, false);
        float max = Math.max(data.xSize, Math.max(data.ySize, data.zSize));
        max = (float)((double)max * Math.sqrt(2.0)) + 1.0f;
        float scale = 1.0f / max;
        System.out.println("Setting scale to:" + scale);
        bo.setScale(scale * this.additionalObjectScale);
        bo.setLighting(1.0f, 0.8f);
        bo.build();
        bo.applyUpdates(null);
        return bo;
    }

    private class ToolSlot {
        private ToolOrb orb;
        private Tool tool;
        private EntityId toolEntity;
        private String name;
        private BlueprintData icon;

        public ToolSlot() {
            this.setToolEntity(null);
            this.setTool(ItemToolState.this.defaultTool);
        }

        public void update(float tpf) {
            if (this.orb != null) {
                if (this.name != this.tool.getName()) {
                    this.orb.setName(this.tool.getName());
                }
                if (this.icon != this.tool.getIcon()) {
                    this.orb.setIcon(ItemToolState.this.createIcon(this.tool.getIcon()));
                }
                this.name = this.tool.getName();
                this.icon = this.tool.getIcon();
            }
        }

        public void setOrb(ToolOrb orb) {
            this.orb = orb;
        }

        public void attach() {
            this.tool.toolAttached(ItemToolState.this);
        }

        public void detach() {
            this.tool.toolDetached();
        }

        public void setTool(Tool tool) {
            if (ObjectUtils.areEqual((Object)this.tool, (Object)tool)) {
                return;
            }
            if (this.tool != null) {
                this.tool.toolDetached();
            }
            this.tool = tool;
            if (this.tool == null) {
                this.tool = ItemToolState.this.defaultTool;
            }
            if (ItemToolState.this.isEnabled()) {
                this.tool.toolAttached(ItemToolState.this);
            }
        }

        public Tool getTool() {
            return this.tool;
        }

        public void setToolEntity(EntityId entity) {
            if (ObjectUtils.areEqual((Object)entity, (Object)this.toolEntity)) {
                return;
            }
            this.toolEntity = entity;
            if (this.toolEntity == null) {
                this.setTool(ItemToolState.this.defaultTool);
                return;
            }
            this.setTool(new DefaultTool(entity));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveToolCommand
    implements Command<ClickAction> {
        private RemoveToolCommand() {
        }

        @Override
        public void execute(Object source, ClickAction a) {
            if (a == ClickAction.Enter) {
                ToolOrb orb = (ToolOrb)((Object)source);
                ItemToolState.this.setToolEntity(ItemToolState.this.getSlot(orb), null);
            }
        }
    }
}

