/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.gm;

import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import mythruna.client.GameClient;
import mythruna.client.ui.ClickAction;
import mythruna.client.ui.ClickListener;
import mythruna.client.ui.Command;
import mythruna.client.ui.CommandList;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.MouseListener;
import mythruna.client.ui.ScrollBar;
import mythruna.client.ui.SelectionModel;
import mythruna.client.ui.VAlignment;
import mythruna.client.view.BlockObject;
import mythruna.es.EntitySet;
import mythruna.geom.Trifold;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectGrid
extends Node {
    private int rows;
    private int cols;
    private float cellSize;
    private Vector4f margins = new Vector4f(5.0f, 5.0f, 5.0f, 5.0f);
    private float width;
    private float height;
    private Label titleLabel;
    private Quad grid;
    private Geometry gridGeom;
    private ScrollBar scroll;
    private BoundedRangeModel scrollModel;
    private GameClient client;
    private EntitySet inventory;
    private List<BlockObject> list = new ArrayList<BlockObject>();
    private BlockObject[][] cells;
    private GuiAppState gui;
    private Node perspectiveRoot;
    private Node selectionRoot;
    private int currentRow = 0;
    private SelectionModel<BlockObject> selection = new SelectionModel();
    private Material cellMaterial;
    private Geometry singleCellGeom;
    private CommandList<ClickAction> commands = new CommandList();

    public ObjectGrid(GuiAppState gui, AssetManager assets, String title, int rows, int cols, float cellSize) {
        super(title);
        this.gui = gui;
        this.rows = rows;
        this.cols = cols;
        this.cellSize = cellSize;
        if (title != null) {
            BitmapFont font = assets.loadFont("Interface/knights24.fnt");
            this.titleLabel = new Label(font);
            this.titleLabel.setText(title);
            this.margins.x = this.titleLabel.getHeight() + 5.0f;
            this.titleLabel.setColor(new ColorRGBA(1.0f, 0.93333334f, 0.62352943f, 0.75f));
            this.attachChild((Spatial)this.titleLabel);
        }
        this.selectionRoot = new Node("Selection");
        this.attachChild((Spatial)this.selectionRoot);
        Quad quad = new Quad((float)cols * cellSize, (float)rows * cellSize);
        quad.scaleTextureCoordinates(new Vector2f((float)cols, (float)rows));
        this.gridGeom = new Geometry("Grid", (Mesh)quad);
        this.cellMaterial = new Material(assets, "Common/MatDefs/Misc/Unshaded.j3md");
        this.cellMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.75f));
        this.cellMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.gridGeom.setMaterial(this.cellMaterial);
        Texture tex = assets.loadTexture("Interface/brown-cell-64.png");
        tex.setWrap(Texture.WrapMode.Repeat);
        this.cellMaterial.setTexture("ColorMap", tex);
        this.gridGeom.setLocalTranslation(this.margins.y, this.margins.z, 0.0f);
        this.gridGeom.addControl((Control)new MouseEventControl(new ObjectClickListener()));
        this.attachChild((Spatial)this.gridGeom);
        this.width = (float)cols * cellSize + this.margins.y + this.margins.w;
        this.height = (float)rows * cellSize + this.margins.x + this.margins.z;
        this.scroll = new ScrollBar(assets);
        this.scroll.setHeight((float)rows * cellSize);
        this.scroll.setLocalTranslation(this.width - this.margins.w, this.margins.z, 0.0f);
        this.scrollModel = this.scroll.getModel();
        this.scrollModel.setExtent(rows);
        this.scrollModel.setMaximum(0);
        this.width += this.scroll.getWidth();
        Trifold background = new Trifold(this.width, this.height, 64.0f, 64.0f, 16.0f, 16.0f);
        Geometry geom = new Geometry("bg", (Mesh)background);
        geom.setLocalTranslation(0.0f, 0.0f, -0.5f);
        Material mat = this.cellMaterial.clone();
        mat.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.25f));
        geom.setMaterial(mat);
        this.attachChild((Spatial)geom);
        this.attachChild((Spatial)this.scroll);
        if (title != null) {
            this.titleLabel.setHAlignment(HAlignment.CENTER);
            this.titleLabel.setVAlignment(VAlignment.TOP);
            this.titleLabel.setLocalTranslation(this.width * 0.5f, this.height - 2.0f, 1.0f);
        }
        this.cellMaterial = this.cellMaterial.clone();
        tex = assets.loadTexture("Interface/gray-cell-64.png");
        tex.setWrap(Texture.WrapMode.Repeat);
        this.cellMaterial.setTexture("ColorMap", tex);
        this.cellMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.perspectiveRoot = new Node("Inventory Objects");
        this.cells = new BlockObject[cols][rows];
    }

    public SelectionModel<BlockObject> getSelectionModel() {
        return this.selection;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.currentRow != this.scrollModel.getValue()) {
            this.setCurrentRow(this.scrollModel.getValue());
        }
    }

    protected void setParent(Node parent) {
        super.setParent(parent);
        Node root = this.gui.getPerspectiveRoot();
        if (parent != null) {
            root.attachChild((Spatial)this.perspectiveRoot);
            this.refreshView();
        } else {
            root.detachChild((Spatial)this.perspectiveRoot);
        }
    }

    public void setCurrentRow(int row) {
        if (this.currentRow == row) {
            return;
        }
        this.currentRow = row;
        this.refreshView();
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    protected int toRow(int index) {
        double f = Math.ceil((float)index / (float)this.cols);
        return (int)f;
    }

    protected Vector3f cellLocation(int x, int y) {
        float xBase = this.margins.y;
        float yBase = this.margins.z;
        Vector3f gloc = new Vector3f(xBase + (float)x * this.cellSize, yBase + (float)(this.rows - y - 1) * this.cellSize, 0.0f);
        return gloc;
    }

    protected Vector3f getLocation(BlockObject o) {
        for (int x = 0; x < this.cols; ++x) {
            for (int y = 0; y < this.rows; ++y) {
                if (this.cells[x][y] != o) continue;
                return this.cellLocation(x, y);
            }
        }
        return null;
    }

    protected void refreshSelection() {
        this.selectionRoot.detachAllChildren();
        if (this.selection.isEmpty()) {
            return;
        }
        Material mat = this.cellMaterial.clone();
        if (this.singleCellGeom == null) {
            Quad quad = new Quad(this.cellSize, this.cellSize);
            this.singleCellGeom = new Geometry("Cell", (Mesh)quad);
            this.singleCellGeom.setMaterial(mat);
        }
        Iterator i$ = this.selection.iterator();
        while (i$.hasNext()) {
            BlockObject o = (BlockObject)i$.next();
            Vector3f cellLocation = this.getLocation(o);
            if (cellLocation == null) continue;
            Geometry geom = this.singleCellGeom.clone();
            cellLocation.z += 0.1f;
            geom.setLocalTranslation(cellLocation);
            this.selectionRoot.attachChild((Spatial)geom);
        }
    }

    public int getRowCount() {
        double f = Math.ceil((float)this.list.size() / (float)this.cols);
        return (int)f;
    }

    public void setTransformRefresh() {
        super.setTransformRefresh();
        this.refreshView();
    }

    protected void updateScrollModel() {
        this.scrollModel.setMaximum(this.getRowCount());
        this.scrollModel.setExtent(this.rows);
    }

    public void addObject(BlockObject o) {
        this.list.add(o);
        this.updateScrollModel();
    }

    public void removeObject(BlockObject o) {
        this.perspectiveRoot.detachChild((Spatial)o.getNode());
        this.list.remove(o);
        this.updateScrollModel();
    }

    public void clear() {
        for (BlockObject o : this.list) {
            this.perspectiveRoot.detachChild((Spatial)o.getNode());
        }
        this.list.clear();
        this.updateScrollModel();
    }

    public void refreshView() {
        int x = 0;
        int y = 0;
        float xBase = this.margins.y;
        float yBase = this.margins.z;
        int start = this.getCurrentRow() * this.cols;
        int end = Math.min(start + this.rows, this.getRowCount()) * this.cols;
        this.perspectiveRoot.detachAllChildren();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.cells[c][r] = null;
            }
        }
        for (int i = start; i < end && i < this.list.size() && y < this.rows; ++i) {
            BlockObject bo = this.list.get(i);
            this.perspectiveRoot.attachChild((Spatial)bo.getNode());
            Vector3f gloc = new Vector3f(xBase + (float)x * this.cellSize + this.cellSize * 0.5f, yBase + (float)(this.rows - y - 1) * this.cellSize + this.cellSize * 0.33f, 0.0f);
            Vector3f local = this.localToWorld(gloc, null);
            Vector3f v = this.gui.screenToWorld(local.x, local.y, 20.0f);
            bo.getNode().setLocalTranslation(v);
            Quaternion quat0 = new Quaternion().fromAngles(0.0f, 3.926991f, 0.0f);
            Quaternion quat1 = new Quaternion().fromAngles(0.7853982f, 0.0f, 0.0f);
            Vector3f back = bo.getNode().getWorldTranslation().mult(-1.0f).normalizeLocal();
            Quaternion quat2 = new Quaternion();
            quat2.lookAt(back, new Vector3f(0.0f, 1.0f, 0.0f));
            bo.getNode().setLocalRotation(quat2.mult(quat1).mult(quat0));
            this.cells[x][y] = bo;
            if (++x < 4) continue;
            ++y;
            x = 0;
        }
        this.refreshSelection();
    }

    public float getWidth() {
        Vector3f scale = this.getLocalScale();
        return this.width * scale.x;
    }

    public float getHeight() {
        Vector3f scale = this.getLocalScale();
        return this.height * scale.y;
    }

    public BlockObject getGridCell(int xScreen, int yScreen) {
        Vector3f local = this.worldToLocal(new Vector3f((float)xScreen, (float)yScreen, 0.0f), null);
        int row = (int)(local.y / this.cellSize);
        row = this.rows - row - 1;
        int col = (int)(local.x / this.cellSize);
        if (col >= this.cols || row >= this.rows) {
            return null;
        }
        return this.cells[col][row];
    }

    public void addCommand(Command<ClickAction> c) {
        this.commands.addCommand(c);
    }

    public void removeCommand(Command<ClickAction> c) {
        this.commands.removeCommand(c);
    }

    private class ObjectClickListener
    extends ClickListener {
        private ObjectClickListener() {
            super(new Command[0]);
        }

        protected void execute(Object source, ClickAction action) {
            ObjectGrid.this.commands.execute(source, action);
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            System.out.println("Mouse button on:" + (Object)((Object)ObjectGrid.this) + "  pressed:" + event.isPressed());
            event.setConsumed();
            if (event.isPressed()) {
                BlockObject hit = ObjectGrid.this.getGridCell(event.getX(), event.getY());
                ObjectGrid.this.selection.setSelected(hit);
                ObjectGrid.this.refreshSelection();
                return;
            }
            super.mouseButtonEvent(event, capture);
        }
    }

    private class EventConsumer
    implements MouseListener {
        private EventConsumer() {
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            event.setConsumed();
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
            event.setConsumed();
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
        }

        public void mouseMoved(MouseMotionEvent event, Spatial capture) {
            event.setConsumed();
        }
    }
}

