/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import mythruna.db.BlueprintData;
import mythruna.db.BlueprintDatabase;
import mythruna.msg.BlueprintDataMessage;
import mythruna.msg.GetBlueprintMessage;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBlueprintDatabase
implements BlueprintDatabase {
    static Log log = Log.getLog();
    private Client client;
    private Map<Long, PendingRequest> pendingRequests = new ConcurrentHashMap<Long, PendingRequest>();

    public RemoteBlueprintDatabase(Client client) {
        this.client = client;
        client.addMessageListener((MessageListener)new MessageObserver(), new Class[]{BlueprintDataMessage.class});
    }

    @Override
    public void close() {
        for (PendingRequest req : this.pendingRequests.values()) {
            req.close();
        }
    }

    @Override
    public List<Long> getIds() throws IOException {
        throw new UnsupportedOperationException("Remotely iterating over all blueprints is not support.");
    }

    @Override
    public BlueprintData getBlueprint(long id, boolean load) throws IOException {
        return this.getBlueprint(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlueprintData getBlueprint(long id) throws IOException {
        PendingRequest request;
        if (log.isTraceEnabled()) {
            log.trace((Object)("RemoteBlueprintDatabase.getBlueprint(" + id + ")"));
        }
        if ((request = this.pendingRequests.get(id)) == null) {
            Map<Long, PendingRequest> map = this.pendingRequests;
            synchronized (map) {
                request = this.pendingRequests.get(id);
                if (request == null) {
                    GetBlueprintMessage msg = new GetBlueprintMessage(id);
                    msg.setReliable(true);
                    request = new PendingRequest(msg);
                    this.pendingRequests.put(id, request);
                    this.client.send((Message)msg);
                }
            }
        }
        try {
            return request.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for blueprint data.", e);
        }
    }

    @Override
    public BlueprintData createBlueprint(String name, int xSize, int ySize, int zSize, float scale, int[][][] cells) throws IOException {
        throw new UnsupportedOperationException("Remotely creating blueprints through this interface is not supported.");
    }

    protected class PendingRequest {
        private GetBlueprintMessage request;
        private AtomicReference<BlueprintData> bpData = new AtomicReference();
        private CountDownLatch received = new CountDownLatch(1);

        public PendingRequest(GetBlueprintMessage request) {
            this.request = request;
        }

        public void close() {
            this.received.countDown();
        }

        public void dataReceived(BlueprintData bpData) {
            this.bpData.set(bpData);
            this.received.countDown();
        }

        public BlueprintData getResult() throws InterruptedException {
            this.received.await();
            return this.bpData.get();
        }

        public String toString() {
            return "PendingRequest[" + (Object)((Object)this.request) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MessageObserver
    implements MessageListener<Client> {
        protected MessageObserver() {
        }

        public void messageReceived(Client client, Message m) {
            BlueprintDataMessage msg = (BlueprintDataMessage)m;
            PendingRequest request = (PendingRequest)RemoteBlueprintDatabase.this.pendingRequests.remove(msg.getId());
            if (request == null) {
                log.error((Object)("Received blueprint data but no request is pending, id:" + msg.getId()));
                return;
            }
            request.dataReceived(msg.getData());
        }
    }
}

