/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import mythruna.client.ClientOptions;
import mythruna.client.shell.DefaultConsole;
import mythruna.client.shell.ResetOptionsCommand;
import mythruna.client.ui.MessageLog;
import mythruna.msg.ConsoleMessage;
import mythruna.shell.MemoryCommand;
import mythruna.shell.UptimeCommand;
import mythruna.shell.WhoCommand;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellCommand;
import org.progeeks.tool.console.ShellEnvironment;

public class RemoteConsole
extends DefaultConsole {
    private Client client;

    public RemoteConsole(Client client) {
        this.client = client;
        DefaultConsole.MessageShell shell = this.getShell();
        this.setLocalVariable("opts", ClientOptions.getInstance());
        shell.registerCommand("who", (ShellCommand)new RemoteShellCommand("who", "Lists the players that are currently online.", WhoCommand.HELP));
        shell.registerCommand("where", (ShellCommand)new RemoteShellCommand("where", "Lists the players that are currently online.", WhoCommand.HELP));
        shell.registerCommand("serverMem", (ShellCommand)new RemoteShellCommand("serverMem", "Displays current server memory usage.", MemoryCommand.HELP));
        shell.registerCommand("uptime", (ShellCommand)new RemoteShellCommand("uptime", "Shows server up time.", UptimeCommand.HELP));
        shell.registerCommand("resetopts", (ShellCommand)new ResetOptionsCommand());
        client.addMessageListener((MessageListener)new ConsoleObserver(), new Class[]{ConsoleMessage.class});
    }

    protected void execute(String cmd) {
        this.getShell().execute(cmd);
    }

    protected void executeAdmin(String cmd) {
        this.executeRemote(cmd);
    }

    protected void say(String s) {
        s = s.replaceAll(">:\\(", "{");
        s = s.replaceAll(":\\(", "}");
        s = s.replaceAll(":\\)", "\u00a9");
        s = s.replaceAll(";\\)", "\u00ae");
        ConsoleMessage msg = new ConsoleMessage(0L, this.client.getId(), null, "say " + s);
        System.out.println("Sending:" + (Object)((Object)msg));
        this.client.send((Message)msg);
    }

    protected void executeRemote(String s) {
        ConsoleMessage msg = new ConsoleMessage(0L, this.client.getId(), null, s);
        System.out.println("Sending:" + (Object)((Object)msg));
        this.client.send((Message)msg);
    }

    protected class RemoteShellCommand
    extends AbstractShellCommand {
        private String cmd;

        public RemoteShellCommand(String cmd, String description, String[] help) {
            super(description, help);
            this.cmd = cmd;
        }

        public int execute(ShellEnvironment sEnv, String args) {
            RemoteConsole.this.executeRemote(this.cmd + " " + args);
            return 0;
        }

        public boolean isSimple() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConsoleObserver
    implements MessageListener<Client> {
        protected ConsoleObserver() {
        }

        public void messageReceived(Client client, Message m) {
            ConsoleMessage msg = (ConsoleMessage)m;
            if (msg.getFrom() == null) {
                RemoteConsole.this.println("> " + msg.getMessage());
            } else {
                String s = msg.getFrom() + ":" + msg.getMessage();
                MessageLog.addMessage(s, true);
                System.out.println("chat-" + s);
            }
        }
    }
}

