/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import mythruna.es.ChangeQueue;
import mythruna.es.ComponentFilter;
import mythruna.es.DefaultEntity;
import mythruna.es.Entity;
import mythruna.es.EntityChange;
import mythruna.es.EntityComponent;
import mythruna.es.EntityComponentListener;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntityProcessor;
import mythruna.es.EntityProcessorRunnable;
import mythruna.es.EntitySet;
import mythruna.es.ObservableEntityData;
import mythruna.es.StringIndex;
import mythruna.msg.ComponentChangeMessage;
import mythruna.msg.EntityComponentsMessage;
import mythruna.msg.EntityDataMessage;
import mythruna.msg.EntityIdsMessage;
import mythruna.msg.FindEntitiesMessage;
import mythruna.msg.FindEntityMessage;
import mythruna.msg.GetComponentsMessage;
import mythruna.msg.GetEntitySetMessage;
import mythruna.msg.ObserveChangesMessage;
import mythruna.msg.ReleaseEntitySetMessage;
import mythruna.msg.ReleaseObserveChangesMessage;
import mythruna.msg.ResetEntitySetFilterMessage;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteEntityData
implements ObservableEntityData {
    static Log log = Log.getLog();
    private static AtomicInteger nextSetId = new AtomicInteger();
    private static AtomicInteger nextRequestId = new AtomicInteger();
    private static AtomicInteger nextQueueId = new AtomicInteger();
    private Client client;
    private Map<Integer, RemoteEntitySet> activeSets = new ConcurrentHashMap<Integer, RemoteEntitySet>();
    private Map<Integer, PendingRequest> pendingRequests = new ConcurrentHashMap<Integer, PendingRequest>();
    private Map<Integer, RemoteChangeQueue> activeQueues = new ConcurrentHashMap<Integer, RemoteChangeQueue>();
    private Map<EntityId, CacheEntry> entityCache = new ConcurrentHashMap<EntityId, CacheEntry>();
    private ExecutorService executor;

    public RemoteEntityData(Client client) {
        this.client = client;
        this.executor = Executors.newFixedThreadPool(4);
        client.addMessageListener((MessageListener)new MessageObserver(), new Class[]{EntityDataMessage.class, EntityIdsMessage.class, EntityComponentsMessage.class, ComponentChangeMessage.class});
    }

    @Override
    public StringIndex getStrings() {
        throw new UnsupportedOperationException("String look-ups are server-side only for now.");
    }

    @Override
    public EntityId createEntity() {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    @Override
    public void removeEntity(EntityId entityId) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    @Override
    public void setComponent(EntityId entityId, EntityComponent component) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    @Override
    public void setComponents(EntityId entityId, EntityComponent ... components) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    @Override
    public boolean removeComponent(EntityId entityId, Class type) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    @Override
    public void addEntityComponentListener(EntityComponentListener l) {
        throw new UnsupportedOperationException("Unfiltered change listening not supported.");
    }

    @Override
    public void removeEntityComponentListener(EntityComponentListener l) {
        throw new UnsupportedOperationException("Unfiltered change listening not supported.");
    }

    @Override
    public <T extends EntityComponent> T getComponent(EntityId entityId, Class<T> type) {
        Entity e = this.getEntity(entityId, type);
        return e.get(type);
    }

    @Override
    public Entity getEntity(EntityId entityId, Class ... types) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEntity(" + entityId + ", " + Arrays.asList(types) + ")"));
        }
        CacheEntry entry = this.entityCache.get(entityId);
        Entity result = null;
        if (entry != null) {
            result = entry.getEntity(types);
        }
        if (result == null || !result.isComplete()) {
            int id = nextRequestId.getAndIncrement();
            GetComponentsMessage msg = new GetComponentsMessage(id, entityId, types);
            msg.setReliable(true);
            PendingEntityRequest request = new PendingEntityRequest(msg);
            this.pendingRequests.put(id, request);
            this.client.send(2, (Message)msg);
            try {
                result = (Entity)request.getResult();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted waiting for entity data.", e);
            }
            if (entry != null) {
                entry.addComponents(types, result.getComponents());
            } else {
                entry = new CacheEntry(types, result);
                this.entityCache.put(entityId, entry);
                this.resizeCache();
            }
            entry.markUsed();
        } else {
            log.debug((Object)"Using cached entity instead of requesting a new one.");
        }
        return result;
    }

    protected void resizeCache() {
        log.info((Object)("Cache size:" + this.entityCache.size()));
        while (this.entityCache.size() > 20) {
            long oldest = Long.MAX_VALUE;
            EntityId oldestEntity = null;
            for (Map.Entry<EntityId, CacheEntry> e : this.entityCache.entrySet()) {
                if (e.getValue().getLastUsed() >= oldest) continue;
                oldestEntity = e.getKey();
                oldest = e.getValue().getLastUsed();
            }
            if (oldestEntity != null) {
                log.info((Object)("Removing:" + oldestEntity + " from cache."));
                this.entityCache.remove(oldestEntity);
                continue;
            }
            log.warn((Object)"Unable to find an oldest cache entry to remove.");
        }
    }

    @Override
    public EntitySet getEntities(Class ... types) {
        return this.getEntities((ComponentFilter)null, types);
    }

    public EntityId findEntityOriginal(ComponentFilter filter) {
        int id = nextRequestId.getAndIncrement();
        FindEntityMessage msg = new FindEntityMessage(id, filter);
        msg.setReliable(true);
        PendingEntityIdRequest request = new PendingEntityIdRequest(msg);
        this.pendingRequests.put(id, request);
        this.client.send(2, (Message)msg);
        try {
            return (EntityId)request.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for entity data.", e);
        }
    }

    @Override
    public EntityId findEntity(ComponentFilter filter, Class ... types) {
        if (types == null || types.length == 0) {
            return this.findEntityOriginal(filter);
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Set<EntityId> findEntities(ComponentFilter filter, Class ... types) {
        int id = nextRequestId.getAndIncrement();
        FindEntitiesMessage msg = new FindEntitiesMessage(id, filter, types);
        msg.setReliable(true);
        PendingEntityIdsRequest request = new PendingEntityIdsRequest(msg);
        this.pendingRequests.put(id, request);
        this.client.send(2, (Message)msg);
        try {
            return (Set)request.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for entity data.", e);
        }
    }

    @Override
    public EntitySet getEntities(ComponentFilter filter, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("RemoteEntityData.getEntities( " + filter + ", " + Arrays.asList(types) + " )"));
        }
        int id = nextSetId.getAndIncrement();
        RemoteEntitySet result = new RemoteEntitySet(id, this, filter, types, this.client);
        this.activeSets.put(id, result);
        GetEntitySetMessage m = new GetEntitySetMessage(id, filter, types);
        m.setReliable(true);
        this.client.send(2, (Message)m);
        return result;
    }

    @Override
    public void releaseEntitySet(EntitySet entities) {
        ReleaseEntitySetMessage m = new ReleaseEntitySetMessage(((RemoteEntitySet)entities).setId);
        m.setReliable(true);
        this.client.send(2, (Message)m);
    }

    @Override
    public ChangeQueue getChangeQueue(Class ... componentTypes) {
        int id = nextQueueId.getAndIncrement();
        RemoteChangeQueue result = new RemoteChangeQueue(id, this, componentTypes);
        this.activeQueues.put(id, result);
        ObserveChangesMessage m = new ObserveChangesMessage(id, componentTypes);
        m.setReliable(true);
        this.client.send(2, (Message)m);
        return result;
    }

    @Override
    public void releaseChangeQueue(ChangeQueue queue) {
        ReleaseObserveChangesMessage m = new ReleaseObserveChangesMessage(((RemoteChangeQueue)queue).queueId);
        m.setReliable(true);
        this.client.send(2, (Message)m);
    }

    protected void componentChange(ComponentChangeMessage m) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received component change:" + (Object)((Object)m)));
        }
        EntityChange change = new EntityChange(m.getEntityId(), m.getType(), m.getComponent());
        CacheEntry entry = this.entityCache.get(m.getEntityId());
        if (entry != null) {
            EntityComponent value = m.getComponent();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating cache entry:" + entry.id + " with:" + value));
            }
            if (value == null) {
                entry.removeComponent(m.getType());
            } else {
                entry.setComponent(value);
            }
        }
        for (RemoteEntitySet set : this.activeSets.values()) {
            set.entityChange(change);
        }
        for (RemoteChangeQueue queue : this.activeQueues.values()) {
            queue.getListener().componentChange(change);
        }
    }

    @Override
    public void close() {
        for (PendingRequest req : this.pendingRequests.values()) {
            req.close();
        }
        this.executor.shutdownNow();
    }

    @Override
    public void execute(EntityProcessor proc) {
        this.executor.submit(new EntityProcessorRunnable(proc, this));
    }

    protected class CacheEntry {
        private long lastUsed;
        private EntityId id;
        private Map<Class, EntityComponent> components = new ConcurrentHashMap<Class, EntityComponent>();

        public CacheEntry(Class[] types, Entity e) {
            this.id = e.getId();
            this.addComponents(types, e.getComponents());
            this.markUsed();
        }

        public void markUsed() {
            this.lastUsed = System.currentTimeMillis();
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void addComponents(Class[] types, EntityComponent[] values) {
            for (int i = 0; i < types.length; ++i) {
                if (values[i] == null) {
                    this.components.remove(types[i]);
                    continue;
                }
                this.components.put(types[i], values[i]);
            }
        }

        public Entity getEntity(Class ... types) {
            EntityComponent[] values = new EntityComponent[types.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.components.get(types[i]);
            }
            return new DefaultEntity(this.id, values, types);
        }

        public void setComponent(EntityComponent c) {
            this.components.put(c.getType(), c);
        }

        public void removeComponent(Class type) {
            this.components.remove(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PendingEntityIdsRequest
    extends PendingRequest<EntityIdsMessage, Set<EntityId>> {
        private Set<EntityId> results;

        public PendingEntityIdsRequest(FindEntitiesMessage request) {
            super((Message)request);
            this.results = new HashSet<EntityId>();
        }

        @Override
        public void dataReceived(EntityIdsMessage m) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("find entities Received:" + (Object)((Object)m)));
            }
            if (m.getEntityIds() != null) {
                for (long l : m.getEntityIds()) {
                    this.results.add(new EntityId(l));
                }
            }
            if (m.isLast()) {
                this.setResult(this.results);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PendingEntityIdRequest
    extends PendingRequest<EntityComponentsMessage, EntityId> {
        public PendingEntityIdRequest(FindEntityMessage request) {
            super((Message)request);
        }

        @Override
        public void dataReceived(EntityComponentsMessage m) {
            this.setResult(m.getEntityId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PendingEntityRequest
    extends PendingRequest<EntityComponentsMessage, Entity> {
        public PendingEntityRequest(GetComponentsMessage request) {
            super((Message)request);
        }

        @Override
        public void dataReceived(EntityComponentsMessage m) {
            DefaultEntity e = new DefaultEntity(m.getEntityId(), m.getComponents(), ((GetComponentsMessage)this.request).getComponentTypes());
            this.setResult(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class PendingRequest<M, T> {
        protected Message request;
        private AtomicReference<T> result = new AtomicReference();
        private CountDownLatch received = new CountDownLatch(1);

        protected PendingRequest(Message request) {
            this.request = request;
        }

        public boolean isDone() {
            return this.result.get() != null;
        }

        public void close() {
            this.received.countDown();
        }

        protected void setResult(T val) {
            this.result.set(val);
            this.received.countDown();
        }

        public abstract void dataReceived(M var1);

        public T getResult() throws InterruptedException {
            this.received.await();
            return this.result.get();
        }

        public String toString() {
            return "PendingRequest[" + this.request + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageObserver
    implements MessageListener<Client> {
        private MessageObserver() {
        }

        public void messageReceived(Client client, Message m) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received message:" + m));
            }
            if (m instanceof EntityDataMessage) {
                this.entityData((EntityDataMessage)m);
            } else if (m instanceof EntityComponentsMessage) {
                this.entityComponents((EntityComponentsMessage)m);
            } else if (m instanceof ComponentChangeMessage) {
                RemoteEntityData.this.componentChange((ComponentChangeMessage)m);
            } else if (m instanceof EntityIdsMessage) {
                this.entityIds((EntityIdsMessage)m);
            }
        }

        protected void entityComponents(EntityComponentsMessage m) {
            PendingRequest request = (PendingRequest)RemoteEntityData.this.pendingRequests.remove(m.getRequestId());
            if (request == null) {
                log.error((Object)("Received component data but no request is pending, id:" + m.getRequestId()));
                return;
            }
            request.dataReceived(m);
        }

        protected void entityIds(EntityIdsMessage m) {
            PendingRequest request = (PendingRequest)RemoteEntityData.this.pendingRequests.get(m.getRequestId());
            if (request == null) {
                log.error((Object)("Received data but no request is pending, id:" + m.getRequestId()));
                return;
            }
            request.dataReceived(m);
            if (request.isDone()) {
                RemoteEntityData.this.pendingRequests.remove(m.getRequestId());
            }
        }

        protected void entityData(EntityDataMessage m) {
            RemoteEntitySet set = (RemoteEntitySet)RemoteEntityData.this.activeSets.get(m.getSetId());
            for (EntityDataMessage.ComponentData d : m.getData()) {
                if (d.getComponents() != null) {
                    DefaultEntity e = new DefaultEntity(d.getEntityId(), d.getComponents(), set.getTypes());
                    set.directAdd(e);
                    continue;
                }
                set.directRemove(d.getEntityId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RemoteEntitySet
    extends EntitySet {
        private Client client;
        private int setId;
        private ConcurrentLinkedQueue<Entity> directAdds = new ConcurrentLinkedQueue();
        private ConcurrentLinkedQueue<EntityId> directRemoves = new ConcurrentLinkedQueue();

        public RemoteEntitySet(int setId, EntityData ed, ComponentFilter filter, Class[] types, Client client) {
            super(ed, filter, types);
            this.setId = setId;
            this.client = client;
        }

        @Override
        protected Class[] getTypes() {
            return super.getTypes();
        }

        @Override
        protected void loadEntities(boolean reload) {
        }

        @Override
        public boolean resetFilter(ComponentFilter filter) {
            boolean result = super.resetFilter(filter);
            ResetEntitySetFilterMessage m = new ResetEntitySetFilterMessage(this.setId, filter);
            m.setReliable(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending filter reset:" + (Object)((Object)m)));
            }
            this.client.send(2, (Message)m);
            return result;
        }

        @Override
        protected boolean buildTransactionChanges(Set<EntityChange> updates) {
            boolean directMods = false;
            if (!this.directRemoves.isEmpty()) {
                while (!this.directRemoves.isEmpty()) {
                    EntityId id = this.directRemoves.poll();
                    this.debug(id, "RemoteEntityData[" + this.setId + "] direct remove:" + id);
                    this.transaction.directRemove(id);
                    directMods = true;
                }
            }
            if (!this.directAdds.isEmpty()) {
                while (!this.directAdds.isEmpty()) {
                    Entity d = this.directAdds.poll();
                    this.debug(d.getId(), "RemoteEntityData[" + this.setId + "] direct add:" + d.getId());
                    this.transaction.directAdd(d);
                    directMods = true;
                }
            }
            if (super.buildTransactionChanges(updates)) {
                return true;
            }
            return directMods;
        }

        @Override
        protected void entityChange(EntityChange change) {
            EntityId id = change.getEntityId();
            if (!this.containsId(id)) {
                boolean found = false;
                for (Entity e : this.directAdds) {
                    if (!id.equals(e.getId())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            } else if (this.directRemoves.contains(id)) {
                return;
            }
            super.entityChange(change);
        }

        protected void directAdd(Entity e) {
            this.directAdds.add(e);
        }

        protected void directRemove(EntityId id) {
            this.directRemoves.add(id);
        }
    }

    protected static class RemoteChangeQueue
    extends ChangeQueue {
        private int queueId;

        public RemoteChangeQueue(int queueId, ObservableEntityData ed, Class[] types) {
            super(ed, types);
            this.queueId = queueId;
        }

        protected EntityComponentListener getListener() {
            return super.getListener();
        }
    }
}

