/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.sound;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Listener;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.env.Environment;
import mythruna.client.env.FloatRangeEffect;
import mythruna.client.sound.AbstractAmbientSound;
import mythruna.client.sound.AmbientLoop;
import mythruna.client.sound.AmbientSound;

public class AmbientEnvironment
extends AbstractAmbientSound {
    private Application app;
    private AudioRenderer audioRenderer;
    private AssetManager assetManager;
    private float effectsVolume;
    private boolean effectsEnabled;
    private List<TimedSound> sounds = new ArrayList<TimedSound>();
    private Listener audioListener;

    public AmbientEnvironment(Application app, Listener listener) {
        this.app = app;
        this.audioRenderer = app.getAudioRenderer();
        this.assetManager = app.getAssetManager();
        this.audioListener = listener;
        AmbientLoop quietForest = new AmbientLoop(app, "Sounds/ambient/Quiet_Forest_Morning_Loop-low.ogg");
        AmbientLoop nightForest = new AmbientLoop(app, "Sounds/ambient/Crickets,_Night,_Forest_Edge,_Chirpy,_Steady-low.ogg");
        AmbientLoop meadow = new AmbientLoop(app, "Sounds/ambient/Meadow___Crickets___Birds___Crow-low.ogg");
        AmbientLoop morningBirds = new AmbientLoop(app, "Sounds/ambient/Pretty_Forest_Birds_Loop_01-low.ogg");
        AmbientLoop windInLeaves = new AmbientLoop(app, "Sounds/ambient/wind-low.ogg");
        this.addSound(nightForest, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
        this.addSound(windInLeaves, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.4f), Float.valueOf(0.8f), Float.valueOf(0.4f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.addSound(quietForest, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.addSound(morningBirds, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(-5.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.addSound(meadow, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.5f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(-2.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    protected void adjustVolume(float v) {
        for (TimedSound t : this.sounds) {
            t.loop.setMasterVolume(v);
        }
    }

    protected void adjustEnabled(boolean enabled) {
        for (TimedSound t : this.sounds) {
            t.setEnabled(enabled);
        }
    }

    public void addSound(AmbientSound sound, Float ... values) {
        Environment env = Environment.getInstance();
        TimedSound sound1 = new TimedSound(sound, values);
        this.sounds.add(sound1);
        env.addTimeEffect(sound1);
    }

    public void update(float tpf) {
        for (TimedSound t : this.sounds) {
            t.updateSound(tpf);
        }
    }

    public void stop() {
        for (TimedSound t : this.sounds) {
            t.stop();
        }
    }

    private class TimedSound
    extends FloatRangeEffect {
        private AmbientSound loop;
        private float volume;

        public TimedSound(AmbientSound loop, Float ... values) {
            super(values);
            this.volume = 0.0f;
            this.loop = loop;
        }

        public void setEnabled(boolean f) {
            this.loop.setEnabled(f);
        }

        protected void update(Float f) {
            if (f == null || f.floatValue() < 0.0f) {
                this.volume = 0.0f;
                return;
            }
            this.volume = f.floatValue();
        }

        public void stop() {
            this.loop.stop();
        }

        public void updateSound(float tpf) {
            if (this.volume > 0.0f) {
                this.loop.setVolume(this.volume);
                this.loop.update(tpf);
            } else {
                this.loop.stop();
            }
        }
    }
}

