/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs;

import com.jme3.app.Application;
import com.jme3.audio.AudioNode;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.HashMap;
import java.util.Map;
import mythruna.client.ClientOptions;
import mythruna.client.GameAppState;
import mythruna.client.GameClient;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.ui.AppStateListener;
import mythruna.client.ui.Button;
import mythruna.client.ui.Command;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.StateGroup;

public class TabState
extends StateGroup {
    private GameClient gameClient;
    private GuiAppState guiState;
    private AudioNode switchTabs;
    private AudioNode switchOff;
    private Node buttons;
    private float buttonScale = 1.0f;
    private ColorRGBA enabledColor = new ColorRGBA(0.20392157f, 0.44313726f, 0.8392157f, 1.0f);
    private Map<ObservableState, Tab> tabs = new HashMap<ObservableState, Tab>();

    public TabState(GameClient gameClient) {
        super("Tabs", false);
        this.gameClient = gameClient;
    }

    public Node getTabRoot() {
        return this.guiState.getPerspectiveRoot();
    }

    public Camera getTabCamera() {
        return this.guiState.getCamera();
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void isFocused(ObservableState state) {
        this.switchTabs.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.8f);
        this.switchTabs.play();
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.guiState = this.getState(GuiAppState.class);
        Camera cam = app.getCamera();
        this.buttonScale = Math.min(1.0f, (float)cam.getWidth() / 1000.0f);
        this.buttons = new Node("TabButtons");
        float buttonSpacing = 34.0f * this.buttonScale;
        int i = this.getStates().size() - 1;
        for (ObservableState state : this.getStates()) {
            Tab tab = new Tab(state);
            Button b = tab.getButton();
            b.setLocalTranslation(0.0f, (float)i * buttonSpacing, 0.0f);
            --i;
            this.tabs.put(state, tab);
            this.buttons.attachChild((Spatial)b);
        }
        this.buttons.setLocalTranslation(10.0f, (float)cam.getHeight() - buttonSpacing * (float)this.getStates().size() - 10.0f, 0.0f);
        this.switchTabs = new AudioNode(app.getAudioRenderer(), app.getAssetManager(), "Sounds/switch.ogg", false);
        this.switchTabs.setPositional(false);
        this.switchOff = new AudioNode(app.getAudioRenderer(), app.getAssetManager(), "Sounds/switch-off-short.ogg", false);
        this.switchOff.setPositional(false);
    }

    protected void enable() {
        super.enable();
        Node gui = this.getState(GameAppState.class).getGuiNode();
        this.guiState.addDependent(this);
        gui.attachChild((Spatial)this.buttons);
    }

    protected void disable() {
        super.disable();
        Node gui = this.getState(GameAppState.class).getGuiNode();
        this.switchOff.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.8f);
        this.switchOff.play();
        this.getState(AnimationState.class).add(Animation.detach((Spatial)this.buttons, 0.25f));
        this.guiState.removeDependent(this, 0.25f);
    }

    protected Button createButton(String text, float x, float y) {
        Button button = new Button(this.getApplication(), 151.0f, 34.0f);
        button.setText(text);
        button.setLocalTranslation(x, y, 10.0f);
        button.addControl((Control)new MouseEventControl());
        button.setLocalScale(this.buttonScale);
        return button;
    }

    public void render(RenderManager rm) {
        super.render(rm);
    }

    public void update(float tpf) {
    }

    private class Tab
    implements Command,
    AppStateListener {
        private Button tabSelector;
        private ObservableState appState;

        public Tab(ObservableState appState) {
            this.appState = appState;
            appState.addStateListener(this);
            this.tabSelector = TabState.this.createButton(appState.getName(), 0.0f, 0.0f);
            this.tabSelector.addCommand(this);
            this.stateEnabled(appState, appState.isEnabled());
        }

        public Button getButton() {
            return this.tabSelector;
        }

        public void stateEnabled(ObservableState state, boolean enabled) {
            if (enabled) {
                this.tabSelector.setTextColor(TabState.this.enabledColor);
            } else {
                this.tabSelector.setTextColor(null);
            }
        }

        public void execute(Object b, Object action) {
            this.appState.setEnabled(true);
        }
    }
}

