/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.bp;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.InputManager;
import com.jme3.input.Joystick;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.WireBox;
import com.jme3.texture.Texture;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Direction;
import mythruna.client.Avatar;
import mythruna.client.GameAppState;
import mythruna.client.GameClient;
import mythruna.client.KeyMethodAction;
import mythruna.client.ModeManager;
import mythruna.client.PostProcessingState;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.anim.AnimationTask;
import mythruna.client.tabs.TabState;
import mythruna.client.tabs.bp.BlockIconSelection;
import mythruna.client.tabs.bp.BlueprintIconSelection;
import mythruna.client.tabs.bp.BlueprintIntersector;
import mythruna.client.tabs.bp.BlueprintObject;
import mythruna.client.tabs.bp.Palette;
import mythruna.client.tabs.bp.Workbench;
import mythruna.client.ui.ActionCommand;
import mythruna.client.ui.Button;
import mythruna.client.ui.ButtonControl;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.PopupCommand;
import mythruna.client.ui.PopupMessageState;
import mythruna.db.BlueprintData;
import mythruna.es.EntityId;
import mythruna.es.action.RemoveBlueprintAction;
import mythruna.es.action.SaveBlueprintAction;
import mythruna.geom.Trifold;
import org.progeeks.util.ObjectUtils;

public class BlueprintEditorState
extends ObservableState {
    private static final String BP_LEFT = "BP_PanLeft";
    private static final String BP_RIGHT = "BP_PanRight";
    private static final String BP_UP = "BP_PanUp";
    private static final String BP_DOWN = "BP_PanDown";
    private static final String BP_FORWARD = "BP_Forward";
    private static final String BP_BACK = "BP_Back";
    private static final String BP_STRAFE_LEFT = "BP_StrafeLeft";
    private static final String BP_STRAFE_RIGHT = "BP_StrafeRight";
    private static final String BP_RAISE = "BP_Raise";
    private static final String BP_LOWER = "BP_Lower";
    private static final String BP_JUMP = "BP_Jump";
    private static final String BP_RUN = "BP_Run";
    private static final String BP_ADJUST_ITEM = "BP Adjust Sub-type";
    private static final String BP_ADJUST_TYPE = "BP Adjust Type";
    private static final String BP_ITEM_UP = "BP Item Up";
    private static final String BP_ITEM_DOWN = "BP Item Down";
    private static final String BP_TYPE_UP = "BP Type Up";
    private static final String BP_TYPE_DOWN = "BP Type Down";
    private static final String BP_CLONE_TYPE = "BP Clone Type";
    private static final String BP_SELECT = "BP_Select";
    private static final String BP_PLACE = "BP_Place";
    private static final String[] BP_MAPPINGS = new String[]{"BP_PanLeft", "BP_PanRight", "BP_PanUp", "BP_PanDown", "BP_Forward", "BP_Back", "BP_StrafeLeft", "BP_StrafeRight", "BP_Raise", "BP_Lower", "BP_Jump", "BP_Run", "BP Item Up", "BP Item Down", "BP_Select", "BP_Place", "BP Adjust Sub-type", "BP Type Up", "BP Type Down", "BP Clone Type"};
    private GameClient gameClient;
    private InputHandler inputHandler;
    private float yaw = 2.3561945f;
    private float pitch = 0.3926991f;
    private int bpSize = 10;
    private float distance = 12.0f;
    private float cameraDistance = 20.0f;
    private float setback = 0.0f;
    private float cameraElevation = 3.0f;
    private float buttonScale = 1.0f;
    private Workbench wb;
    private Node workbenchNode;
    private Avatar avatar;
    private float lastHeadAngle = 0.0f;
    private BlockIconSelection selector;
    private BlueprintIconSelection blueprintSelector;
    private BlueprintObject workingBlueprint;
    private EntityId workingBlueprintEntityId;
    private Palette palette;
    private PalettePage page = null;
    private int itemType = -1;
    private AnimationTask paletteMove = null;
    private Node buttons;
    private Geometry selectedBlock;
    private float blockSelectionUpdateTime = 0.0f;
    private BlueprintIntersector.Intersection lastHit = null;
    private Button[] paletteButtons;
    private KeyMethodAction rotate = new KeyMethodAction((Object)this, "rotate", 19);
    private KeyMethodAction mirror = new KeyMethodAction((Object)this, "mirror", 20);
    private float hitUpdateTime = 0.0f;

    public BlueprintEditorState(GameClient gameClient) {
        super("Blueprints", false);
        this.gameClient = gameClient;
        this.inputHandler = new InputHandler();
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void rotate() {
        System.out.println("Rotate blueprint...");
        System.out.println("Working blueprint:" + this.workingBlueprint);
        System.out.println("Working blueprint entityId:" + this.workingBlueprintEntityId);
        this.workingBlueprint.rotate();
        this.workingBlueprint.regenerateGeometry();
    }

    public void mirror() {
        System.out.println("Mirror blueprint...");
        System.out.println("Working blueprint:" + this.workingBlueprint);
        System.out.println("Working blueprint entityId:" + this.workingBlueprintEntityId);
        this.workingBlueprint.mirror();
        this.workingBlueprint.regenerateGeometry();
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.blueprintSelector = new BlueprintIconSelection(this, app, this.gameClient);
        Camera cam = app.getCamera();
        this.buttonScale = Math.min(1.0f, (float)cam.getWidth() / 960.0f);
        this.selector = new BlockIconSelection(app.getAssetManager());
        KeyMethodAction tab = new KeyMethodAction((Object)this, "toggleEnabled", 48);
        tab.attach(app.getInputManager());
        this.workingBlueprint = new BlueprintObject(this.bpSize, this.bpSize, this.bpSize);
        this.wb = new Workbench(this.bpSize);
        this.workbenchNode = this.wb.generateNode(0.8f, 0.8f);
        this.workbenchNode.attachChild((Spatial)this.workingBlueprint.getNode());
        WireBox boxMesh = new WireBox(0.51f, 0.51f, 0.51f);
        this.selectedBlock = new Geometry("Selected Block", (Mesh)boxMesh);
        Material boxMaterial = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        boxMaterial.setColor("Color", ColorRGBA.Yellow);
        this.selectedBlock.setMaterial(boxMaterial);
        this.avatar = new Avatar(app.getAssetManager(), "");
        this.avatar.setLocalTranslation(0.0f, this.avatar.getHeadHeight() * 4.0f, 0.0f);
        Vector3f avatarScale = this.avatar.getLocalScale();
        this.avatar.setLocalScale(avatarScale.mult(4.0f));
        this.avatar.setLighting(0.8f, 0.8f);
        this.workbenchNode.attachChild((Spatial)this.avatar);
        this.palette = new Palette(app);
        this.setPalettePage(PalettePage.BLUEPRINTS);
        this.buttons = new Node("Palette Buttons");
        float buttonSpacing = 36.0f;
        this.paletteButtons = new Button[3];
        this.paletteButtons[0] = this.createButton("Save", 0.0f, 2.0f * buttonSpacing * this.buttonScale);
        this.paletteButtons[0].addCommand(new SaveCommand());
        this.paletteButtons[1] = this.createButton("Clear", 0.0f, 1.0f * buttonSpacing * this.buttonScale);
        this.paletteButtons[1].addCommand(new PopupCommand(this.getStateManager(), "Are you sure you want to clear all blocks?", new ClearCommand(), new ActionCommand("Cancel")));
        this.paletteButtons[2] = this.createButton("Back", 0.0f, 0.0f * buttonSpacing * this.buttonScale);
        this.paletteButtons[2].addCommand(new CancelCommand());
        this.buttons.attachChild((Spatial)this.paletteButtons[0]);
        this.buttons.attachChild((Spatial)this.paletteButtons[1]);
        this.buttons.attachChild((Spatial)this.paletteButtons[2]);
    }

    protected void enable() {
        super.enable();
        ((PostProcessingState)this.getStateManager().getState(PostProcessingState.class)).setRadialFadeOn(1.5f, 1.5f);
        Node tabRoot = this.getState(TabState.class).getTabRoot();
        Node gui = this.getState(GameAppState.class).getGuiNode();
        Camera cam = this.getApplication().getCamera();
        float aspect = (float)cam.getWidth() / (float)cam.getHeight();
        if ((double)aspect < 1.4) {
            this.setback = 3.0f;
        }
        tabRoot.attachChild((Spatial)this.workbenchNode);
        this.registerWithInput(this.getApplication().getInputManager());
        tabRoot.attachChild((Spatial)this.palette);
        this.update(0.01f);
        ModeManager.instance.setMode(BP_ADJUST_TYPE, true);
        Ray upperLeft = this.getScreenRay(40, (int)((float)cam.getHeight() * 0.9f));
        cam = this.getState(TabState.class).getTabCamera();
        Vector3f pos = upperLeft.getOrigin().add(upperLeft.getDirection().mult(10.0f));
        this.getState(AnimationState.class).add(Animation.move((Spatial)this.workbenchNode, pos, Vector3f.ZERO, 0.25f));
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.workbenchNode, 0.01f, 1.0f, 0.25f));
        Vector3f palettePos = this.getPalettePosition();
        pos = this.screenToWorld(cam.getWidth(), cam.getHeight() - 20, 10.0f);
        this.paletteMove = Animation.move((Spatial)this.palette, pos, palettePos, 0.25f);
        this.getState(AnimationState.class).add(this.paletteMove);
        this.layoutPaletteButtons();
        this.showPaletteButtons(this.isEditing());
    }

    protected void disable() {
        super.disable();
        ((PostProcessingState)this.getStateManager().getState(PostProcessingState.class)).setRadialFade(false);
        Node tabRoot = this.getState(TabState.class).getTabRoot();
        Node gui = this.getState(GameAppState.class).getGuiNode();
        this.showPaletteButtons(false);
        ModeManager.instance.setMode(BP_ADJUST_TYPE, false);
        this.unregisterWithInput(this.getApplication().getInputManager());
        Camera cam = this.getState(TabState.class).getTabCamera();
        Ray upperLeft = this.getScreenRay(40, (int)((float)cam.getHeight() * 0.9f));
        Vector3f pos = upperLeft.getOrigin().add(upperLeft.getDirection().mult(10.0f));
        this.getState(AnimationState.class).add(Animation.detach((Spatial)this.workbenchNode, 0.25f), Animation.detach((Spatial)this.palette, 0.25f), Animation.scale((Spatial)this.workbenchNode, 1.0f, 0.01f, 0.25f), Animation.move((Spatial)this.workbenchNode, Vector3f.ZERO, pos, 0.25f));
        pos = this.screenToWorld(cam.getWidth(), cam.getHeight() - 20, 10.0f);
        this.paletteMove = Animation.move((Spatial)this.palette, this.palette.getLocalTranslation(), pos, 0.25f);
        this.getState(AnimationState.class).add(this.paletteMove);
    }

    protected Button createButton(String text, float x, float y) {
        float triRadius = 17.0f;
        float triWidth = 150.0f;
        Trifold trifold = new Trifold(triWidth, triRadius * 2.0f);
        trifold.setFoldTextureCoordinates(new Vector2f(0.5f, 0.5f), new Vector2f(0.5f, 0.5f));
        trifold.setFoldCoordinates(new Vector2f(triRadius, triRadius), new Vector2f(triWidth - triRadius, triRadius));
        trifold.updateGeometry();
        Texture texture = this.getApplication().getAssetManager().loadTexture("Interface/bubble.png");
        Button button = new Button(this.getApplication(), trifold, texture);
        button.setText(text);
        button.setLocalTranslation(x, y, 0.0f);
        button.addControl((Control)new MouseEventControl());
        button.setLocalScale(this.buttonScale);
        button.setTextColor(new ColorRGBA(0.4f, 0.6f, 0.6f, 1.0f));
        button.setTextShadowColor(new ColorRGBA(0.1f, 0.2f, 0.2f, 1.0f));
        return button;
    }

    protected void showPaletteButtons(boolean show) {
        if (this.buttons == null) {
            return;
        }
        if (!show && this.buttons.getParent() != null) {
            Camera cam = this.getApplication().getCamera();
            Vector3f pos = this.buttons.getLocalTranslation();
            Vector3f off = new Vector3f((float)cam.getWidth(), pos.y, pos.z);
            this.getState(AnimationState.class).add(Animation.detach((Spatial)this.buttons, 0.25f), Animation.move((Spatial)this.buttons, pos, off, 0.25f));
        } else if (show && this.buttons.getParent() == null) {
            Node gui = this.getState(GameAppState.class).getGuiNode();
            if (this.buttons.getParent() == null) {
                gui.attachChild((Spatial)this.buttons);
            }
            Camera cam = this.getApplication().getCamera();
            Vector2f paletteSize = this.palette.getPaletteScreenSize();
            Vector3f pos = new Vector3f((float)cam.getWidth() - paletteSize.x - 20.0f, 20.0f, 0.0f);
            Vector3f off = new Vector3f((float)cam.getWidth(), pos.y, pos.z);
            this.buttons.setLocalTranslation(off);
            this.getState(AnimationState.class).add(Animation.move((Spatial)this.buttons, off, pos, 0.25f));
        }
    }

    protected void layoutPaletteButtons() {
        Camera cam = this.getApplication().getCamera();
        Vector3f wCorner1 = this.palette.localToWorld(Vector3f.ZERO, null);
        Vector3f wCorner2 = this.palette.localToWorld(new Vector3f(4.4f, 0.0f, 0.0f), null);
        Vector3f corner1 = this.worldToScreen(wCorner1);
        Vector3f corner2 = this.worldToScreen(wCorner2);
        float w = (int)Math.abs(corner1.x - corner2.x) + 20;
        this.buttonScale = w / 150.0f;
        int y = this.paletteButtons.length - 1;
        float spacer = 2.0f;
        int i = 0;
        while (i < this.paletteButtons.length) {
            Button b = this.paletteButtons[i];
            float h = b.getHeight() + spacer;
            b.setLocalScale(this.buttonScale);
            b.setLocalTranslation(0.0f, (float)y * h * this.buttonScale, 0.0f);
            ++i;
            --y;
        }
        this.buttons.setLocalTranslation((float)cam.getWidth() - w - 20.0f, 20.0f, 0.0f);
    }

    protected void registerWithInput(InputManager inputManager) {
        inputManager.addMapping(BP_LEFT, new Trigger[]{new KeyTrigger(203)});
        inputManager.addMapping(BP_RIGHT, new Trigger[]{new KeyTrigger(205)});
        inputManager.addMapping(BP_UP, new Trigger[]{new KeyTrigger(200)});
        inputManager.addMapping(BP_DOWN, new Trigger[]{new KeyTrigger(208)});
        inputManager.addMapping(BP_STRAFE_LEFT, new Trigger[]{new KeyTrigger(30)});
        inputManager.addMapping(BP_STRAFE_RIGHT, new Trigger[]{new KeyTrigger(32)});
        inputManager.addMapping(BP_FORWARD, new Trigger[]{new KeyTrigger(17)});
        inputManager.addMapping(BP_BACK, new Trigger[]{new KeyTrigger(31)});
        inputManager.addMapping(BP_RAISE, new Trigger[]{new KeyTrigger(16)});
        inputManager.addMapping(BP_LOWER, new Trigger[]{new KeyTrigger(44)});
        inputManager.addMapping(BP_JUMP, new Trigger[]{new KeyTrigger(57)});
        inputManager.addMapping(BP_RUN, new Trigger[]{new KeyTrigger(42)});
        inputManager.addMapping(BP_SELECT, new Trigger[]{new MouseButtonTrigger(0)});
        inputManager.addMapping(BP_PLACE, new Trigger[]{new MouseButtonTrigger(1)});
        inputManager.addMapping(BP_ADJUST_ITEM, new Trigger[]{new KeyTrigger(29)});
        inputManager.addMapping(BP_TYPE_UP, new Trigger[]{new KeyTrigger(52)});
        inputManager.addMapping(BP_TYPE_DOWN, new Trigger[]{new KeyTrigger(51)});
        inputManager.addMapping(BP_CLONE_TYPE, new Trigger[]{new KeyTrigger(46)});
        inputManager.addListener((InputListener)this.inputHandler, BP_MAPPINGS);
        Joystick[] sticks = inputManager.getJoysticks();
        if (sticks != null && sticks.length > 0) {
            sticks[0].assignAxis(BP_STRAFE_RIGHT, BP_STRAFE_LEFT, 254);
            sticks[0].assignAxis(BP_FORWARD, BP_BACK, 255);
            sticks[0].assignAxis(BP_RIGHT, BP_LEFT, sticks[0].getXAxisIndex());
            sticks[0].assignAxis(BP_DOWN, BP_UP, sticks[0].getYAxisIndex());
        }
        ModeManager.instance.addMode(BP_ADJUST_ITEM, BP_ITEM_UP, BP_ITEM_DOWN, this.inputHandler);
        ModeManager.instance.addMode(BP_ADJUST_TYPE, BP_TYPE_UP, BP_TYPE_DOWN, this.inputHandler);
        this.rotate.attach(inputManager);
        this.mirror.attach(inputManager);
    }

    protected void unregisterWithInput(InputManager inputManager) {
        for (String s : BP_MAPPINGS) {
            inputManager.deleteMapping(s);
        }
        this.rotate.detach(inputManager);
        this.mirror.detach(inputManager);
        inputManager.removeListener((InputListener)this.inputHandler);
        ModeManager.instance.removeMode(BP_ADJUST_ITEM);
        ModeManager.instance.removeMode(BP_ADJUST_TYPE);
    }

    protected Ray getScreenRay(int x, int y) {
        Vector2f cursor = new Vector2f((float)x, (float)y);
        Camera cam = this.getState(TabState.class).getTabCamera();
        Vector3f clickFar = cam.getWorldCoordinates(cursor, 1.0f);
        Vector3f clickNear = cam.getWorldCoordinates(cursor, 0.0f);
        Ray mouseRay = new Ray(clickNear, clickFar.subtractLocal(clickNear).normalizeLocal());
        return mouseRay;
    }

    protected Vector3f screenToWorld(float x, float y, float distance) {
        Ray upperLeft = this.getScreenRay((int)x, (int)y);
        Vector3f pos = upperLeft.getOrigin().add(upperLeft.getDirection().mult(distance));
        return pos;
    }

    protected Vector3f worldToScreen(Vector3f world) {
        Camera cam = this.getState(TabState.class).getTabCamera();
        if (cam == null) {
            return world;
        }
        return cam.getScreenCoordinates(world);
    }

    protected float screenSize(float distance, float size) {
        Camera cam = this.getState(TabState.class).getTabCamera();
        Vector3f world = cam.getLocation().add(cam.getDirection().mult(distance));
        Vector3f left = world.add(cam.getLeft().mult(size));
        Vector3f screen1 = cam.getScreenCoordinates(world);
        Vector3f screen2 = cam.getScreenCoordinates(left);
        return Math.abs(screen2.x - screen1.x);
    }

    protected CollisionResults getHits() {
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        Camera cam = this.getState(TabState.class).getTabCamera();
        Vector3f clickFar = cam.getWorldCoordinates(cursor, 1.0f);
        Vector3f clickNear = cam.getWorldCoordinates(cursor, 0.0f);
        Ray mouseRay = new Ray(clickNear, clickFar.subtractLocal(clickNear).normalizeLocal());
        CollisionResults results = new CollisionResults();
        Node tabRoot = this.getState(TabState.class).getTabRoot();
        int count = tabRoot.collideWith((Collidable)mouseRay, results);
        return results;
    }

    protected boolean clickNode(Spatial s) {
        if (s == null) {
            return false;
        }
        ButtonControl c = (ButtonControl)s.getControl(ButtonControl.class);
        if (c != null) {
            c.click();
            return true;
        }
        return this.clickNode((Spatial)s.getParent());
    }

    protected boolean clickUI(String action, boolean pressed) {
        CollisionResults results = this.getHits();
        for (CollisionResult cr : results) {
            Geometry g = cr.getGeometry();
            System.out.println("hit:" + g + "  parent:" + g.getParent());
            if (!this.clickNode((Spatial)g)) continue;
            return true;
        }
        return false;
    }

    public void update(float tpf) {
        this.blueprintSelector.update();
        Camera cam = this.getState(TabState.class).getTabCamera();
        Vector3f position = new Vector3f(0.0f, 0.0f, this.cameraDistance + this.setback);
        Quaternion rot1 = new Quaternion().fromAngles(-this.pitch, 0.0f, 0.0f);
        Quaternion rot2 = new Quaternion().fromAngles(0.0f, this.yaw, 0.0f);
        Quaternion rot = rot2.mult(rot1);
        position = rot.mult(position);
        position.y += this.cameraElevation;
        cam.setLocation(position);
        rot1 = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot2 = new Quaternion().fromAngles(0.0f, this.yaw + (float)Math.PI, 0.0f);
        rot = rot2.mult(rot1);
        cam.setRotation(rot);
        rot = new Quaternion().fromAngles(0.0f, this.yaw + 1.5707964f, 0.0f);
        position = new Vector3f(0.0f, 0.0f, -((float)this.bpSize - 1.5f));
        position = rot.mult(position);
        this.avatar.setLocalTranslation(position.x, this.avatar.getHeadHeight() * 4.0f, position.z);
        if (!this.getState(AnimationState.class).hasTask(this.paletteMove)) {
            Vector3f palettePos = this.getPalettePosition();
            this.palette.setLocalTranslation(palettePos);
        }
        rot = cam.getRotation();
        this.palette.setLocalRotation(cam.getRotation());
        this.palette.setIconRotation(cam.getRotation().inverse());
        this.setItemType(this.selector.getTypeId());
        this.refreshSelectionHighlight();
        this.palette.recalculate();
        this.blockSelectionUpdateTime += tpf;
        if (this.blockSelectionUpdateTime > 0.1f) {
            this.blockSelectionUpdateTime = 0.0f;
            this.setCurrentHit(this.getHit());
        }
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        float headAngle = cursor.y / (float)cam.getHeight() - 0.5f;
        if ((headAngle *= 1.5707964f) != this.lastHeadAngle) {
            this.lastHeadAngle = headAngle;
            Quaternion headLift = new Quaternion().fromAngles(-headAngle, (float)(-Math.PI), 0.0f);
            this.avatar.setFacing(headLift);
        }
    }

    protected Vector3f getPalettePosition() {
        Camera cam = this.getState(TabState.class).getTabCamera();
        float w = this.screenSize(10.0f, this.palette.getWidth()) + 30.0f;
        float h = this.screenSize(10.0f, 0.3f);
        return this.screenToWorld((float)cam.getWidth() - w, (float)cam.getHeight() - (h += 30.0f), 10.0f);
    }

    protected void setItemType(int type) {
        if (this.itemType == type) {
            return;
        }
        this.itemType = type;
    }

    protected Spatial getSelected() {
        Spatial selected = null;
        switch (this.page) {
            case BLUEPRINTS: {
                break;
            }
            case GROUPS: {
                int group = this.selector.getGroup();
                if (group >= this.palette.getIcons().size()) break;
                selected = this.palette.getIcons().get(group);
                break;
            }
            case TYPES: {
                int item = this.selector.getItemType();
                if (item >= this.palette.getIcons().size()) break;
                selected = this.palette.getIcons().get(item);
            }
        }
        return selected;
    }

    protected void refreshSelectionHighlight() {
        Spatial selected = this.getSelected();
        this.palette.setSelectedIcon(selected);
    }

    protected void refreshBlueprints() {
        if (this.page == PalettePage.BLUEPRINTS) {
            this.palette.setIcons(this.blueprintSelector.getIcons());
        }
    }

    protected boolean isEditing() {
        return this.page == PalettePage.GROUPS || this.page == PalettePage.TYPES;
    }

    protected void setPalettePage(PalettePage p) {
        if (this.page == p) {
            return;
        }
        this.page = p;
        switch (this.page) {
            case BLUEPRINTS: {
                this.palette.setIcons(this.blueprintSelector.getIcons());
                break;
            }
            case GROUPS: {
                this.palette.setIcons(this.selector.getGroupIcons());
                break;
            }
            case TYPES: {
                this.palette.setIcons(this.selector.getTypeIcons());
            }
        }
        this.showPaletteButtons(this.isEditing());
    }

    protected void setWorkingBlueprint(BlueprintData blueprint, EntityId entityId) {
        System.out.println("Set blueprint:" + blueprint);
        this.setPalettePage(PalettePage.GROUPS);
        if (blueprint != null) {
            this.workingBlueprint.copyData(blueprint);
        } else {
            this.workingBlueprint.clear();
        }
        this.workingBlueprint.regenerateGeometry();
        this.workingBlueprintEntityId = entityId;
    }

    protected Ray getObjectMouseRay() {
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        Camera cam = this.getState(TabState.class).getTabCamera();
        Vector3f clickFar = cam.getWorldCoordinates(cursor, 1.0f);
        this.swap(clickFar);
        Vector3f clickNear = cam.getWorldCoordinates(cursor, 0.0f);
        this.swap(clickNear);
        Ray mouseRay = new Ray(clickNear, clickFar.subtractLocal(clickNear).normalizeLocal());
        mouseRay.setLimit(this.cameraDistance + this.setback + (float)this.bpSize);
        Vector3f origin = mouseRay.getOrigin();
        origin.addLocal((float)this.bpSize * 0.5f, (float)this.bpSize * 0.5f, 0.0f);
        return mouseRay;
    }

    protected void swap(Vector3f v) {
        float t = v.z;
        v.z = v.y;
        v.y = t;
    }

    protected BlueprintIntersector.Intersection getHit() {
        BlueprintIntersector.Intersection hit;
        block0: {
            BlueprintIntersector.Intersection i;
            Ray ray = this.getObjectMouseRay();
            BlueprintIntersector intersector = new BlueprintIntersector(this.workingBlueprint.getCells(), this.bpSize, ray);
            hit = null;
            if (!intersector.hasNext()) break block0;
            hit = i = intersector.next();
        }
        return hit;
    }

    protected void setCurrentHit(BlueprintIntersector.Intersection hit) {
        Vector3f cell;
        if (ObjectUtils.areEqual((Object)this.lastHit, (Object)hit)) {
            return;
        }
        if (hit != null && !this.wb.contains(cell = hit.getBlock()) && !this.wb.contains(cell.add(0.0f, 0.0f, 1.0f))) {
            hit = null;
        }
        this.lastHit = hit;
        if (hit == null) {
            this.selectedBlock.removeFromParent();
            return;
        }
        if (this.selectedBlock.getParent() == null) {
            this.workbenchNode.attachChild((Spatial)this.selectedBlock);
        }
        cell = hit.getBlock();
        Vector3f model = this.wb.cellToModel(cell);
        this.selectedBlock.setLocalTranslation(model.x + 0.5f, model.y + 0.5f, model.z + 0.5f);
    }

    protected class DiscardCommand
    extends ActionCommand {
        public DiscardCommand() {
            super("Discard");
        }

        public void execute(Object source, Object a) {
            BlueprintEditorState.this.workingBlueprint.clear();
            BlueprintEditorState.this.workingBlueprint.regenerateGeometry();
            BlueprintEditorState.this.setPalettePage(PalettePage.BLUEPRINTS);
        }
    }

    protected class RemoveCommand
    extends ActionCommand {
        public RemoveCommand() {
            super("Delete");
        }

        public void execute(Object source, Object a) {
            RemoveBlueprintAction action = new RemoveBlueprintAction();
            BlueprintEditorState.this.gameClient.executeAction(action, BlueprintEditorState.this.workingBlueprintEntityId);
            BlueprintEditorState.this.workingBlueprint.clear();
            BlueprintEditorState.this.workingBlueprint.regenerateGeometry();
            BlueprintEditorState.this.setPalettePage(PalettePage.BLUEPRINTS);
        }
    }

    protected class SaveCommand
    extends ActionCommand {
        public SaveCommand() {
            super("Save");
        }

        public void execute(Object source, Object a) {
            if (BlueprintEditorState.this.workingBlueprintEntityId != null && BlueprintEditorState.this.workingBlueprint.isEmpty()) {
                BlueprintEditorState.this.getApplication().getStateManager().attach((AppState)new PopupMessageState("Really delete blueprint?", new RemoveCommand(), new ActionCommand("Cancel")));
                return;
            }
            if (!BlueprintEditorState.this.workingBlueprint.isChanged()) {
                return;
            }
            System.out.println("Working entity id:" + BlueprintEditorState.this.workingBlueprintEntityId);
            BlueprintEditorState.this.workingBlueprint.pack();
            SaveBlueprintAction action = new SaveBlueprintAction(BlueprintEditorState.this.workingBlueprintEntityId, "Unnamed", BlueprintEditorState.this.workingBlueprint.getSizeX(), BlueprintEditorState.this.workingBlueprint.getSizeY(), BlueprintEditorState.this.workingBlueprint.getSizeZ(), 0.25f, BlueprintEditorState.this.workingBlueprint.getCells());
            BlueprintEditorState.this.gameClient.executeAction(action, null);
            BlueprintEditorState.this.workingBlueprint.resetSize(BlueprintEditorState.this.bpSize, BlueprintEditorState.this.bpSize, BlueprintEditorState.this.bpSize);
            BlueprintEditorState.this.workingBlueprint.regenerateGeometry();
            BlueprintEditorState.this.setPalettePage(PalettePage.BLUEPRINTS);
        }
    }

    protected class CancelCommand
    extends ActionCommand {
        public CancelCommand() {
            super("Cancel");
        }

        public void execute(Object source, Object a) {
            if (BlueprintEditorState.this.getState(PopupMessageState.class) != null) {
                System.out.println("Not popping up message because a message is already popped up.");
                return;
            }
            if (!BlueprintEditorState.this.workingBlueprint.isChanged()) {
                new DiscardCommand().execute((Object)null, a);
                return;
            }
            BlueprintEditorState.this.getApplication().getStateManager().attach((AppState)new PopupMessageState("Save changes before returning?", new SaveCommand(), new DiscardCommand(), new ActionCommand("Cancel")));
        }
    }

    protected class ClearCommand
    extends ActionCommand {
        public ClearCommand() {
            super("Clear");
        }

        public void execute(Object source, Object a) {
            BlueprintEditorState.this.workingBlueprint.clear();
            BlueprintEditorState.this.workingBlueprint.regenerateGeometry();
        }
    }

    private class InputHandler
    implements AnalogListener,
    ActionListener {
        private float moveSpeed = 4.0f;
        private float angleSpeed = 2.0f;
        private float coangleSpeed = 2.0f;

        public void onAnalog(String name, float value, float tpf) {
            if (BlueprintEditorState.BP_ADJUST_ITEM.equals(name)) {
                return;
            }
            if (BlueprintEditorState.BP_FORWARD.equals(name)) {
                BlueprintEditorState.this.distance -= this.moveSpeed * tpf;
                BlueprintEditorState.this.pitch += this.coangleSpeed * tpf;
                if (BlueprintEditorState.this.pitch > 1.5707964f) {
                    BlueprintEditorState.this.pitch = 1.5707964f;
                }
            } else if (BlueprintEditorState.BP_BACK.equals(name)) {
                BlueprintEditorState.this.distance += this.moveSpeed * tpf;
                BlueprintEditorState.this.pitch -= this.coangleSpeed * tpf;
                if (BlueprintEditorState.this.pitch < 0.0f) {
                    BlueprintEditorState.this.pitch = 0.0f;
                }
            } else if (BlueprintEditorState.BP_STRAFE_LEFT.equals(name)) {
                BlueprintEditorState.this.yaw -= this.angleSpeed * tpf;
            } else if (BlueprintEditorState.BP_STRAFE_RIGHT.equals(name)) {
                BlueprintEditorState.this.yaw += this.angleSpeed * tpf;
            } else if (BlueprintEditorState.BP_ITEM_UP.equals(name)) {
                BlueprintEditorState.this.selector.incrementItemType();
            } else if (BlueprintEditorState.BP_ITEM_DOWN.equals(name)) {
                BlueprintEditorState.this.selector.decrementItemType();
            } else if (BlueprintEditorState.BP_TYPE_UP.equals(name)) {
                BlueprintEditorState.this.selector.incrementGroup();
            } else if (BlueprintEditorState.BP_TYPE_DOWN.equals(name)) {
                BlueprintEditorState.this.selector.decrementGroup();
            }
        }

        public void onAction(String name, boolean value, float tpf) {
            if (BlueprintEditorState.BP_ADJUST_ITEM.equals(name) && BlueprintEditorState.this.isEditing()) {
                ModeManager.instance.setMode(BlueprintEditorState.BP_ADJUST_ITEM, value);
                if (!value) {
                    ModeManager.instance.setMode(BlueprintEditorState.BP_ADJUST_TYPE, true);
                }
                if (value) {
                    BlueprintEditorState.this.setPalettePage(PalettePage.TYPES);
                } else {
                    BlueprintEditorState.this.setPalettePage(PalettePage.GROUPS);
                }
            }
            if (value) {
                return;
            }
            if (BlueprintEditorState.BP_PLACE.equals(name)) {
                if (BlueprintEditorState.this.clickUI(name, value)) {
                    return;
                }
                if (!BlueprintEditorState.this.isEditing()) {
                    return;
                }
                BlueprintIntersector.Intersection hit = BlueprintEditorState.this.getHit();
                if (hit == null) {
                    return;
                }
                Vector3f block = hit.getBlock();
                int side = hit.getSide();
                if (side < 0) {
                    return;
                }
                block.x += (float)Direction.DIRS[side][0];
                block.y += (float)Direction.DIRS[side][1];
                block.z += (float)Direction.DIRS[side][2];
                BlockType placeType = BlueprintEditorState.this.selector.getSelectedType();
                int existing = BlueprintEditorState.this.workingBlueprint.getType(block.x, block.y, block.z);
                if (existing == 0 && BlueprintEditorState.this.workingBlueprint.setType(block.x, block.y, block.z, placeType.getId())) {
                    BlueprintEditorState.this.workingBlueprint.regenerateGeometry();
                }
            } else if (BlueprintEditorState.BP_SELECT.equals(name)) {
                if (BlueprintEditorState.this.clickUI(name, value)) {
                    return;
                }
                if (!BlueprintEditorState.this.isEditing()) {
                    return;
                }
                BlueprintIntersector.Intersection hit = BlueprintEditorState.this.getHit();
                if (hit == null) {
                    return;
                }
                Vector3f block = hit.getBlock();
                if (BlueprintEditorState.this.workingBlueprint.setType(block.x, block.y, block.z, 0)) {
                    BlueprintEditorState.this.workingBlueprint.regenerateGeometry();
                }
            } else if (BlueprintEditorState.BP_CLONE_TYPE.equals(name) && BlueprintEditorState.this.isEditing()) {
                BlueprintIntersector.Intersection hit = BlueprintEditorState.this.getHit();
                if (hit == null) {
                    return;
                }
                System.out.println("hit type:" + hit.getType());
                if (hit.getType() <= 0) {
                    return;
                }
                BlockType blockType = BlockTypeIndex.types[hit.getType()];
                BlueprintEditorState.this.selector.setSelectedType(blockType);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PalettePage {
        BLUEPRINTS,
        GROUPS,
        TYPES;

    }
}

