/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.bp;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.shape.Box;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import mythruna.World;
import mythruna.client.GameClient;
import mythruna.client.tabs.bp.BlueprintEditorState;
import mythruna.client.tabs.bp.BlueprintObject;
import mythruna.client.ui.ButtonControl;
import mythruna.client.ui.Command;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.client.ui.VAlignment;
import mythruna.db.BlueprintData;
import mythruna.es.BlueprintReference;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.InContainer;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintIconSelection {
    static Log log = Log.getLog();
    private BlueprintEditorState editor;
    private Application app;
    private AssetManager assets;
    private GameClient gameClient;
    private World world;
    private Box boxMesh;
    private WireBox wireMesh;
    private Material boxMaterial;
    private Material wireMaterial;
    private Map<EntityId, Spatial> icons = new TreeMap<EntityId, Spatial>();
    private EntitySet blueprints;

    public BlueprintIconSelection(BlueprintEditorState editor, Application app, GameClient gameClient) {
        this.editor = editor;
        this.app = app;
        this.assets = app.getAssetManager();
        this.gameClient = gameClient;
        this.world = gameClient.getWorld();
        this.boxMesh = new Box(0.51f, 0.51f, 0.51f);
        this.wireMesh = new WireBox(0.51f, 0.51f, 0.51f);
        this.boxMaterial = new Material(this.assets, "Common/MatDefs/Misc/Unshaded.j3md");
        this.boxMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.01f));
        this.boxMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.boxMaterial.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Front);
        this.wireMaterial = new Material(this.assets, "Common/MatDefs/Misc/Unshaded.j3md");
        this.wireMaterial.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.1f));
        this.wireMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        EntityData ed = this.world.getEntityData();
        this.blueprints = ed.getEntities(new FieldFilter<InContainer>(InContainer.class, "parentId", gameClient.getPlayer()), InContainer.class, BlueprintReference.class);
        this.icons.put(EntityId.NULL_ID, (Spatial)this.createNewIcon());
        for (Entity e : this.blueprints) {
            BlueprintReference ref = e.get(BlueprintReference.class);
            BlueprintData bp = this.world.getBlueprint(ref.getBlueprintId());
            this.icons.put(e.getId(), (Spatial)this.createBlueprintIcon(e.getId(), bp));
        }
    }

    public Collection<Spatial> getIcons() {
        return this.icons.values();
    }

    public void update() {
        if (this.blueprints.applyChanges()) {
            BlueprintData bp;
            BlueprintReference ref;
            log.trace((Object)"******* There are blueprint changes...");
            for (Entity e : this.blueprints.getAddedEntities()) {
                log.trace((Object)("  added:" + e));
                ref = e.get(BlueprintReference.class);
                bp = this.world.getBlueprint(ref.getBlueprintId());
                this.icons.put(e.getId(), (Spatial)this.createBlueprintIcon(e.getId(), bp));
            }
            for (Entity e : this.blueprints.getChangedEntities()) {
                log.trace((Object)("  changed:" + e));
                ref = e.get(BlueprintReference.class);
                bp = this.world.getBlueprint(ref.getBlueprintId());
                this.icons.put(e.getId(), (Spatial)this.createBlueprintIcon(e.getId(), bp));
            }
            for (Entity e : this.blueprints.getRemovedEntities()) {
                log.trace((Object)("  removed:" + e));
                Spatial icon = this.icons.remove(e.getId());
                if (icon == null) continue;
            }
            this.editor.refreshBlueprints();
        }
    }

    protected Node createBlueprintIcon(EntityId entityId, BlueprintData bp) {
        BlueprintObject obj = new BlueprintObject(bp);
        obj.pack();
        obj.setOffset(new Vector3f((float)obj.getSizeX() * 0.5f, (float)obj.getSizeY() * 0.5f, (float)obj.getSizeZ() * 0.5f));
        Node n = obj.getNode();
        int max = Math.max(obj.getSizeX(), obj.getSizeY());
        max = Math.max(max, obj.getSizeZ());
        n.setLocalScale(1.0f / (float)max);
        Geometry box = new Geometry("Icon:" + bp.name + " Box", (Mesh)this.boxMesh);
        box.setMaterial(this.boxMaterial);
        box.setQueueBucket(RenderQueue.Bucket.Transparent);
        box.setLocalScale((float)max);
        Geometry wireBox = new Geometry("Icon:" + bp.name + " Wire", (Mesh)this.wireMesh);
        wireBox.setMaterial(this.wireMaterial);
        wireBox.setQueueBucket(RenderQueue.Bucket.Transparent);
        wireBox.setLocalScale((float)max);
        n.addControl((Control)new ButtonControl());
        ((ButtonControl)n.getControl(ButtonControl.class)).addCommand(new SelectBlueprintCommand(entityId, bp));
        box.addControl((Control)new ButtonControl());
        ((ButtonControl)box.getControl(ButtonControl.class)).addCommand(new SelectBlueprintCommand(entityId, bp));
        n.attachChild((Spatial)box);
        n.attachChild((Spatial)wireBox);
        n.setUserData("id", (Object)entityId.getId());
        return n;
    }

    protected Node createNewIcon() {
        Node n = new Node("New");
        Label l = new Label(this.app);
        l.setHAlignment(HAlignment.CENTER);
        l.setVAlignment(VAlignment.CENTER);
        l.setText("New");
        l.setLocalScale(0.02f);
        l.addControl((Control)new BillboardControl());
        n.attachChild((Spatial)l);
        Geometry box = new Geometry("Icon: New Box", (Mesh)this.boxMesh);
        box.setMaterial(this.boxMaterial);
        box.setQueueBucket(RenderQueue.Bucket.Transparent);
        Geometry wireBox = new Geometry("Icon: New Wire", (Mesh)this.wireMesh);
        wireBox.setMaterial(this.wireMaterial);
        wireBox.setQueueBucket(RenderQueue.Bucket.Transparent);
        n.addControl((Control)new ButtonControl());
        ((ButtonControl)n.getControl(ButtonControl.class)).addCommand(new SelectBlueprintCommand(null, null));
        box.addControl((Control)new ButtonControl());
        ((ButtonControl)box.getControl(ButtonControl.class)).addCommand(new SelectBlueprintCommand(null, null));
        n.attachChild((Spatial)box);
        n.attachChild((Spatial)wireBox);
        return n;
    }

    protected class SelectBlueprintCommand
    implements Command {
        private EntityId itemId;
        private BlueprintData blueprint;

        public SelectBlueprintCommand(EntityId itemId, BlueprintData blueprint) {
            this.itemId = itemId;
            this.blueprint = blueprint;
        }

        public void execute(Object source, Object action) {
            BlueprintIconSelection.this.editor.setWorkingBlueprint(this.blueprint, this.itemId);
        }
    }
}

