/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.map;

import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.Coordinates;
import mythruna.Vector3i;
import mythruna.client.tabs.map.MapTile;
import mythruna.client.tabs.map.MapUtils;
import mythruna.db.ColumnInfo;
import mythruna.db.LeafChangeEvent;
import mythruna.db.LeafChangeListener;
import mythruna.db.LeafInfo;
import mythruna.db.WorldDatabase;

public class MapBuilder {
    private static final int LEAF_COUNT = 32;
    private static final int SIZE = 1024;
    private static final ColumnInfo NULL_COLUMN = new ColumnInfo(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private WorldDatabase worldDb;
    private ColumnInfo[][] infos;
    private byte[][] types;
    private int xLast;
    private int yLast;
    private long lastRefreshTime = 0L;
    private long refreshDelta = 1000L;
    private BufferedImage map;
    private BufferedImage working;
    private ConcurrentHashMap<Vector3i, ColumnInfo> updates = new ConcurrentHashMap();
    private LeafObserver leafObserver = new LeafObserver();

    public MapBuilder(WorldDatabase worldDb) {
        this.worldDb = worldDb;
        worldDb.addLeafChangeListener(this.leafObserver);
    }

    public int getImageSize() {
        return 1024;
    }

    protected boolean containsColumn(int x, int y) {
        if (x < this.xLast || y < this.yLast) {
            return false;
        }
        return (x -= this.xLast) < 32 && (y -= this.yLast) < 32;
    }

    protected ColumnInfo getInfo(int x, int y) {
        if (this.infos == null) {
            return null;
        }
        if (x < this.xLast || y < this.yLast) {
            return null;
        }
        if ((x -= this.xLast) >= 32 || (y -= this.yLast) >= 32) {
            return null;
        }
        return this.infos[x][y];
    }

    protected void resetLocation(int x, int y) {
        ColumnInfo[][] arrays = new ColumnInfo[32][32];
        this.types = new byte[1024][1024];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                arrays[i][j] = this.getInfo(x + i, y + j);
                if (arrays[i][j] != null) {
                    this.copyTypes(x, y, arrays[i][j]);
                    continue;
                }
                Vector3i loc = new Vector3i(Coordinates.leafToWorld(x + i), Coordinates.leafToWorld(y + j), 0);
                arrays[i][j] = this.worldDb.getColumnInfo(loc.x, loc.y, false);
                if (arrays[i][j] == null) continue;
                this.copyTypes(x, y, arrays[i][j]);
            }
        }
        this.xLast = x;
        this.yLast = y;
        this.infos = arrays;
    }

    protected void copyTypes(int xBase, int yBase, ColumnInfo info) {
        xBase = info.getX() - Coordinates.leafToWorld(xBase);
        yBase = info.getY() - Coordinates.leafToWorld(yBase);
        byte[][] colTypes = info.getTypes();
        byte[][] elevations = info.getElevations();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                byte t;
                this.types[xBase + i][yBase + j] = t = MapTile.typeToTerrain(colTypes[i][j], elevations[i][j] & 0xFF);
            }
        }
    }

    protected void applyChanges() {
        Iterator<Map.Entry<Vector3i, ColumnInfo>> i = this.updates.entrySet().iterator();
        while (i.hasNext()) {
            int y;
            int x;
            Map.Entry<Vector3i, ColumnInfo> e = i.next();
            i.remove();
            Vector3i v = e.getKey();
            ColumnInfo info = e.getValue();
            if (info == NULL_COLUMN) {
                info = this.worldDb.getColumnInfo(v.x, v.y, false);
            }
            if (info == null || !this.containsColumn(x = Coordinates.worldToLeaf(info.getX()), y = Coordinates.worldToLeaf(info.getY()))) continue;
            this.infos[x -= this.xLast][y -= this.yLast] = info;
            this.copyTypes(this.xLast, this.yLast, info);
        }
    }

    protected void generateMap() {
        if (this.map == null) {
            System.out.println("Creating map images...");
            int imageSize = 1024;
            this.map = new BufferedImage(imageSize, imageSize, 2);
            this.working = new BufferedImage(imageSize, imageSize, 2);
        }
        this.map = MapUtils.drawImage(this.working, this.map, this.types, this.xLast, this.yLast, 32);
    }

    public BufferedImage getLastMap() {
        return this.map;
    }

    protected boolean needsRefresh(int x, int y) {
        if (this.infos == null) {
            return true;
        }
        if (this.xLast == x && this.yLast == y && this.updates.size() == 0) {
            return false;
        }
        long time = System.currentTimeMillis();
        return time >= this.lastRefreshTime + this.refreshDelta;
    }

    public BufferedImage getMapImage(int x, int y) {
        if (!this.needsRefresh(x, y)) {
            return null;
        }
        this.resetLocation(x, y);
        this.applyChanges();
        this.generateMap();
        this.lastRefreshTime = System.currentTimeMillis();
        return this.map;
    }

    private class LeafObserver
    implements LeafChangeListener {
        private LeafObserver() {
        }

        public void leafChanged(LeafChangeEvent event) {
            LeafInfo info = event.getLeaf().getInfo();
            Vector3i column = new Vector3i(info.x, info.y, 0);
            MapBuilder.this.updates.put(column, NULL_COLUMN);
        }
    }
}

