/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.map;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import mythruna.client.tabs.map.WorldMap;

public class MapUtils {
    private static float fallOff = 0.01f;

    public static BufferedImage createImage(WorldMap worldMap, int xLeaf, int yLeaf, int size) {
        return MapUtils.createImage(worldMap.getTypes(xLeaf, yLeaf, size), xLeaf, yLeaf, size);
    }

    public static BufferedImage createImage(byte[][] types, int xLeaf, int yLeaf, int size) {
        int imageSize = size * 32;
        System.out.println("Creating map images...");
        BufferedImage map = new BufferedImage(imageSize, imageSize, 2);
        BufferedImage background = new BufferedImage(imageSize, imageSize, 2);
        return MapUtils.drawImage(map, background, types, xLeaf, yLeaf, size);
    }

    public static BufferedImage drawImage(BufferedImage map, BufferedImage background, byte[][] types, int xLeaf, int yLeaf, int size) {
        int y;
        System.out.println("Drawing map...");
        int imageSize = size * 32;
        int[] pixels = ((DataBufferInt)map.getRaster().getDataBuffer()).getData();
        int[] bgPixels = ((DataBufferInt)background.getRaster().getDataBuffer()).getData();
        Arrays.fill(pixels, 0);
        Arrays.fill(bgPixels, 0);
        Graphics g = background.getGraphics();
        System.out.println("Building image from types...");
        long start = System.nanoTime();
        int border = 2;
        int index = border + border * imageSize;
        int skip = border * 2;
        float[][] alpha = new float[imageSize][imageSize];
        int waterColor = 2782367;
        int groundColor = 7839560;
        for (y = 2; y < imageSize - 2; ++y) {
            int lastEdge = -1;
            for (int x = 2; x < imageSize - 2; ++x) {
                int c = 0;
                byte t = types[x][y];
                if (t == 0) {
                    if (lastEdge >= 0) {
                        MapUtils.xAlphaSpan(alpha, lastEdge, -1, y, imageSize);
                        lastEdge = -1;
                    }
                } else if (t == 1) {
                    int count = 0;
                    if (types[x - 1][y - 1] > 1) {
                        ++count;
                    }
                    if (types[x][y - 1] > 1) {
                        ++count;
                    }
                    if (types[x + 1][y - 1] > 1) {
                        ++count;
                    }
                    if (types[x - 1][y] > 1) {
                        ++count;
                    }
                    if (types[x + 1][y] > 1) {
                        ++count;
                    }
                    if (types[x - 1][y + 1] > 1) {
                        ++count;
                    }
                    if (types[x][y + 1] > 1) {
                        ++count;
                    }
                    if (types[x + 1][y + 1] > 1) {
                        ++count;
                    }
                    if (types[x - 2][y - 2] > 1) {
                        ++count;
                    }
                    if (types[x][y - 2] > 1) {
                        ++count;
                    }
                    if (types[x + 2][y - 2] > 1) {
                        ++count;
                    }
                    if (types[x - 2][y] > 1) {
                        ++count;
                    }
                    if (types[x + 2][y] > 1) {
                        ++count;
                    }
                    if (types[x - 2][y + 2] > 1) {
                        ++count;
                    }
                    if (types[x][y + 2] > 1) {
                        ++count;
                    }
                    if (types[x + 2][y + 2] > 1) {
                        ++count;
                    }
                    if (count > 0) {
                        MapUtils.xAlphaSpan(alpha, lastEdge, x, y, imageSize);
                        lastEdge = x;
                        float darken = Math.max(0.25f, 1.0f - (float)count / 6.0f);
                        if (darken < 0.0f) {
                            darken = 0.0f;
                        }
                        alpha[x][y] = 1.0f;
                        c = (int)(255.0f * (1.0f - darken)) << 24;
                    } else {
                        c = waterColor;
                    }
                } else if (t != 0) {
                    c = groundColor;
                }
                if (c != 0) {
                    pixels[index] = c;
                }
                ++index;
            }
            if (lastEdge >= 0) {
                MapUtils.xAlphaSpan(alpha, lastEdge, -1, y, imageSize);
            }
            index += skip;
        }
        for (int x = 0; x < imageSize; ++x) {
            float n;
            float t;
            int y2;
            float a = 0.0f;
            for (y2 = 0; y2 < imageSize; ++y2) {
                t = alpha[x][y2];
                n = a - fallOff;
                if (t < a) {
                    alpha[x][y2] = a;
                } else if (n < t) {
                    n = t;
                }
                a = n;
            }
            a = 0.0f;
            for (y2 = imageSize - 1; y2 >= 0; --y2) {
                t = alpha[x][y2];
                n = a - fallOff;
                if (t < a) {
                    alpha[x][y2] = a;
                } else if (n < t) {
                    n = t;
                }
                a = n;
            }
        }
        g.drawImage(map, 1, 0, null);
        g.drawImage(map, 1, 1, null);
        g.drawImage(map, 0, 1, null);
        index = 0;
        for (y = 0; y < imageSize; ++y) {
            for (int x = 0; x < imageSize; ++x) {
                if (types[x][y] != 0) {
                    float f = 0.0f;
                    int v = pixels[index];
                    if (types[x][y] == 1) {
                        f = alpha[x][y];
                        if ((v & 0xFF) > 0) {
                            f *= 0.75f;
                            if ((f = f * f * f) > 0.25f) {
                                f = 0.25f;
                            }
                        } else {
                            f = (float)(v >> 24 & 0xFF) / 255.0f;
                            if (f < 0.3f) {
                                f = 0.3f;
                            }
                            v |= 0x20;
                        }
                    } else {
                        f = alpha[x][y];
                        if ((f = f * f * f * f * f) > 0.5f) {
                            f = 0.5f;
                        }
                    }
                    int a = (int)(255.0f * f);
                    pixels[index] = v = v & 0xFFFFFF | a << 24;
                }
                ++index;
            }
        }
        long end = System.nanoTime();
        System.out.println("Image produced in " + (double)(end - start) / 1000000.0 + " ms");
        g.drawImage(map, 0, 0, null);
        g.dispose();
        return background;
    }

    private static void xAlphaSpan(float[][] alpha, int last, int current, int y, int imageSize) {
        if (last < 0) {
            for (float a = 1.0f; a > 0.0f && current > 0; a -= fallOff) {
                alpha[--current][y] = a;
            }
            return;
        }
        if (current < 0) {
            for (float a = 1.0f; a > 0.0f && last < imageSize - 1; a -= fallOff) {
                alpha[++last][y] = a;
            }
            return;
        }
        if (last - 1 == current) {
            return;
        }
        for (float a = 1.0f; a > 0.0f; a -= fallOff) {
            if (current > 0) {
                alpha[--current][y] = a;
            }
            if (last < imageSize - 1) {
                alpha[++last][y] = a;
            }
            if (current > last) continue;
            return;
        }
    }

    private static int mix(int a1, int a2, float mix) {
        float f = (float)a1 * (1.0f - mix) + (float)a2 * mix;
        return (int)f;
    }
}

