/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.property;

import mythruna.client.tabs.property.Table;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.InContainer;
import mythruna.es.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BadgeTable
implements Table<Entity> {
    private String[] columnNames = new String[]{"Badge Holder"};
    private EntityId player;
    private EntityData ed;
    private EntitySet badges;
    private Entity[] rows;
    private long version;

    public BadgeTable(EntityId player, EntityData ed, EntitySet badges) {
        this.ed = ed;
        this.player = player;
        this.badges = badges;
        this.update();
    }

    @Override
    public Entity getRow(int row) {
        if (this.rows == null) {
            return null;
        }
        return this.rows[row];
    }

    protected boolean needsUpdate() {
        if (this.rows == null) {
            return true;
        }
        if (!this.badges.getAddedEntities().isEmpty()) {
            return true;
        }
        return !this.badges.getRemovedEntities().isEmpty();
    }

    @Override
    public long getChangeVersion() {
        return this.version;
    }

    @Override
    public void update() {
        if (this.needsUpdate()) {
            this.updateRows();
            ++this.version;
        } else if (!this.badges.getChangedEntities().isEmpty()) {
            ++this.version;
        }
    }

    protected void updateRows() {
        this.rows = new Entity[this.badges.size()];
        this.rows = this.badges.toArray(this.rows);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getSize() {
        return this.rows.length;
    }

    @Override
    public String getHeading(int col) {
        return this.columnNames[col];
    }

    protected String safeName(Name name) {
        return name == null ? "Unknown" : name.getName();
    }

    @Override
    public String getValue(int row, int col) {
        if (this.rows == null) {
            this.updateRows();
        }
        Entity e = this.rows[row];
        switch (col) {
            case 0: {
                InContainer in = e.get(InContainer.class);
                if (in.getParentId().equals(this.player)) {
                    return "You";
                }
                return this.safeName(this.ed.getComponent(in.getParentId(), Name.class));
            }
        }
        return "";
    }
}

