/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.tabs.property;

import com.jme3.app.Application;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import mythruna.client.GameClient;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.Label;
import mythruna.es.Entity;
import org.progeeks.util.log.Log;

public class PropertyMapView
extends Node {
    static Log log = Log.getLog();
    private static final ColorRGBA titleColor = new ColorRGBA(0.35686275f, 0.07450981f, 0.07450981f, 1.0f);
    private static final ColorRGBA shadowColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private GameClient gameClient;
    private Application app;
    private BitmapFont writingFont;
    private Entity property;
    private float width = 200.0f;
    private float height = 200.0f;

    public PropertyMapView(GameClient gameClient, Application app) {
        this.gameClient = gameClient;
        this.app = app;
        this.writingFont = app.getAssetManager().loadFont("Interface/templar32.fnt");
        this.createMapView();
    }

    public void setProperty(Entity property) {
        if (this.property == property) {
            return;
        }
        this.property = property;
    }

    protected void createMapView() {
        Quad quad = new Quad(this.width, this.height);
        Geometry geom = new Geometry("MapView", (Mesh)quad);
        Material m = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        m.setColor("Color", ColorRGBA.Green);
        geom.setMaterial(m);
        geom.setLocalTranslation(0.0f, 70.0f, -1.0f);
        this.attachChild((Spatial)geom);
        Label l = new Label(this.writingFont);
        l.setText("Coming Soon");
        l.setColor(titleColor);
        l.setShadowColor(shadowColor);
        l.setHAlignment(HAlignment.CENTER);
        l.setLocalTranslation(this.width * 0.5f, this.height * 0.5f + 24.0f, 0.1f);
        this.attachChild((Spatial)l);
    }
}

