/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.scene.Spatial;
import mythruna.client.ui.ClickAction;
import mythruna.client.ui.Command;
import mythruna.client.ui.CommandList;
import mythruna.client.ui.MouseListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClickListener
implements MouseListener {
    private CommandList<ClickAction> commands = new CommandList();
    private int xClick;
    private int yClick;
    private long lastClickTime = -1L;
    private long doubleClickTime = 500L;

    public ClickListener(Command<ClickAction> ... list) {
        if (list != null) {
            this.commands.addCommands(list);
        }
    }

    public void addCommands(Command<ClickAction> ... list) {
        if (list != null) {
            this.commands.addCommands(list);
        }
    }

    protected void execute(Object source, ClickAction action) {
        this.commands.execute(source, action);
    }

    @Override
    public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
        event.setConsumed();
        if (event.isPressed()) {
            return;
        }
        if (event.getButtonIndex() == 0) {
            long time = System.currentTimeMillis();
            if (time - this.lastClickTime < this.doubleClickTime) {
                int x = this.xClick - event.getX();
                int y = this.yClick - event.getY();
                System.out.println("Distance:" + (x * x + y * y));
                if (x * x + y * y < 9) {
                    this.execute(capture, ClickAction.Enter);
                    this.lastClickTime = time - this.doubleClickTime;
                    return;
                }
            }
            this.xClick = event.getX();
            this.yClick = event.getY();
            this.execute(capture, ClickAction.Select);
            this.lastClickTime = time;
        } else if (event.getButtonIndex() == 1) {
            this.execute(capture, ClickAction.OpenMenu);
        }
    }

    @Override
    public void mouseEntered(MouseMotionEvent event, Spatial capture) {
        event.setConsumed();
    }

    @Override
    public void mouseExited(MouseMotionEvent event, Spatial capture) {
    }

    @Override
    public void mouseMoved(MouseMotionEvent event, Spatial capture) {
        event.setConsumed();
    }
}

