/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mythruna.client.anim.AnimationState;
import mythruna.client.anim.AnimationTask;
import mythruna.client.ui.GuiViewPortState;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.ViewPortState;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiAppState
extends ObservableState {
    static Log log = Log.getLog();
    private Node orthoRoot;
    private ViewPortState view;
    private GuiViewPortState overlay;
    private MouseObserver mouseObserver = new MouseObserver();
    private Spatial hitTarget = null;
    private Spatial capture = null;
    private List<ObservableState> dependentStates = new ArrayList<ObservableState>();

    public GuiAppState(Node orthoRoot) {
        super("GUI", false);
        this.orthoRoot = orthoRoot;
    }

    public Node getPerspectiveRoot() {
        return this.view.getRoot();
    }

    public Node getOrthoRoot() {
        return this.orthoRoot;
    }

    public Node getOverlayRoot() {
        return this.overlay.getRoot();
    }

    public Camera getCamera() {
        return this.view.getCamera();
    }

    @Override
    public void setEnabled(boolean f) {
        log.warn((Object)("GuiAppState.setEnabled(" + f + ") called directly instead of adding a dependent."), new Throwable("Call Stack"));
        super.setEnabled(f);
    }

    public void addDependent(ObservableState state) {
        System.out.println("GuiAppState.addDependent(" + (Object)((Object)state) + ")");
        this.dependentStates.add(state);
        super.setEnabled(!this.dependentStates.isEmpty());
    }

    public void removeDependent(ObservableState state) {
        System.out.println("GuiAppState.removeDependent(" + (Object)((Object)state) + ")");
        this.dependentStates.remove((Object)state);
        super.setEnabled(!this.dependentStates.isEmpty());
    }

    public List<AnimationTask> removeDependent(ObservableState state, float delay) {
        return this.getState(AnimationState.class).add(new RemoveDependentState(state, delay));
    }

    @Override
    protected void initialize(Application app) {
        super.initialize(app);
        this.view = new ViewPortState("3D GUI");
        this.getStateManager().attach((AppState)this.view);
        this.overlay = new GuiViewPortState("Overlay");
        this.getStateManager().attach((AppState)this.overlay);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(0.5f, -1.0f, -1.0f).normalizeLocal());
        this.orthoRoot.addLight((Light)light);
    }

    @Override
    protected void enable() {
        super.enable();
        System.out.println("-------------------------3D view is enabled");
        this.view.setEnabled(true);
        this.overlay.setEnabled(true);
        this.getApplication().getInputManager().addRawInputListener((RawInputListener)this.mouseObserver);
    }

    @Override
    protected void disable() {
        super.disable();
        this.releaseCapture();
        this.getApplication().getInputManager().removeRawInputListener((RawInputListener)this.mouseObserver);
        this.view.setEnabled(false);
        this.overlay.setEnabled(false);
        System.out.println("-------------------------3D view is disabled");
    }

    public void render(RenderManager rm) {
        super.render(rm);
    }

    public Vector3f screenToWorld(float x, float y, float distance) {
        Ray upperLeft = this.getScreenRay(new Vector2f(x, y));
        Vector3f pos = upperLeft.getOrigin().add(upperLeft.getDirection().mult(distance));
        return pos;
    }

    protected Ray getScreenRay(Vector2f cursor) {
        Camera cam = this.view.getCamera();
        Vector3f clickFar = cam.getWorldCoordinates(cursor, 1.0f);
        Vector3f clickNear = cam.getWorldCoordinates(cursor, 0.0f);
        Ray mouseRay = new Ray(clickNear, clickFar.subtractLocal(clickNear).normalizeLocal());
        return mouseRay;
    }

    protected Spatial findHitTarget(Spatial s) {
        if (s == null) {
            return null;
        }
        MouseEventControl control = (MouseEventControl)s.getControl(MouseEventControl.class);
        if (control != null && control.isEnabled()) {
            return s;
        }
        return this.findHitTarget((Spatial)s.getParent());
    }

    protected void setCurrentHitTarget(Spatial s, Vector2f cursor) {
        if (this.hitTarget == s) {
            return;
        }
        MouseMotionEvent event = null;
        if (this.hitTarget != null) {
            event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
            ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseExited(event, this.capture);
        }
        this.hitTarget = s;
        if (this.hitTarget != null) {
            if (event == null) {
                event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
            }
            ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseEntered(event, this.capture);
        }
    }

    protected void releaseCapture() {
        MouseButtonEvent event;
        if (this.capture != null) {
            event = new MouseButtonEvent(0, false, -1000, -1000);
            ((MouseEventControl)this.capture.getControl(MouseEventControl.class)).mouseButtonEvent(event, this.capture);
        }
        if (this.hitTarget != null) {
            event = new MouseMotionEvent(-1000, -1000, 0, 0, 0, 0);
            ((MouseEventControl)this.hitTarget.getControl(MouseEventControl.class)).mouseExited((MouseMotionEvent)event, this.capture);
        }
        this.capture = null;
        this.hitTarget = null;
    }

    public void update(float tpf) {
        CollisionResult cr;
        Geometry geom;
        Iterator i$;
        int count;
        CollisionResults results;
        Ray mouseRay;
        super.update(tpf);
        if (this.view.getCamera() == null) {
            return;
        }
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        Spatial hit = null;
        if (hit == null) {
            mouseRay = new Ray(new Vector3f(cursor.x, cursor.y, 1000.0f), new Vector3f(0.0f, 0.0f, -1.0f));
            results = new CollisionResults();
            count = this.getOverlayRoot().collideWith((Collidable)mouseRay, results);
            if (count > 0) {
                i$ = results.iterator();
                while (i$.hasNext() && (hit = this.findHitTarget((Spatial)(geom = (cr = (CollisionResult)i$.next()).getGeometry()))) == null) {
                }
            }
        }
        if (hit == null) {
            mouseRay = this.getScreenRay(cursor);
            results = new CollisionResults();
            count = this.getPerspectiveRoot().collideWith((Collidable)mouseRay, results);
            if (count > 0 && (i$ = results.iterator()).hasNext()) {
                cr = (CollisionResult)i$.next();
                geom = cr.getGeometry();
                hit = this.findHitTarget((Spatial)geom);
            }
        }
        if (hit == null && (count = this.orthoRoot.collideWith((Collidable)(mouseRay = new Ray(new Vector3f(cursor.x, cursor.y, 1000.0f), new Vector3f(0.0f, 0.0f, -1.0f))), results = new CollisionResults())) > 0) {
            i$ = results.iterator();
            while (i$.hasNext() && (hit = this.findHitTarget((Spatial)(geom = (cr = (CollisionResult)i$.next()).getGeometry()))) == null) {
            }
        }
        this.setCurrentHitTarget(hit, cursor);
        if (hit != null) {
            MouseMotionEvent event = new MouseMotionEvent((int)cursor.x, (int)cursor.y, 0, 0, 0, 0);
            ((MouseEventControl)hit.getControl(MouseEventControl.class)).mouseMoved(event, this.capture);
        }
    }

    private class RemoveDependentState
    implements AnimationTask {
        private ObservableState state;
        private float totalTime;
        private float time;

        public RemoveDependentState(ObservableState state, float totalTime) {
            this.state = state;
            this.totalTime = totalTime;
        }

        public boolean animate(AnimationState anim, float seconds) {
            if (this.time >= this.totalTime) {
                GuiAppState.this.removeDependent(this.state);
                return false;
            }
            this.time += seconds;
            return true;
        }
    }

    private class MouseObserver
    implements RawInputListener {
        private MouseObserver() {
        }

        public void beginInput() {
        }

        public void endInput() {
        }

        public void onJoyAxisEvent(JoyAxisEvent evt) {
        }

        public void onJoyButtonEvent(JoyButtonEvent evt) {
        }

        public void onMouseMotionEvent(MouseMotionEvent event) {
        }

        public void onMouseButtonEvent(MouseButtonEvent event) {
            if (event.isPressed()) {
                GuiAppState.this.capture = GuiAppState.this.hitTarget;
            } else if (GuiAppState.this.capture != null) {
                ((MouseEventControl)GuiAppState.this.capture.getControl(MouseEventControl.class)).mouseButtonEvent(event, GuiAppState.this.capture);
                GuiAppState.this.capture = null;
                if (event.isConsumed()) {
                    return;
                }
            }
            if (GuiAppState.this.hitTarget == null) {
                return;
            }
            ((MouseEventControl)GuiAppState.this.hitTarget.getControl(MouseEventControl.class)).mouseButtonEvent(event, GuiAppState.this.capture);
        }

        public void onKeyEvent(KeyInputEvent evt) {
        }

        public void onTouchEvent(TouchEvent evt) {
        }
    }
}

