/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import mythruna.MaterialIndex;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.VAlignment;
import org.progeeks.util.ObjectUtils;

public class Label
extends Node {
    private String text;
    private BitmapFont font;
    private BitmapText textBitmap;
    private BitmapText shadowBitmap;
    private Quad bgBox;
    private Geometry bgGeom;
    private ColorRGBA color;
    private ColorRGBA shadowColor;
    private ColorRGBA bgColor;
    private HAlignment alignment = HAlignment.LEFT;
    private VAlignment vAlignment = VAlignment.BOTTOM;
    private Vector3f shadowOffset = new Vector3f(1.0f, -1.0f, -0.1f);

    public Label() {
    }

    public Label(Application app) {
        this(app.getAssetManager().loadFont("Interface/knights32.fnt"));
    }

    public Label(BitmapFont font) {
        this.setFont(font);
    }

    public void setHAlignment(HAlignment alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.resetAlignment();
    }

    public HAlignment getHAlignment() {
        return this.alignment;
    }

    public float getHeight() {
        return this.textBitmap.getHeight() * this.getLocalScale().y;
    }

    public float getWidth() {
        return this.textBitmap.getLineWidth() * this.getLocalScale().x;
    }

    public Vector3f[] getLabelBounds() {
        Vector3f min = this.textBitmap.getWorldTranslation().clone();
        Vector3f max = min.clone();
        max.addLocal(this.getWidth(), -this.getHeight(), this.shadowOffset.z);
        return new Vector3f[]{min, max};
    }

    public void setVAlignment(VAlignment alignment) {
        if (this.vAlignment == alignment) {
            return;
        }
        this.vAlignment = alignment;
        this.resetAlignment();
    }

    public VAlignment getVAlignment() {
        return this.vAlignment;
    }

    protected void resetAlignment() {
        if (this.textBitmap == null) {
            return;
        }
        this.textBitmap.setBox(null);
        float xOffset = this.textBitmap.getLineWidth();
        float yOffset = this.textBitmap.getHeight();
        float quadOffset = this.textBitmap.getHeight();
        Rectangle rect = new Rectangle(0.0f, 0.0f, xOffset, yOffset);
        this.textBitmap.setBox(rect);
        this.shadowBitmap.setBox(rect);
        switch (this.alignment) {
            case LEFT: {
                xOffset = 0.0f;
                this.textBitmap.setAlignment(BitmapFont.Align.Left);
                this.shadowBitmap.setAlignment(BitmapFont.Align.Left);
                break;
            }
            case RIGHT: {
                this.textBitmap.setAlignment(BitmapFont.Align.Right);
                this.shadowBitmap.setAlignment(BitmapFont.Align.Right);
                break;
            }
            case CENTER: {
                xOffset *= 0.5f;
                this.textBitmap.setAlignment(BitmapFont.Align.Center);
                this.shadowBitmap.setAlignment(BitmapFont.Align.Center);
            }
        }
        switch (this.vAlignment) {
            case TOP: {
                yOffset = 0.0f;
                break;
            }
            case BOTTOM: {
                quadOffset = 0.0f;
                break;
            }
            case CENTER: {
                yOffset *= 0.5f;
                quadOffset *= 0.5f;
            }
        }
        this.textBitmap.setLocalTranslation(-xOffset, yOffset, 0.0f);
        this.shadowBitmap.setLocalTranslation(this.shadowOffset.x - xOffset, this.shadowOffset.y + yOffset, this.shadowOffset.z);
        if (rect.width != this.bgBox.getWidth() || rect.height != this.bgBox.getHeight()) {
            this.bgBox = new Quad(rect.width, rect.height);
            this.bgGeom.setMesh((Mesh)this.bgBox);
        }
        this.bgGeom.setLocalTranslation(-xOffset, -quadOffset, -0.6f);
    }

    protected void resetText() {
        if (this.textBitmap == null) {
            return;
        }
        this.textBitmap.setText(this.text);
        this.shadowBitmap.setText(this.text);
        this.resetAlignment();
        if (this.text == null) {
            this.setCullHint(Spatial.CullHint.Always);
        } else {
            this.setCullHint(Spatial.CullHint.Inherit);
        }
    }

    protected void resetColor() {
        if (this.textBitmap == null) {
            return;
        }
        this.textBitmap.setColor(this.getColor());
        this.shadowBitmap.setColor(this.getShadowColor());
    }

    public void setFont(BitmapFont font) {
        if (ObjectUtils.areEqual((Object)this.font, (Object)font)) {
            return;
        }
        this.font = font;
        if (this.textBitmap != null) {
            this.detachChild((Spatial)this.textBitmap);
        }
        if (this.shadowBitmap != null) {
            this.detachChild((Spatial)this.shadowBitmap);
        }
        this.textBitmap = new BitmapText(font);
        this.shadowBitmap = new BitmapText(font);
        this.shadowBitmap.setLocalTranslation(this.shadowOffset);
        this.bgBox = new Quad(120.0f, 120.0f);
        this.bgGeom = new Geometry("Label BG", (Mesh)this.bgBox);
        this.bgGeom.setMaterial(MaterialIndex.TRANSPARENT_MATERIAL.clone());
        if (this.bgColor != null) {
            this.bgGeom.getMaterial().setColor("Color", this.bgColor);
        }
        this.resetText();
        this.resetColor();
        this.attachChild((Spatial)this.shadowBitmap);
        this.attachChild((Spatial)this.textBitmap);
        this.attachChild((Spatial)this.bgGeom);
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public void setText(String text) {
        if (ObjectUtils.areEqual((Object)this.text, (Object)text)) {
            return;
        }
        this.text = text;
        this.resetText();
    }

    public String getText() {
        return this.text;
    }

    public void setBackground(ColorRGBA c) {
        if (c == null) {
            c = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f);
        }
        this.bgColor = c;
        if (this.bgGeom != null) {
            this.bgGeom.getMaterial().setColor("Color", this.bgColor);
        }
    }

    public ColorRGBA getBackground() {
        return this.bgColor;
    }

    public void setColor(ColorRGBA color) {
        this.setColor(color, false);
    }

    public void setColor(ColorRGBA color, boolean resetShadow) {
        if (ObjectUtils.areEqual((Object)this.color, (Object)color)) {
            return;
        }
        this.color = color;
        this.shadowColor = null;
        this.resetColor();
    }

    public ColorRGBA getColor() {
        return this.color == null ? ColorRGBA.White : this.color;
    }

    public void setShadowColor(ColorRGBA color) {
        if (ObjectUtils.areEqual((Object)this.shadowColor, (Object)color)) {
            return;
        }
        this.shadowColor = color;
        this.resetColor();
    }

    public ColorRGBA getShadowColor() {
        if (this.shadowColor == null) {
            this.shadowColor = new ColorRGBA();
            this.shadowColor.interpolate(this.getColor(), ColorRGBA.Black, 0.8f);
        }
        return this.shadowColor;
    }

    public String toString() {
        return "Label[" + this.text + "]";
    }
}

