/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.client.ui.AppStateListener;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableState
extends AbstractAppState {
    private static Log log = Log.getLog();
    private String name;
    private AppStateManager stateManager;
    private Application app;
    private List<AppStateListener> listeners = new CopyOnWriteArrayList<AppStateListener>();
    private boolean properlyInitialized = false;

    public ObservableState(String name, boolean enabled) {
        super.setEnabled(enabled);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.stateManager = stateManager;
        this.app = app;
        this.initialize(app);
        if (!this.properlyInitialized) {
            log.warn((Object)("Warning: Some subclass broke the super.initialize(app) chain:" + ((Object)((Object)this)).getClass().getName()));
        }
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void stateDetached(AppStateManager stateManager) {
        if (this.isEnabled()) {
            this.disable();
        }
        super.stateDetached(stateManager);
        this.stateManager = null;
        this.properlyInitialized = false;
    }

    protected Application getApplication() {
        return this.app;
    }

    protected AppStateManager getStateManager() {
        return this.stateManager;
    }

    protected <T extends AppState> T getState(Class<T> type) {
        return (T)this.stateManager.getState(type);
    }

    public void addStateListener(AppStateListener l) {
        this.listeners.add(l);
    }

    public void removeStateListener(AppStateListener l) {
        this.listeners.remove(l);
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObservableState.setEnabled(" + enabled + ")  stateManager:" + this.getStateManager()));
        }
        super.setEnabled(enabled);
        for (AppStateListener l : this.listeners) {
            l.stateEnabled(this, enabled);
        }
        if (enabled && this.getStateManager() != null) {
            this.enable();
        } else if (!enabled && this.getStateManager() != null) {
            this.disable();
        }
    }

    protected void initialize(Application app) {
        this.properlyInitialized = true;
    }

    protected void enable() {
    }

    protected void disable() {
    }
}

