/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import mythruna.client.GameAppState;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.ui.ActionCommand;
import mythruna.client.ui.Button;
import mythruna.client.ui.Command;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.HAlignment;
import mythruna.client.ui.InputRedirector;
import mythruna.client.ui.Label;
import mythruna.client.ui.MouseEventControl;
import mythruna.client.ui.MouseListener;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.VAlignment;
import mythruna.geom.Trifold;

public class PopupMessageState
extends ObservableState {
    public static final ActionCommand OK_COMMAND = new ActionCommand("Ok");
    private String message;
    private ActionCommand[] actions;
    private InputObserver inputObserver = new InputObserver();
    private Node dialog;
    private Geometry background;
    private float width;
    private float height;

    public PopupMessageState(String message, ActionCommand ... actions) {
        super(message, true);
        this.message = message;
        this.actions = actions;
        if (actions == null || actions.length == 0) {
            this.actions = new ActionCommand[]{OK_COMMAND};
        }
    }

    protected void initialize(Application app) {
        float z = 10.0f;
        this.dialog = new Node("Message Dialog");
        Camera cam = app.getCamera();
        Quad fadeMesh = new Quad((float)cam.getWidth(), (float)cam.getHeight());
        this.background = new Geometry("Fade", (Mesh)fadeMesh);
        Material mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        this.background.setMaterial(mat);
        this.background.setLocalTranslation(0.0f, 0.0f, z);
        this.background.addControl((Control)new MouseEventControl());
        ((MouseEventControl)this.background.getControl(MouseEventControl.class)).addMouseListener(new MouseObserver());
        z += 2.0f;
        float padding = 50.0f;
        Vector3f base = new Vector3f();
        float w = 0.0f;
        float h = 0.0f;
        Label messageLabel = new Label(app);
        messageLabel.setText(this.message);
        messageLabel.setColor(new ColorRGBA(0.24313726f, 0.36078432f, 0.5568628f, 1.0f));
        messageLabel.setHAlignment(HAlignment.CENTER);
        messageLabel.setVAlignment(VAlignment.TOP);
        messageLabel.setLocalTranslation(0.0f, 0.0f, z);
        this.dialog.attachChild((Spatial)messageLabel);
        Vector3f[] bounds = messageLabel.getLabelBounds();
        base.set(bounds[0].x, bounds[1].y, z);
        w = Math.abs(bounds[1].x - bounds[0].x);
        h = Math.abs(bounds[1].y - bounds[0].y);
        float labelHeight = h += padding * 2.0f;
        base.x = -(w += padding * 2.0f) * 0.5f;
        base.y = -(h - padding);
        Node buttons = new Node("Buttons");
        float x = 0.0f;
        for (ActionCommand cmd : this.actions) {
            if (x != 0.0f) {
                x += 5.0f;
            }
            Button b = new Button(app, 150.0f, 34.0f);
            b.setText(cmd.getName());
            b.setLocalTranslation(x, 0.0f, 0.0f);
            b.addCommand(new ButtonCommand(cmd));
            x += 150.0f;
            buttons.attachChild((Spatial)b);
        }
        h += 39.0f;
        base.y -= 39.0f;
        buttons.setLocalTranslation(-x * 0.5f, base.y, z + 2.0f);
        this.dialog.attachChild((Spatial)buttons);
        base.y -= 15.0f;
        h += 15.0f;
        System.out.println("w:" + w + "   x:" + (x += 30.0f));
        if (w < x) {
            float delta = x - w;
            w = x;
            base.x -= delta * 0.5f;
        }
        Trifold bgMesh = new Trifold(w, h);
        Geometry geom = new Geometry("Background", (Mesh)bgMesh);
        Material bgMaterial = new Material(app.getAssetManager(), "MatDefs/Composed.j3md");
        bgMaterial.setTexture("Map", app.getAssetManager().loadTexture("Interface/gradient.jpg"));
        Texture sand = app.getAssetManager().loadTexture("Textures/sand.jpg");
        sand.setWrap(Texture.WrapMode.Repeat);
        bgMaterial.setTexture("Mix", sand);
        bgMaterial.setVector3("MixParms", new Vector3f(0.01f, 0.01f, 1.0f));
        geom.setMaterial(bgMaterial);
        geom.setLocalTranslation(base.x, base.y, z - 1.0f);
        this.dialog.attachChild((Spatial)geom);
        this.height = h;
        this.width = w;
        Trifold borderMesh = new Trifold(128.0f, 128.0f);
        borderMesh.setFoldTextureCoordinates(new Vector2f(0.09375f, 0.09375f), new Vector2f(0.90625f, 0.90625f));
        borderMesh.setFoldCoordinates(new Vector2f(12.0f, 12.0f), new Vector2f(116.0f, 116.0f));
        borderMesh.setSize(this.width, this.height);
        borderMesh.updateGeometry();
        Material borderMaterial = new Material(app.getAssetManager(), "MatDefs/Composed.j3md");
        borderMaterial.setTexture("Map", app.getAssetManager().loadTexture("Interface/border.png"));
        Texture leather = app.getAssetManager().loadTexture("Interface/leather.jpg");
        leather.setWrap(Texture.WrapMode.Repeat);
        borderMaterial.setTexture("Mix", leather);
        borderMaterial.setVector3("MixParms", new Vector3f(0.00390625f, 0.00390625f, 1.0f));
        borderMaterial.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Geometry border = new Geometry("Palette Border", (Mesh)borderMesh);
        border.setMaterial(borderMaterial);
        border.setLocalTranslation(base.x, base.y, z);
        this.dialog.attachChild((Spatial)border);
    }

    protected void enable() {
        super.enable();
        this.getState(GameAppState.class).setEnableTextEntry(false);
        this.getState(GuiAppState.class).addDependent(this);
        Node gui = this.getState(GuiAppState.class).getOverlayRoot();
        InputRedirector.getInstance().addFirstRawInputListener(this.inputObserver);
        Camera cam = this.getApplication().getCamera();
        float scale = (float)cam.getWidth() / 1280.0f;
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        this.dialog.setLocalScale(0.01f);
        this.dialog.setLocalTranslation((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f + this.height * 0.5f, 10.0f);
        gui.attachChild((Spatial)this.background);
        gui.attachChild((Spatial)this.dialog);
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.dialog, 0.01f, scale, 0.25f));
    }

    protected void disable() {
        super.disable();
        this.getState(GameAppState.class).setEnableTextEntry(true);
        Node gui = this.getState(GuiAppState.class).getOverlayRoot();
        this.getState(GuiAppState.class).removeDependent(this);
        gui.detachChild((Spatial)this.dialog);
        gui.detachChild((Spatial)this.background);
        InputRedirector.getInstance().removeRawInputListener(this.inputObserver);
    }

    private class InputObserver
    implements RawInputListener {
        private InputObserver() {
        }

        public void beginInput() {
        }

        public void endInput() {
        }

        public void onJoyAxisEvent(JoyAxisEvent evt) {
        }

        public void onJoyButtonEvent(JoyButtonEvent evt) {
        }

        public void onKeyEvent(KeyInputEvent evt) {
            evt.setConsumed();
        }

        public void onMouseButtonEvent(MouseButtonEvent evt) {
        }

        public void onMouseMotionEvent(MouseMotionEvent evt) {
        }

        public void onTouchEvent(TouchEvent evt) {
        }
    }

    private class MouseObserver
    implements MouseListener {
        private MouseObserver() {
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial capture) {
            event.setConsumed();
        }

        public void mouseEntered(MouseMotionEvent event, Spatial capture) {
            event.setConsumed();
        }

        public void mouseExited(MouseMotionEvent event, Spatial capture) {
            event.setConsumed();
        }

        public void mouseMoved(MouseMotionEvent event, Spatial capture) {
            event.setConsumed();
        }
    }

    private class ButtonCommand
    implements Command {
        private ActionCommand cmd;

        public ButtonCommand(ActionCommand cmd) {
            this.cmd = cmd;
        }

        public void execute(Object source, Object action) {
            PopupMessageState.this.getStateManager().detach((AppState)PopupMessageState.this);
            if (this.cmd != null) {
                this.cmd.execute(source, action);
            }
        }
    }
}

