/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.client.ui.AppStateListener;
import mythruna.client.ui.ObservableState;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateGroup
extends ObservableState {
    static Log log = Log.getLog();
    private List<ObservableState> states = new CopyOnWriteArrayList<ObservableState>();
    private ChildObserver childObserver = new ChildObserver();
    private ObservableState defaultState = null;
    private ObservableState lastState = null;
    private boolean ignoreEvents = false;

    public StateGroup(String name, boolean enabled) {
        super(name, enabled);
    }

    public ObservableState getCurrentState() {
        return this.lastState;
    }

    @Override
    protected void initialize(Application app) {
        super.initialize(app);
        log.trace((Object)"StateGroup.initialize()***************************");
        for (ObservableState s : this.states) {
            if (!this.isEnabled()) {
                s.setEnabled(false);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("attaching:" + (Object)((Object)s)));
            }
            this.getStateManager().attach((AppState)s);
        }
    }

    @Override
    protected void enable() {
        super.enable();
        log.trace((Object)"StateGroup.enable()");
        this.resetDefaultState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disable() {
        super.disable();
        log.trace((Object)"StateGroup.disable()");
        this.ignoreEvents = true;
        try {
            for (ObservableState as : this.states) {
                as.setEnabled(false);
            }
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    public void setDefaultState(ObservableState state) {
        if (state != null && this.states.indexOf((Object)state) < 0) {
            this.addStates(state);
        }
        this.defaultState = state;
    }

    public void addStates(ObservableState ... array) {
        for (ObservableState as : array) {
            this.states.add(as);
            as.addStateListener(this.childObserver);
        }
    }

    public void removeStates(ObservableState ... array) {
        for (ObservableState as : array) {
            as.removeStateListener(this.childObserver);
            this.states.remove((Object)as);
        }
    }

    public List<ObservableState> getStates() {
        return this.states;
    }

    protected ObservableState getStartingState() {
        if (this.defaultState != null) {
            return this.defaultState;
        }
        if (this.lastState != null) {
            return this.lastState;
        }
        if (!this.states.isEmpty()) {
            return this.states.get(0);
        }
        return null;
    }

    protected void resetDefaultState() {
        ObservableState state = this.getStartingState();
        if (state != null) {
            this.resetModalState(state);
        }
    }

    protected void isFocused(ObservableState state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetModalState(ObservableState state) {
        this.ignoreEvents = true;
        try {
            this.lastState = state;
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            for (ObservableState as : this.states) {
                if (as == state) continue;
                as.setEnabled(false);
            }
            state.setEnabled(true);
            this.isFocused(state);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private class ChildObserver
    implements AppStateListener {
        private ChildObserver() {
        }

        public void stateEnabled(ObservableState state, boolean enabled) {
            if (StateGroup.this.ignoreEvents) {
                return;
            }
            if (!enabled) {
                StateGroup.this.setEnabled(false);
            } else {
                StateGroup.this.resetModalState(state);
            }
        }
    }
}

