/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import mythruna.client.ui.ObservableState;

public class ViewPortState
extends ObservableState {
    private Camera cam;
    private ViewPort view;
    private Node root;

    public ViewPortState(String name) {
        super(name, false);
    }

    public Node getRoot() {
        return this.root;
    }

    public Camera getCamera() {
        return this.cam;
    }

    protected void initialize(Application app) {
        super.initialize(app);
        this.root = new Node(this.getName() + " Root");
        this.root.setCullHint(Spatial.CullHint.Never);
        Camera originalCam = app.getCamera();
        this.cam = new Camera(originalCam.getWidth(), originalCam.getHeight());
        float aspect = (float)originalCam.getWidth() / (float)originalCam.getHeight();
        this.cam.setFrustumPerspective(45.0f, aspect, 0.1f, originalCam.getFrustumFar());
        this.view = app.getRenderManager().createPostView(this.getName() + " ViewPort", this.cam);
        this.view.setEnabled(this.isEnabled());
        this.view.setClearFlags(false, true, false);
        this.view.attachScene((Spatial)this.root);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(1.0f, 0.2f, -1.5f).normalizeLocal());
        this.root.addLight((Light)light);
        this.root.updateLogicalState(1.0f);
        this.root.updateGeometricState();
    }

    protected void enable() {
        super.enable();
        if (this.view != null) {
            this.view.setEnabled(true);
        }
    }

    protected void disable() {
        super.disable();
        if (this.view != null) {
            this.view.setEnabled(false);
        }
    }

    public void render(RenderManager rm) {
        this.root.updateGeometricState();
        super.render(rm);
    }

    public void update(float tpf) {
        this.root.updateLogicalState(tpf);
    }
}

