/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mythruna.Coordinates;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityContainer<T>
extends AbstractControl {
    private EntityData ed;
    private int x;
    private int y;
    protected int xBase;
    protected int yBase;
    protected int zBase;
    private long columnId;
    protected EntitySet entities;
    private Map<EntityId, T> children = new HashMap<EntityId, T>();
    private Class[] types;

    protected AbstractEntityContainer(EntityData ed, int x, int y, Class ... types) {
        super.setEnabled(false);
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("Must specify types.");
        }
        this.ed = ed;
        this.x = x;
        this.y = y;
        this.columnId = Coordinates.leafToColumnId(x, y);
        this.types = types;
        this.xBase = Coordinates.leafToWorld(x);
        this.yBase = Coordinates.leafToWorld(y);
        this.zBase = 0;
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("This control cannot be cloned.");
    }

    protected void initialize() {
        FieldFilter<Position> filter = new FieldFilter<Position>(Position.class, "columnId", this.columnId);
        this.entities = this.getEntityData().getEntities(filter, this.types);
        this.addChildren(this.entities);
    }

    protected void terminate() {
        this.removeChildren(this.entities);
        this.entities.release();
        this.entities = null;
    }

    protected EntityData getEntityData() {
        return this.ed;
    }

    protected abstract T createSpatial(Entity var1);

    protected abstract Node adjustToLocal(Entity var1);

    protected abstract void removeChild(Entity var1, T var2);

    protected T getChild(Entity e, boolean create) {
        T result = this.children.get(e.getId());
        if (result == null && create) {
            result = this.createSpatial(e);
            this.children.put(e.getId(), result);
        }
        return result;
    }

    protected void addChildren(Set<Entity> set) {
        for (Entity e : set) {
            Node n = this.adjustToLocal(e);
            ((Node)this.spatial).attachChild((Spatial)n);
        }
    }

    protected void updateChildren(Set<Entity> set) {
        for (Entity e : set) {
            Node n = this.adjustToLocal(e);
        }
    }

    protected void removeChildren(Set<Entity> set) {
        for (Entity e : set) {
            T child = this.children.remove(e.getId());
            this.removeChild(e, child);
        }
    }

    public int getChildCount() {
        if (this.entities == null) {
            return 0;
        }
        return this.entities.size();
    }

    protected void updateAll() {
        if (this.entities != null) {
            this.updateChildren(this.entities);
        }
    }

    public void setEnabled(boolean b) {
        if (this.isEnabled() == b) {
            return;
        }
        super.setEnabled(b);
        if (b) {
            this.initialize();
        } else {
            this.terminate();
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    protected void controlUpdate(float tpf) {
        long start = System.nanoTime();
        boolean hasChanges = this.entities.applyChanges();
        long end = System.nanoTime();
        if (hasChanges) {
            if (end - start > 2000000L) {
                System.out.println(((Object)((Object)this)).getClass().getSimpleName() + " apply changes time:" + (double)(end - start) / 1000000.0 + " ms");
            }
            this.removeChildren(this.entities.getRemovedEntities());
            this.addChildren(this.entities.getAddedEntities());
            this.updateChildren(this.entities.getChangedEntities());
        }
    }
}

