/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.audio.AudioNode;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.ClientOptions;
import mythruna.client.GameClient;
import mythruna.client.PostProcessingState;
import mythruna.client.anim.Animation;
import mythruna.client.anim.AnimationState;
import mythruna.client.anim.AnimationTask;
import mythruna.client.ui.ActionCommand;
import mythruna.client.ui.Button;
import mythruna.client.ui.GuiAppState;
import mythruna.client.ui.ObservableState;
import mythruna.client.ui.StringEntryState;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.Name;
import mythruna.geom.Trifold;
import mythruna.script.ActionReference;
import mythruna.script.ActionType;
import mythruna.script.ComponentParameter;
import mythruna.script.RadialActions;
import org.progeeks.util.log.Log;

public class RadialMenuState
extends ObservableState {
    static Log log = Log.getLog();
    private GameClient gameClient;
    private EntityData ed;
    private AudioNode switchTabs;
    private AudioNode switchOff;
    private Node buttons;
    private float buttonScale = 1.0f;
    private ColorRGBA enabledColor = new ColorRGBA(0.20392157f, 0.44313726f, 0.8392157f, 1.0f);
    private EntitySet entities;
    private RadialActions actions;
    private List<AnimationTask> disableAnimations = new ArrayList<AnimationTask>();

    public RadialMenuState(GameClient gameClient) {
        super("Object Radial Menu", false);
        this.gameClient = gameClient;
        this.ed = gameClient.getEntityData();
        this.entities = this.ed.getEntities(new FieldFilter<RadialActions>(RadialActions.class, "player", gameClient.getPlayer()), RadialActions.class);
    }

    public void checkActive() {
        if (this.entities.applyChanges()) {
            if (this.buttons == null) {
                return;
            }
            if (!this.entities.getAddedEntities().isEmpty() || !this.entities.getChangedEntities().isEmpty()) {
                Entity e = this.entities.iterator().next();
                this.setRadialActions(e.get(RadialActions.class));
            } else if (!this.entities.getRemovedEntities().isEmpty()) {
                this.setRadialActions(null);
            } else {
                log.warn((Object)("Unknown state in radial actions entity set.  It says there are changes but there aren't:" + this.entities));
            }
        }
    }

    protected void setRadialActions(RadialActions actions) {
        System.out.println("setRadialActions(" + actions + ")");
        if (this.actions == actions) {
            return;
        }
        this.actions = actions;
        if (this.actions == null) {
            this.setEnabled(false);
        } else {
            this.updateActions();
            this.setEnabled(true);
        }
    }

    protected void updateActions() {
        Application app = this.getApplication();
        float radialScale = 1.0f;
        this.buttons.detachAllChildren();
        Vector3f buttonCenter = this.buttons.getWorldTranslation();
        String name = this.actions.getName();
        String title = this.actions.getTitle();
        EntityId target = this.actions.getTarget();
        ActionReference[] refs = this.actions.getActions();
        int slots = refs.length;
        if (slots % 2 == 0) {
            ++slots;
        }
        float delta = (float)Math.PI * 2 / (float)slots;
        float angle = 4.712389f;
        if (slots == refs.length) {
            angle += delta * 0.5f;
        }
        Texture2D radialLine = (Texture2D)app.getAssetManager().loadTexture("Interface/radial-line.png");
        boolean i = false;
        for (ActionReference ar : refs) {
            float x = FastMath.cos((float)(angle -= delta)) * 200.0f * radialScale;
            float y = FastMath.sin((float)angle) * 200.0f * radialScale;
            Button b = this.createButton(ar.getName(), x, y, 0.0f);
            b.addCommand(new NamedActionCommand(ar, target));
            this.buttons.attachChild((Spatial)b);
            Picture p = new Picture(ar.getName() + " radial");
            p.setWidth(150.0f);
            p.setHeight(150.0f);
            p.setTexture(app.getAssetManager(), radialLine, true);
            b.attachChild((Spatial)p);
            Quaternion rot = new Quaternion().fromAngles(0.0f, 0.0f, angle - 0.7853982f);
            p.setLocalRotation(rot);
            p.setLocalTranslation(b.worldToLocal(buttonCenter, null));
        }
        Button center = this.createCenterButton(name, 0.0f, 0.0f, 1.0f);
        center.setTextColor(new ColorRGBA(0.95686275f, 1.0f, 0.60784316f, 1.0f));
        center.addCommand(new CancelCommand());
        this.buttons.attachChild((Spatial)center);
        Camera cam = this.getApplication().getCamera();
        if (title != null) {
            Button banner = this.createTitle(title, 0.0f, -(200.0f + radialScale + 32.0f), 1.0f);
            banner.setTextOffset(new Vector3f(0.0f, 6.0f, 0.0f));
            banner.setFont("Interface/templar32.fnt");
            banner.setTextColor(new ColorRGBA(0.050980393f, 0.1254902f, 0.43529412f, 1.0f));
            banner.addCommand(new CancelCommand());
            this.buttons.attachChild((Spatial)banner);
        }
        this.switchOff = new AudioNode(app.getAudioRenderer(), app.getAssetManager(), "Sounds/switch-off-short.ogg", false);
        this.switchOff.setPositional(false);
    }

    protected void initialize(Application app) {
        super.initialize(app);
        Camera cam = app.getCamera();
        float radialScale = 1.0f;
        this.buttonScale = Math.min(1.0f, (float)cam.getWidth() / 1000.0f);
        this.buttons = new Node("RadialButtons");
        this.buttons.setLocalTranslation((float)cam.getWidth() * 0.5f, (float)cam.getHeight() * 0.5f, 0.0f);
        this.buttons.setLocalScale(this.buttonScale);
    }

    protected void enable() {
        super.enable();
        AnimationState anim = this.getState(AnimationState.class);
        anim.remove(this.disableAnimations);
        this.disableAnimations.clear();
        GuiAppState guiState = this.getState(GuiAppState.class);
        Camera cam = guiState.getCamera();
        float radialScale = (float)cam.getHeight() / 720.0f;
        ((PostProcessingState)this.getStateManager().getState(PostProcessingState.class)).setRadialFadeOn(3.0f * radialScale, 3.0f * radialScale);
        Node gui = guiState.getOrthoRoot();
        guiState.addDependent(this);
        gui.attachChild((Spatial)this.buttons);
        this.buttons.setLocalScale(0.01f);
        this.getState(AnimationState.class).add(Animation.scale((Spatial)this.buttons, 0.01f, this.buttonScale, 0.25f));
    }

    protected void disable() {
        super.disable();
        if (this.actions != null) {
            this.gameClient.execute("Close Radial", null, null);
        }
        ((PostProcessingState)this.getStateManager().getState(PostProcessingState.class)).setRadialFade(false);
        GuiAppState guiState = this.getState(GuiAppState.class);
        Node gui = this.getState(GuiAppState.class).getOrthoRoot();
        this.switchOff.setVolume(ClientOptions.getInstance().getSoundEffectsVolume() * 0.8f);
        this.switchOff.play();
        AnimationState anim = this.getState(AnimationState.class);
        this.disableAnimations.addAll(anim.add(Animation.detach((Spatial)this.buttons, 0.25f)));
        this.disableAnimations.addAll(anim.add(Animation.scale((Spatial)this.buttons, this.buttonScale, 0.01f, 0.25f)));
        this.disableAnimations.addAll(guiState.removeDependent(this, 0.25f));
    }

    public void render(RenderManager rm) {
        super.render(rm);
    }

    public void update(float tpf) {
    }

    protected Button createButton(String text, float x, float y, float z) {
        float triRadius = 75.0f;
        float triWidth = 150.0f;
        Trifold trifold = new Trifold(triWidth, triRadius * 2.0f);
        trifold.setFoldTextureCoordinates(new Vector2f(0.5f, 0.5f), new Vector2f(0.5f, 0.5f));
        trifold.setFoldCoordinates(new Vector2f(triRadius, triRadius), new Vector2f(triWidth - triRadius, triRadius));
        trifold.updateGeometry();
        Texture texture = this.getApplication().getAssetManager().loadTexture("Interface/bubble.png");
        Button button = new Button(this.getApplication(), trifold, texture);
        button.setText(text);
        button.setLocalTranslation(x - triWidth * 0.5f, y - triWidth * 0.5f, z);
        button.setTextColor(new ColorRGBA(0.4f, 0.6f, 0.6f, 1.0f));
        button.setTextShadowColor(new ColorRGBA(0.1f, 0.2f, 0.2f, 1.0f));
        button.setTextSelectedColor(ColorRGBA.Yellow);
        return button;
    }

    protected Button createCenterButton(String text, float x, float y, float z) {
        float triRadius = 17.0f;
        float triWidth = 150.0f;
        Trifold trifold = new Trifold(triWidth, triRadius * 2.0f);
        trifold.setFoldTextureCoordinates(new Vector2f(0.5f, 0.5f), new Vector2f(0.5f, 0.5f));
        trifold.setFoldCoordinates(new Vector2f(triRadius, triRadius), new Vector2f(triWidth - triRadius, triRadius));
        trifold.updateGeometry();
        Texture texture = this.getApplication().getAssetManager().loadTexture("Interface/bubble.png");
        Button button = new Button(this.getApplication(), trifold, texture);
        button.setText(text);
        button.setLocalTranslation(x - triWidth * 0.5f, y - triRadius, z);
        button.setTextColor(new ColorRGBA(0.4f, 0.6f, 0.6f, 1.0f));
        button.setTextShadowColor(new ColorRGBA(0.1f, 0.2f, 0.2f, 1.0f));
        button.setTextSelectedColor(ColorRGBA.Yellow);
        return button;
    }

    protected Button createTitle(String text, float x, float y, float z) {
        float triHeight = 64.0f;
        float triWidth = 512.0f;
        Trifold trifold = new Trifold(triWidth, triHeight);
        trifold.setFoldTextureCoordinates(new Vector2f(0.27148438f, 0.0f), new Vector2f(0.7265625f, 1.0f));
        trifold.setFoldCoordinates(new Vector2f(139.0f, 0.0f), new Vector2f(372.0f, 64.0f));
        trifold.updateGeometry();
        Texture texture = this.getApplication().getAssetManager().loadTexture("Interface/banner.png");
        Button button = new Button(this.getApplication(), trifold, texture);
        button.setText(text);
        button.setLocalTranslation(x - triWidth * 0.5f, y - triHeight, z);
        button.setTextColor(new ColorRGBA(0.4f, 0.6f, 0.6f, 1.0f));
        button.setTextShadowColor(new ColorRGBA(0.1f, 0.2f, 0.2f, 1.0f));
        button.setTextSelectedColor(ColorRGBA.Yellow);
        return button;
    }

    protected class CancelCommand
    extends ActionCommand {
        public CancelCommand() {
            super("Cancel");
        }

        public void execute(Object source, Object a) {
            RadialMenuState.this.setEnabled(false);
        }
    }

    protected class SetNameCommand
    extends ActionCommand {
        private ActionReference ref;
        private EntityId target;

        public SetNameCommand(ActionReference ref, EntityId target) {
            super("Set Name");
            this.target = target;
            this.ref = ref;
        }

        public void execute(Object source, Object a) {
            RadialMenuState.this.setEnabled(false);
            System.out.println("Source:" + source);
            StringEntryState state = (StringEntryState)((Object)source);
            System.out.println("Entered text:" + state.getText());
            String s = state.getText().trim();
            if (s.length() > 25) {
                s = s.substring(0, 25);
            }
            Name name = new Name(s);
            RadialMenuState.this.gameClient.executeRef(this.ref, this.target, new ComponentParameter(name));
        }
    }

    protected class NamedActionCommand
    extends ActionCommand {
        private ActionReference ref;
        private EntityId target;

        public NamedActionCommand(ActionReference ref, EntityId target) {
            super(ref.getName());
            this.target = target;
            this.ref = ref;
        }

        public void execute(Object source, Object a) {
            if (this.ref.getType() == ActionType.NameComponent) {
                String title = this.ref.getName() + " " + RadialMenuState.this.actions.getName();
                StringEntryState state = new StringEntryState(title, new SetNameCommand(this.ref, this.target), new CancelCommand());
                RadialMenuState.this.getApplication().getStateManager().attach((AppState)state);
                return;
            }
            RadialMenuState.this.setRadialActions(null);
            RadialMenuState.this.gameClient.executeRef(this.ref, this.target, null);
        }
    }
}

