/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.view.RopeLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RopeMesh
extends Mesh {
    private List<RopeLink> ropes = new ArrayList<RopeLink>();
    private boolean needsUpdate = true;

    public RopeMesh() {
    }

    public RopeMesh(List<RopeLink> l) {
        for (RopeLink r : l) {
            this.addRope(r);
        }
    }

    public void addRope(RopeLink rope) {
        this.ropes.add(rope);
        rope.parent = this;
        this.needsUpdate = true;
    }

    public void updateRope(RopeLink rope) {
        this.needsUpdate = true;
    }

    public void update() {
        if (!this.needsUpdate) {
            return;
        }
        boolean updateAll = false;
        if (this.getVertexCount() != this.ropes.size() * 4) {
            this.createBuffers();
            updateAll = true;
        }
        this.updateBuffers(updateAll);
        this.needsUpdate = false;
    }

    protected void resizeFloatBuffer(VertexBuffer.Type type, int elementSize, int size) {
        FloatBuffer pb = ByteBuffer.allocateDirect(size * elementSize * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        VertexBuffer buffer = this.getBuffer(type);
        if (buffer == null) {
            this.setBuffer(type, elementSize, pb);
        } else {
            buffer.updateData((Buffer)pb);
        }
    }

    protected void resizeShortBuffer(VertexBuffer.Type type, int elementSize, int size) {
        ShortBuffer pb = ByteBuffer.allocateDirect(size * elementSize * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        VertexBuffer buffer = this.getBuffer(type);
        if (buffer == null) {
            this.setBuffer(type, elementSize, pb);
        } else {
            buffer.updateData((Buffer)pb);
        }
    }

    protected void createBuffers() {
        int size = this.ropes.size() * 4;
        this.resizeFloatBuffer(VertexBuffer.Type.Position, 3, size);
        this.resizeFloatBuffer(VertexBuffer.Type.Normal, 3, size);
        this.resizeFloatBuffer(VertexBuffer.Type.Color, 4, size);
        this.resizeFloatBuffer(VertexBuffer.Type.TexCoord, 2, size);
        this.resizeShortBuffer(VertexBuffer.Type.Index, 3, this.ropes.size() * 2);
    }

    protected void updateBuffers(boolean updateAll) {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer verts = (FloatBuffer)vb.getData();
        verts.rewind();
        VertexBuffer nb = this.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer normals = (FloatBuffer)nb.getData();
        normals.rewind();
        VertexBuffer cb = this.getBuffer(VertexBuffer.Type.Color);
        FloatBuffer colors = (FloatBuffer)cb.getData();
        colors.rewind();
        VertexBuffer tb = this.getBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer texCoords = (FloatBuffer)tb.getData();
        texCoords.rewind();
        VertexBuffer ib = this.getBuffer(VertexBuffer.Type.Index);
        ShortBuffer index = (ShortBuffer)ib.getData();
        index.rewind();
        float thickness = 0.1f;
        int vertIndex = 0;
        for (RopeLink r : this.ropes) {
            if (!updateAll && !r.changed) {
                verts.position(verts.position() + 12);
                normals.position(normals.position() + 12);
                colors.position(colors.position() + 16);
                texCoords.position(texCoords.position() + 8);
                index.position(index.position() + 6);
            } else {
                Vector3f v1 = r.start;
                Vector3f v2 = r.end;
                Vector3f dir = v2.subtract(v1);
                float len = dir.length();
                dir.divideLocal(len);
                verts.put(v1.x).put(v1.y).put(v1.z);
                normals.put(dir.x).put(dir.y).put(dir.z);
                colors.put(0.0f).put(0.0f).put(1.0f).put(1.0f);
                texCoords.put(-0.5f).put(0.0f);
                verts.put(v1.x).put(v1.y).put(v1.z);
                normals.put(dir.x).put(dir.y).put(dir.z);
                colors.put(0.0f).put(0.0f).put(1.0f).put(1.0f);
                texCoords.put(0.5f).put(0.0f);
                verts.put(v2.x).put(v2.y).put(v2.z);
                normals.put(dir.x).put(dir.y).put(dir.z);
                colors.put(0.0f).put(0.0f).put(1.0f).put(1.0f);
                texCoords.put(0.5f).put(len / (thickness * 2.0f));
                verts.put(v2.x).put(v2.y).put(v2.z);
                normals.put(dir.x).put(dir.y).put(dir.z);
                colors.put(0.0f).put(0.0f).put(1.0f).put(1.0f);
                texCoords.put(-0.5f).put(len / (thickness * 2.0f));
                index.put((short)vertIndex).put((short)(vertIndex + 1)).put((short)(vertIndex + 2));
                index.put((short)vertIndex).put((short)(vertIndex + 2)).put((short)(vertIndex + 3));
            }
            vertIndex += 4;
        }
        vb.updateData((Buffer)verts);
        nb.updateData((Buffer)normals);
        cb.updateData((Buffer)colors);
        tb.updateData((Buffer)texCoords);
        ib.updateData((Buffer)index);
        this.updateCounts();
        this.updateBound();
    }
}

