/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BinaryDataOutputStream
implements DataOutput {
    private DataOutputStream out;
    private boolean littleEndian = true;

    public BinaryDataOutputStream(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.out.write(bytes, offset, length);
    }

    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void write(int value) throws IOException {
        this.out.write(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.out.writeBoolean(value);
    }

    public void writeByte(int value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeShort(int value) throws IOException {
        if (!this.littleEndian) {
            this.out.writeShort(value);
            return;
        }
        this.out.write(value);
        this.out.write(value >> 8);
    }

    public void writeChar(int c) throws IOException {
        this.out.writeChar(c);
    }

    public void writeInt(int value) throws IOException {
        if (!this.littleEndian) {
            this.out.writeInt(value);
            return;
        }
        this.out.write(value);
        this.out.write(value >> 8);
        this.out.write(value >> 16);
        this.out.write(value >> 24);
    }

    public void writeLong(long value) throws IOException {
        if (!this.littleEndian) {
            this.out.writeLong(value);
            return;
        }
        this.writeInt((int)value);
        this.writeInt((int)(value >> 32));
    }

    public void writeFloat(float value) throws IOException {
        if (!this.littleEndian) {
            this.out.writeFloat(value);
            return;
        }
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        if (!this.littleEndian) {
            this.out.writeDouble(value);
            return;
        }
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeBytes(String string) throws IOException {
        this.out.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.out.writeChars(string);
    }

    public void writeUTF(String arg0) throws IOException {
        throw new UnsupportedOperationException("writeUTF() not supported.");
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

