/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIterator
implements Iterator<Class> {
    private boolean includeInterfaces = true;
    private Class currentClass;
    private LinkedList<Class> interfaces = new LinkedList();
    private Set<Class> visited;

    public ClassIterator(Class type) {
        this(type, true);
    }

    public ClassIterator(Class type, boolean includeInterfaces) {
        this(type, includeInterfaces, true);
    }

    public ClassIterator(Class type, boolean includeInterfaces, boolean ignoreDuplicates) {
        this.currentClass = type;
        this.includeInterfaces = includeInterfaces;
        this.visited = new HashSet<Class>();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Classes cannot be removed.");
    }

    @Override
    public boolean hasNext() {
        if (this.currentClass != null) {
            return true;
        }
        return this.interfaces.size() != 0;
    }

    @Override
    public Class next() {
        if (this.currentClass == null && this.interfaces.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.interfaces.size() == 0) {
            if (this.includeInterfaces) {
                if (this.visited != null) {
                    for (Class<?> c : Arrays.asList(this.currentClass.getInterfaces())) {
                        if (!this.visited.add(c)) continue;
                        this.interfaces.add(c);
                    }
                } else {
                    this.interfaces.addAll(Arrays.asList(this.currentClass.getInterfaces()));
                }
            }
            Class retVal = this.currentClass;
            this.currentClass = retVal.getSuperclass();
            return retVal;
        }
        Class retVal = this.interfaces.remove(0);
        Class<?>[] superInterfaces = retVal.getInterfaces();
        if (this.visited != null) {
            for (Class<?> c : Arrays.asList(superInterfaces)) {
                if (!this.visited.add(c)) continue;
                this.interfaces.addFirst(c);
            }
        } else {
            this.interfaces.addAll(0, Arrays.asList(superInterfaces));
        }
        return retVal;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            Class<?> c = Class.forName(args[i]);
            System.out.println("Hierarchy for:" + c);
            ClassIterator it = new ClassIterator(c, true, true);
            while (it.hasNext()) {
                System.out.println("    " + it.next());
            }
        }
    }
}

