/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.progeeks.util.ClassIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRegistry<E> {
    private ClassRegistry<E> delegate;
    private Map<Class, E> classes = new LinkedHashMap<Class, E>();
    private List<ClassMapper<E>> mappers;

    public ClassRegistry() {
    }

    public ClassRegistry(ClassRegistry<E> delegate) {
        this.delegate = delegate;
    }

    public void putAll(ClassRegistry<E> registry) {
        this.classes.putAll(registry.classes);
    }

    public void put(Class c, E value) {
        this.classes.put(c, value);
    }

    protected E getMappedValue(Class c) {
        if (this.mappers == null) {
            return null;
        }
        for (ClassMapper<E> cm : this.mappers) {
            E o = cm.getMappedValue(this, c);
            if (o == null) continue;
            this.put(c, o);
            return o;
        }
        return null;
    }

    public E get(Class c, boolean searchSuperclasses) {
        E result = this.classes.get(c);
        if (result != null) {
            return result;
        }
        result = this.getMappedValue(c);
        if (result != null) {
            return result;
        }
        if (this.delegate != null && (result = this.delegate.get(c, false)) != null) {
            return result;
        }
        if (!searchSuperclasses) {
            return result;
        }
        ClassIterator i = new ClassIterator(c);
        while (i.hasNext()) {
            Class superclass = (Class)i.next();
            result = this.classes.get(superclass);
            if (result != null) {
                return result;
            }
            result = this.getMappedValue(c);
            if (result != null) {
                return result;
            }
            if (this.delegate == null || (result = this.delegate.get(superclass, false)) == null) continue;
            return result;
        }
        return result;
    }

    public E get(Class c) {
        return this.get(c, true);
    }

    public void clear() {
        this.classes.clear();
    }

    public void setMappings(Map<Object, E> map) {
        this.classes.clear();
        Thread t = Thread.currentThread();
        ClassLoader classLoader = t.getContextClassLoader();
        for (Map.Entry<Object, E> e : map.entrySet()) {
            Class<?> key = e.getKey();
            if (key instanceof String) {
                String cName = (String)((Object)key);
                try {
                    key = classLoader.loadClass(cName);
                }
                catch (ClassNotFoundException exc) {
                    throw new RuntimeException("Error setting registry entries.", exc);
                }
            }
            if (!(key instanceof Class)) {
                throw new RuntimeException("Illegal key type for:" + key);
            }
            this.classes.put(key, e.getValue());
        }
    }

    public void setClassMappers(List<? extends ClassMapper<E>> mappers) {
        if (this.mappers == mappers) {
            return;
        }
        if (this.mappers == null) {
            this.mappers = new ArrayList<ClassMapper<E>>();
        } else {
            this.mappers.clear();
        }
        this.mappers.addAll(mappers);
    }

    public List<ClassMapper<E>> getClassMappers() {
        return this.mappers;
    }

    public String toString() {
        return this.getClass() + "[ parent=" + this.delegate + ", mappings=" + this.classes + " ]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassMapper<E> {
        public E getMappedValue(ClassRegistry<E> var1, Class var2);
    }
}

