/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.progeeks.util.Inspector;
import org.progeeks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSpace {
    private boolean initialized = false;
    private PatternSet classPatterns = new PatternSet();
    private PatternSet resourcePatterns = new PatternSet();
    private IsolatedClassLoader spaceClassLoader;
    private List<URL> classpath = new ArrayList<URL>();
    private ClassLoader parentClassLoader;
    private Pattern delegatePattern;

    public ClassSpace() {
        this.classPatterns.add("java\\..*");
        this.classPatterns.add("javax\\.swing\\..*");
    }

    protected void checkInitialized() {
        if (this.initialized) {
            throw new RuntimeException("ClassSpace has already been initialized, changes are not allowed.");
        }
    }

    public void setParentClassLoader(ClassLoader parent) {
        this.checkInitialized();
        this.parentClassLoader = parent;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassPath(List<? extends Object> entries) {
        this.checkInitialized();
        if (this.classpath == entries) {
            entries = new ArrayList<Object>(entries);
        }
        this.classpath.clear();
        for (Object object : entries) {
            try {
                if (object instanceof File) {
                    this.classpath.add(((File)object).toURL());
                    continue;
                }
                if (object instanceof URL) {
                    this.classpath.add((URL)object);
                    continue;
                }
                if (object instanceof String) {
                    this.classpath.add(new URL((String)object));
                    continue;
                }
                throw new IllegalArgumentException("Type invalid, can't add classpath entry:" + object);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid entry:" + object, e);
            }
        }
    }

    public void addClassPathEntry(URL entry) {
        this.checkInitialized();
        this.classpath.add(entry);
    }

    public void addClassPathEntry(String entry) {
        try {
            if (entry.indexOf(58) < 0) {
                this.addClassPathEntry(new File(entry));
            } else {
                this.addClassPathEntry(new URL(entry));
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid entry:" + entry, e);
        }
    }

    public void addClassPathEntry(File entry) {
        try {
            this.addClassPathEntry(entry.toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid entry:" + entry, e);
        }
    }

    public List getClassPath() {
        if (this.initialized) {
            return Collections.unmodifiableList(this.classpath);
        }
        return this.classpath;
    }

    public PatternSet getSharedClassPatterns() {
        return this.classPatterns;
    }

    public void addSharedClass(Class c) {
        this.addSharedClassName(c.getName());
    }

    public void addSharedClassName(String s) {
        this.checkInitialized();
        this.getSharedClassPatterns().getExactMatches().add(s);
    }

    public PatternSet getSharedResourcePatterns() {
        return this.resourcePatterns;
    }

    protected boolean shouldLoadClassFromParent(String name) {
        return this.classPatterns.matches(name);
    }

    protected boolean shouldLoadResourceFromParent(String name) {
        return this.resourcePatterns.matches(name);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        URL[] urls = new URL[this.classpath.size()];
        urls = this.classpath.toArray(urls);
        this.spaceClassLoader = new IsolatedClassLoader(urls);
        this.initialized = true;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.spaceClassLoader.loadClass(name);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: ClassSpace <classpath entry> [<classpath entry>...] <class name>");
            System.out.println("  Just a command line test version of the ClassSpace class.");
            System.out.println("  Creates a ClassSpace with the specified classpath entries");
            System.out.println("  and then tries to load a class... in addition to a few test");
            System.out.println("  classes.");
            return;
        }
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        System.out.println("System class loader:" + cl);
        cl = cl.getParent();
        System.out.println("Parent class loader:" + cl.getParent());
        ClassSpace space = new ClassSpace();
        for (int i = 0; i < args.length - 1; ++i) {
            space.addClassPathEntry(args[i]);
        }
        space.getSharedClassPatterns().add("javax\\.management\\..*");
        space.addSharedClass(Inspector.class);
        space.initialize();
        Class test = space.loadClass("java.lang.String");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = space.loadClass("java.util.ArrayList");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = space.loadClass("javax.swing.JFrame");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = space.loadClass("javax.management.Attribute");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = space.loadClass("org.progeeks.util.Inspector");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        System.out.println("Resource test:" + space.spaceClassLoader.getResource("LICENSE"));
        Enumeration<URL> en = space.spaceClassLoader.getResources("LICENSE");
        while (en.hasMoreElements()) {
            System.out.println("resource:" + en.nextElement());
        }
        String cname = args[args.length - 1];
        System.out.println("Loading user-defined class:" + cname);
        test = space.loadClass(cname);
        System.out.println("User-defined class:" + test + "  classloader:" + test.getClassLoader());
    }

    private class IsolatedClassLoader
    extends URLClassLoader {
        public IsolatedClassLoader(URL[] classpath) {
            super(classpath, ClassSpace.this.getParentClassLoader());
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return super.loadClass(name);
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = ClassSpace.this.shouldLoadClassFromParent(name) ? super.loadClass(name, resolve) : this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        public URL getResource(String name) {
            if (ClassSpace.this.shouldLoadResourceFromParent(name)) {
                return this.getParent().getResource(name);
            }
            return this.findResource(name);
        }

        public URL findResource(String name) {
            if (ClassSpace.this.shouldLoadResourceFromParent(name)) {
                return this.getParent().getResource(name);
            }
            return super.findResource(name);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator i = ClassSpace.this.classpath.iterator();
            while (i.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(i.next());
            }
            return "ClassSpace.IsolatedClassLoader[" + sb + "]";
        }
    }
}

