/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.progeeks.util.CloseableIterator;

public class CompositeIterator
implements CloseableIterator {
    private Iterator mainIterator;
    private Iterator last;
    private Iterator current;
    private boolean removed = false;

    public CompositeIterator(Iterator mainIterator) {
        this.mainIterator = mainIterator;
    }

    public void close() {
        this.setLastIterator(null);
        if (this.current instanceof CloseableIterator) {
            ((CloseableIterator)this.current).close();
        }
        if (this.mainIterator instanceof CloseableIterator) {
            ((CloseableIterator)this.mainIterator).close();
        }
    }

    protected Iterator getCurrentIterator() {
        return this.current;
    }

    protected Iterator getLastIterator() {
        return this.last;
    }

    protected Iterator setLastIterator(Iterator last) {
        Iterator oldLast = last;
        this.last = last;
        if (oldLast instanceof CloseableIterator) {
            ((CloseableIterator)oldLast).close();
        }
        return oldLast;
    }

    protected boolean isRemoved() {
        return this.removed;
    }

    protected Iterator getIterator(Object item) {
        return (Iterator)item;
    }

    protected void refresh() {
        if (this.current != null && this.current.hasNext()) {
            this.setLastIterator(null);
            return;
        }
        Iterator oldLast = this.setLastIterator(this.current);
        while ((this.current == null || !this.current.hasNext()) && this.mainIterator.hasNext()) {
            if (this.current instanceof CloseableIterator && this.current != oldLast) {
                ((CloseableIterator)this.current).close();
            }
            this.current = this.getIterator(this.mainIterator.next());
        }
        if (this.current != null && !this.current.hasNext()) {
            this.current = null;
        }
    }

    public boolean hasNext() {
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        this.refresh();
        if (this.current == null) {
            return false;
        }
        return this.current.hasNext();
    }

    public Object next() {
        this.removed = false;
        this.refresh();
        if (this.current == null) {
            throw new NoSuchElementException("No more elements.");
        }
        return this.current.next();
    }

    public void remove() {
        if (this.isRemoved()) {
            throw new IllegalStateException("Item has already been removed.");
        }
        if (this.last != null) {
            this.last.remove();
        } else if (this.current != null) {
            this.current.remove();
        }
        this.removed = true;
    }
}

