/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import org.progeeks.util.ClassIterator;
import org.progeeks.util.ContextView;
import org.progeeks.util.Inspector;
import org.progeeks.util.ViewContext;
import org.progeeks.util.ViewFactory;
import org.progeeks.util.log.Log;

public class DefaultViewFactory
implements ViewFactory {
    static Log log = Log.getLog(DefaultViewFactory.class);
    private Class viewType;

    public DefaultViewFactory(Class viewType) {
        this.viewType = viewType;
    }

    public Class getViewType() {
        return this.viewType;
    }

    public ContextView createView(ViewContext context) {
        Class[] argTypes = new Class[1];
        ClassIterator i = new ClassIterator(context.getClass());
        while (i.hasNext()) {
            argTypes[0] = i.next();
            if (log.isDebugEnabled()) {
                log.debug("Trying for constructor: " + this.viewType.getName() + "(" + argTypes[0].getName() + ")");
            }
            if (!Inspector.hasConstructor(this.viewType, argTypes)) continue;
            return (ContextView)Inspector.newInstance(this.viewType, new Object[]{context}, argTypes);
        }
        throw new RuntimeException("Appropriate constructor not found on:" + this.viewType + " that takes a:" + context.getClass() + " or any of its superclasses.");
    }

    public void destroyView(ContextView view) {
    }

    public String toString() {
        return this.getClass() + "[" + this.getViewType() + "]";
    }
}

