/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.progeeks.util.ClassIterator;
import org.progeeks.util.beans.BeanChangeSupport;
import org.progeeks.util.beans.StandardBean;
import org.progeeks.util.log.Log;

public abstract class DelegateInvocationHandler
implements InvocationHandler {
    static Log log = Log.getLog(DelegateInvocationHandler.class);
    private Object delegate;
    private Class[] interfaces;
    private MethodMapping mapping;

    protected DelegateInvocationHandler(Object delegate, Class[] interfaces) {
        this.delegate = delegate;
        this.interfaces = interfaces;
        this.mapping = new MethodMapping(interfaces, this.getClass());
    }

    protected DelegateInvocationHandler(Object delegate) {
        this.delegate = delegate;
        HashSet<Class> temp = new HashSet<Class>();
        ClassIterator i = new ClassIterator(delegate.getClass());
        while (i.hasNext()) {
            Class c = (Class)i.next();
            if (!c.isInterface()) continue;
            temp.add(c);
        }
        this.interfaces = new Class[temp.size()];
        this.interfaces = temp.toArray(this.interfaces);
        this.mapping = new MethodMapping(this.interfaces, this.getClass());
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    protected Class[] getMappedInterfaces() {
        return this.interfaces;
    }

    public static Object newProxy(DelegateInvocationHandler handler) {
        return DelegateInvocationHandler.newProxy(handler.getClass().getClassLoader(), handler);
    }

    public static Object newProxy(ClassLoader loader, DelegateInvocationHandler handler) {
        return Proxy.newProxyInstance(loader, handler.getMappedInterfaces(), (InvocationHandler)handler);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m;
        if (log.isDebugEnabled()) {
            log.debug("invoke(" + method + ")");
        }
        if ((m = this.mapping.methods.get(method)) == null) {
            m = this.mapping.methods.get(method.getName());
        }
        if (m != null) {
            log.debug("Calling local override.");
            try {
                return m.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        log.debug("Calling delegate.");
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static void main(String[] args) {
        DelegateInvocationHandler handler = new DelegateInvocationHandler(new BeanChangeSupport()){

            public boolean hasListeners(String name) {
                System.out.println("*** Method hasListener(" + name + ") overridden.");
                return ((StandardBean)this.getDelegate()).hasListeners(name);
            }
        };
        Object obj = DelegateInvocationHandler.newProxy(handler);
        StandardBean bean = (StandardBean)obj;
        System.out.println("hasListener(\"test\") : " + bean.hasListeners("test"));
        bean.addPropertyChangeListener("test", null);
        System.out.println("hasListener(\"test\") : " + bean.hasListeners("test"));
        System.out.println("equals( null ) : " + bean.equals(null));
        System.out.println("toString() : " + bean.toString());
    }

    private static class MethodMapping {
        Class type;
        Class[] interfaces;
        Map<Method, Method> methods = new HashMap<Method, Method>();

        public MethodMapping(Class[] interfaces, Class type) {
            this.type = type;
            this.interfaces = interfaces;
            this.buildMapping();
        }

        private void addMapping(Method method) {
            if (this.methods.containsKey(method)) {
                return;
            }
            try {
                Method m = this.type.getMethod(method.getName(), method.getParameterTypes());
                this.methods.put(method, m);
                if (log.isDebugEnabled()) {
                    log.debug("Added local mapping for:" + m);
                }
            }
            catch (NoSuchMethodException e) {
                return;
            }
        }

        private void buildMapping() {
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (!this.interfaces[i].isInterface()) {
                    throw new RuntimeException(this.interfaces[i] + " is not an interface.");
                }
                Method[] list = this.interfaces[i].getMethods();
                for (int j = 0; j < list.length; ++j) {
                    if (log.isDebugEnabled()) {
                        log.debug("Checking method[" + j + "]:" + list[j]);
                    }
                    this.addMapping(list[j]);
                }
            }
        }
    }
}

