/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.ArrayList;
import java.util.List;
import org.progeeks.util.ErrorInfo;
import org.progeeks.util.ErrorListener;

public class ErrorDelegate {
    private Object source;
    private List<ErrorListener> listeners;

    public ErrorDelegate() {
        this.source = this;
    }

    public ErrorDelegate(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void addErrorListener(ErrorListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ErrorListener>();
        }
        this.listeners.add(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void error(ErrorInfo error) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        Object source = this.getSource();
        ErrorListener[] list = new ErrorListener[this.listeners.size()];
        list = this.listeners.toArray(list);
        for (int i = 0; i < list.length; ++i) {
            list[i].error(source, error);
        }
    }
}

