/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String description;
    private String[] extensions;
    private String extensionsString;

    public ExtensionFileFilter(String description, String extensions) {
        this.description = description;
        this.extensionsString = extensions;
        StringTokenizer st = new StringTokenizer(extensions, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            while (extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            list.add("." + extension.toLowerCase());
        }
        this.extensions = new String[list.size()];
        this.extensions = list.toArray(this.extensions);
    }

    public ExtensionFileFilter(String extensions) {
        this(extensions + " Files", extensions);
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (this.extensions.length == 0) {
            return true;
        }
        String name = f.getName().toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!name.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    public String getExtensionsString() {
        return this.extensionsString;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ExtensionFileFilter[" + this.description + ", " + Arrays.asList(this.extensions) + "]";
    }
}

