/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.progeeks.util.ProgressReporter;
import org.progeeks.util.ProgressReporterInputStream;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File source, File destination) throws IOException {
        FileInputStream fIn = new FileInputStream(source);
        BufferedInputStream in = new BufferedInputStream(fIn, 65536);
        try {
            long l = FileUtils.saveStream(destination, in);
            return l;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File source, File destination, ProgressReporter pr) throws IOException {
        FileInputStream fIn = new FileInputStream(source);
        BufferedInputStream bIn = new BufferedInputStream(fIn, 65536);
        ProgressReporterInputStream in = new ProgressReporterInputStream(bIn, pr, source.length());
        try {
            long l = FileUtils.saveStream(destination, in);
            return l;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long saveStream(File f, InputStream in) throws IOException {
        FileOutputStream fOut = new FileOutputStream(f);
        BufferedOutputStream out = new BufferedOutputStream(fOut, 65536);
        byte[] transferBuff = new byte[65536];
        try {
            int count = 0;
            int total = 0;
            while ((count = in.read(transferBuff)) >= 0) {
                out.write(transferBuff, 0, count);
                total += count;
            }
            long l = total;
            return l;
        }
        finally {
            out.close();
        }
    }

    public static long getCrc(InputStream in) throws IOException {
        CRC32 crc = new CRC32();
        byte[] buff = new byte[65536];
        int count = 0;
        while ((count = in.read(buff)) >= 0) {
            crc.update(buff, 0, count);
        }
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCrc(File f) throws IOException {
        FileInputStream fIn = new FileInputStream(f);
        try {
            long l = FileUtils.getCrc(fIn);
            return l;
        }
        finally {
            fIn.close();
        }
    }
}

