/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.progeeks.util.Inspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionUtils {
    public static boolean areTypesCompatible(Class<?>[] targets, Class<?>[] sources) {
        if (targets.length != sources.length) {
            return false;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (sources[i] == null || InspectionUtils.translateFromPrimitive(targets[i]).isAssignableFrom(sources[i])) continue;
            return false;
        }
        return true;
    }

    public static Class<?> translateFromPrimitive(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        throw new RuntimeException("Error translating type:" + primitive);
    }

    public static Collection createCollection(Class type) {
        if (Inspector.hasConstructor(type, new Class[0])) {
            return (Collection)Inspector.newInstance(type);
        }
        if (SortedSet.class.isAssignableFrom(type)) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet();
        }
        return new ArrayList();
    }
}

