/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.progeeks.util.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerSupport {
    public static <T> ListenerList<T> getListenerSupport(Class listenerInterface) {
        return ListenerSupport.getListenerSupport(listenerInterface, ListenerList.class);
    }

    public static <T> T getListenerSupport(Class listenerInterface, Class<T> combiningInterface) {
        ClassLoader cl = listenerInterface.getClassLoader();
        if (cl == null) {
            cl = combiningInterface.getClassLoader();
        }
        Class[] interfaces = new Class[]{listenerInterface, combiningInterface};
        Object result = Proxy.newProxyInstance(cl, interfaces, new Support(listenerInterface));
        return (T)result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Support<E>
    implements InvocationHandler,
    ListenerList<Object> {
        private Class listenerType;
        private List<Object> listeners = new ArrayList<Object>();
        private Object[] array;

        public Support(Class listenerType) {
            this.listenerType = listenerType;
        }

        @Override
        public void addListener(Object l) {
            this.listeners.add(l);
            this.array = null;
        }

        @Override
        public void removeListener(Object l) {
            this.listeners.remove(l);
            this.array = null;
        }

        @Override
        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }

        public String toString() {
            return ListenerSupport.class.getName() + "[" + this.listenerType.getName() + "]@" + System.identityHashCode(this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == ListenerList.class) {
                return method.invoke((Object)this, args);
            }
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (method.getDeclaringClass() == this.listenerType) {
                Object[] local = this.array;
                if (local == null) {
                    this.array = local = this.listeners.toArray();
                }
                for (int i = 0; i < local.length; ++i) {
                    method.invoke(local[i], args);
                }
                return null;
            }
            throw new RuntimeException("No mapping for method:" + method);
        }
    }
}

