/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.progeeks.util.InspectionUtils;
import org.progeeks.util.log.Log;

public class MethodIndex {
    static Log log = Log.getLog(MethodIndex.class);
    private static final String NO_METHOD = "not found";
    private static final Class[] SINGLE_ARG_WILDCARD = new Class[]{null};
    private static Map<Object, MethodIndex> indexCache = new ConcurrentHashMap<Object, MethodIndex>();
    private Class type;
    private Map<String, Object> methodCache = new ConcurrentHashMap<String, Object>();
    private Map<String, PropertyData> propertyCache = new HashMap<String, PropertyData>();
    private boolean isClassObject = false;

    public static MethodIndex getMethodIndex(Class type, boolean classObject) {
        Object key = classObject ? "static:" + type : type;
        MethodIndex result = indexCache.get(key);
        if (result == null) {
            result = new MethodIndex(type, classObject);
            indexCache.put(key, result);
        }
        return result;
    }

    public static void releaseMethodIndex(Class c) {
        indexCache.remove(c);
        indexCache.remove("static:" + c);
    }

    private final String upperCaseName(String name) {
        if (name.length() < 2) {
            return name.toUpperCase();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private final String lowerCaseName(String name) {
        if (name.length() < 2) {
            return name.toLowerCase();
        }
        if (Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1)) && (name.length() <= 2 || Character.isUpperCase(name.charAt(2)))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private final String propertyNameFromMethodName(String name) {
        if (name.startsWith("get") && name.length() > 3) {
            return this.lowerCaseName(name.substring(3));
        }
        if (name.startsWith("is") && name.length() > 2) {
            return this.lowerCaseName(name.substring(2));
        }
        if (name.startsWith("has") && name.length() > 3) {
            return this.lowerCaseName(name.substring(3));
        }
        if (name.startsWith("does") && name.length() > 4) {
            return this.lowerCaseName(name.substring(4));
        }
        return null;
    }

    private MethodIndex(Class type, boolean classObject) {
        this.type = type;
        this.isClassObject = classObject;
        this.initialize();
    }

    private void initialize() {
        Method[] methods = this.type.getMethods();
        if (this.isClassObject) {
            MethodIndex mi = MethodIndex.getMethodIndex(Class.class, false);
            this.propertyCache.putAll(mi.propertyCache);
        }
        this.cacheBeanAccessors(methods);
        this.cacheBeanMutators(methods);
        this.cacheFallbackAccessors(methods);
    }

    private void cacheBeanAccessors(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            boolean isStatic = Modifier.isStatic(m.getModifiers());
            if (isStatic != this.isClassObject) continue;
            String name = m.getName();
            if (log.isTraceEnabled()) {
                log.trace("Caching accessors for:" + name);
            }
            Class<?>[] argTypes = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            if ("get".equals(name) && argTypes.length == 1 && argTypes[0].isAssignableFrom(String.class) && !Void.TYPE.equals(returnType)) {
                if (log.isDebugEnabled()) {
                    log.debug("Dynamic accessor:" + m);
                }
                PropertyData pd = this.getPropertyData("", true);
                if (pd.accessor == null || argTypes[0].equals(String.class)) {
                    pd.setAccessor(m);
                    pd.type = returnType;
                    continue;
                }
                log.debug("Ignoring duplicate dynamic accessor:" + m);
                continue;
            }
            String propName = this.propertyNameFromMethodName(name);
            if (argTypes.length != 0 || Void.TYPE.equals(returnType) || propName == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Standard bean accessor:" + m);
            }
            PropertyData pd = this.getPropertyData(propName, true);
            if (pd.accessor == null) {
                pd.setAccessor(m);
                pd.type = returnType;
                continue;
            }
            log.debug("Ignoring duplicate property accessor for[" + propName + "]:" + m);
        }
    }

    private void cacheBeanMutators(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            boolean isStatic = Modifier.isStatic(m.getModifiers());
            if (isStatic != this.isClassObject) continue;
            String name = m.getName();
            if (log.isTraceEnabled()) {
                log.trace("Caching mutators for:" + name);
            }
            Class<?>[] argTypes = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            if ("set".equals(name) && argTypes.length == 2 && String.class.equals(argTypes[0])) {
                if (log.isDebugEnabled()) {
                    log.debug("Dynamic mutator:" + m);
                }
                PropertyData pd = this.getPropertyData("", true);
                if (pd.mutator == null) {
                    if (pd.type == null || argTypes[1].isAssignableFrom(pd.type)) {
                        pd.setMutator(m);
                    }
                } else if (pd.type != null && pd.type.equals(argTypes[1])) {
                    pd.setMutator(m);
                } else {
                    log.debug("Ignoring duplicate dynamic mutator:" + m);
                }
                if (pd.type != null) continue;
                pd.type = argTypes[1];
                continue;
            }
            if (!name.startsWith("set") || argTypes.length != 1) continue;
            if (log.isDebugEnabled()) {
                log.debug("Regular setter:" + m);
            }
            String n = this.lowerCaseName(name.substring(3));
            PropertyData pd = this.getPropertyData(n, true);
            if (pd.mutator == null) {
                pd.setMutator(m);
            } else if (pd.type != null && pd.type.equals(argTypes[0])) {
                pd.setMutator(m);
            } else {
                log.debug("Ignoring duplicate property mutator for[" + n + "]:" + m);
            }
            if (pd.type != null) continue;
            pd.type = argTypes[0];
        }
    }

    private void cacheFallbackAccessors(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            boolean isStatic = Modifier.isStatic(m.getModifiers());
            if (isStatic != this.isClassObject) continue;
            String name = m.getName();
            Class<?>[] argTypes = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            if (argTypes.length != 0 || Void.TYPE.equals(returnType)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Fallback accessor:" + m);
            }
            PropertyData pd = this.getPropertyData(name, true);
            if (pd.accessor == null) {
                pd.setAccessor(m);
                pd.type = returnType;
                continue;
            }
            log.debug("Ignoring duplicate fallback accessor for[" + name + "]:" + m);
        }
    }

    private PropertyData getPropertyData(String name, boolean create) {
        PropertyData prop = this.propertyCache.get(name);
        if (log.isTraceEnabled()) {
            log.trace("getPropertyData(" + name + ", " + create + ") = " + prop);
        }
        if (prop == null && create) {
            prop = new PropertyData();
            this.propertyCache.put(name, prop);
        }
        return prop;
    }

    public Method getPropertyAccessor(String name) {
        PropertyData prop = this.getPropertyData(name, false);
        if (prop == null) {
            return null;
        }
        return prop.accessor;
    }

    public Class getPropertyType(String name) {
        PropertyData prop = this.getPropertyData(name, false);
        if (prop == null) {
            return null;
        }
        return prop.type;
    }

    public Method getPropertyMutator(String name) {
        PropertyData prop = this.getPropertyData(name, false);
        if (prop == null) {
            return null;
        }
        return prop.mutator;
    }

    public Method getPropertyMutator(String name, Class type) {
        PropertyData prop = this.getPropertyData(name, false);
        if (prop != null && type == prop.type && prop.mutator != null) {
            return prop.mutator;
        }
        String propName = this.upperCaseName(name);
        Method m = this.findMethod("set" + propName, new Class[]{type});
        return m;
    }

    public Method findMethod(String name, Class[] parms) {
        String key = MethodIndex.constructMethodKey(name, parms);
        Object result = this.methodCache.get(key);
        if (result == NO_METHOD) {
            return null;
        }
        if (result == null) {
            result = this.lookupMethod(name, parms);
            if (result == null) {
                this.methodCache.put(key, NO_METHOD);
            } else {
                this.methodCache.put(key, result);
            }
        }
        return (Method)result;
    }

    private Method lookupMethod(String name, Class[] parms) {
        Method m = this.getMethod(name, parms);
        if (m != null) {
            return m;
        }
        if (parms == null || parms.length == 0) {
            return null;
        }
        m = this.searchForMethod(name, parms);
        if (m == null) {
            return null;
        }
        MethodIndex.verifyAccess(m);
        return m;
    }

    private Method getMethod(String name, Class[] parms) {
        Method result = null;
        try {
            result = this.type.getMethod(name, parms);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    private Method searchForMethod(String name, Class[] parms) {
        Method[] methods = this.type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            Class<?>[] types = methods[i].getParameterTypes();
            if (log.isDebugEnabled()) {
                log.debug("Checking " + this.type.getName() + Arrays.asList(types));
            }
            if (types.length != parms.length || !InspectionUtils.areTypesCompatible(types, parms)) continue;
            return methods[i];
        }
        return null;
    }

    private static String constructMethodKey(String name, Class[] parms) {
        StringBuilder sb = new StringBuilder(name);
        sb.append("(");
        if (parms != null) {
            for (int i = 0; i < parms.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parms[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected static void verifyAccess(AccessibleObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.isAccessible()) {
            return;
        }
        obj.setAccessible(true);
    }

    private static class PropertyData {
        boolean accessorSet;
        Method accessor;
        boolean mutatorSet;
        Method mutator;
        Class type;

        private PropertyData() {
        }

        public void setAccessor(Method m) {
            this.accessor = m;
            if (m != null) {
                this.type = m.getReturnType();
            }
            this.accessorSet = true;
            MethodIndex.verifyAccess(m);
        }

        public void setMutator(Method m) {
            this.mutator = m;
            this.mutatorSet = true;
            MethodIndex.verifyAccess(m);
        }

        public String toString() {
            return "PropertyData[" + this.accessor + ", " + this.mutator + ", " + this.type + "]";
        }
    }
}

