/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.progeeks.util.Inspector;

public class ObjectUtils {
    private static Set<Object> overrides = new HashSet<Object>();
    private static Map<Class, Boolean> equatableMap = new HashMap<Class, Boolean>();

    public static Object cloneObject(Object obj) {
        if (obj instanceof Cloneable) {
            Inspector ins = new Inspector(obj);
            if (!ins.hasMethod("clone")) {
                return obj;
            }
            return ins.callMethod("clone");
        }
        return obj;
    }

    public static List deepCloneList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            retval.add(ObjectUtils.cloneObject(iter.next()));
        }
        return retval;
    }

    public static List deepCloneList(List list, boolean forceClone) {
        ArrayList clone = (ArrayList)ObjectUtils.cloneObject(list);
        if (clone == list && forceClone) {
            clone = new ArrayList(list);
        } else if (!forceClone) {
            return list;
        }
        ListIterator<Object> i = clone.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            i.set(ObjectUtils.deepCloneObject(o));
        }
        return clone;
    }

    public static Set deepCloneSet(Set set) {
        Set clone = (Set)ObjectUtils.cloneObject(set);
        if (clone == set) {
            return set;
        }
        clone.clear();
        for (Object o : set) {
            clone.add(ObjectUtils.deepCloneObject(o));
        }
        return clone;
    }

    public static Map deepCloneMap(Map map) {
        Map clone = (Map)ObjectUtils.cloneObject(map);
        if (clone == map) {
            return map;
        }
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(ObjectUtils.deepCloneObject(entry.getValue()));
        }
        return clone;
    }

    public static Object deepCloneObject(Object o) {
        if (o instanceof List) {
            return ObjectUtils.deepCloneList((List)o, false);
        }
        if (o instanceof Map) {
            return ObjectUtils.deepCloneMap((Map)o);
        }
        if (o instanceof Set) {
            return ObjectUtils.deepCloneSet((Set)o);
        }
        return ObjectUtils.cloneObject(o);
    }

    public static boolean isEquatable(Object obj) {
        if (obj == null) {
            return false;
        }
        if (overrides.contains(obj)) {
            return true;
        }
        return ObjectUtils.isEquatable(obj.getClass());
    }

    public static boolean isEquatable(Class type) {
        if (type == null) {
            return false;
        }
        Boolean b = equatableMap.get(type);
        if (b != null) {
            return b;
        }
        try {
            Method m = type.getMethod("equals", Object.class);
            b = m.getDeclaringClass().equals(Object.class) ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            b = Boolean.FALSE;
        }
        equatableMap.put(type, b);
        return b;
    }

    public static void markEquatable(Class type) {
        equatableMap.put(type, Boolean.TRUE);
    }

    public static void markEquatable(Object instance) {
        overrides.add(instance);
    }

    public static void clearEquatableClasses() {
        equatableMap.clear();
    }

    public static void clearEquatableOverrides() {
        overrides.clear();
    }

    public static void clearEquatables() {
        ObjectUtils.clearEquatableClasses();
        ObjectUtils.clearEquatableOverrides();
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Serializable o) {
        byte[] byArray;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bOut);
        try {
            out.writeObject(o);
            byArray = bOut.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert object to bytes", e);
            }
        }
        out.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] buffer) {
        Object object;
        ByteArrayInputStream bIn = new ByteArrayInputStream(buffer);
        ObjectInputStream in = new ObjectInputStream(bIn);
        try {
            object = in.readObject();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class defined in serialized stream that is not available", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert bytes to an object", e);
            }
        }
        in.close();
        return object;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            Class<?> c = Class.forName(args[i]);
            System.out.println(c + " is equatable:" + ObjectUtils.isEquatable(c));
        }
    }
}

