/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.progeeks.util.MapPropertyChangeEvent;
import org.progeeks.util.beans.BeanChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableMap<K, V>
extends BeanChangeSupport
implements Map<K, V>,
Serializable {
    static final long serialVersionUID = 1L;
    private Map<K, V> map;

    public ObservableMap(Map<K, V> map) {
        this.map = map;
    }

    public ObservableMap() {
        this(new HashMap());
    }

    protected void setMap(Map<K, V> map) {
        this.map = map;
    }

    protected Map<K, V> getMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        V oldVal = this.map.put(key, value);
        this.fireMapPropertyChange(key, oldVal, value);
        return oldVal;
    }

    @Override
    public V remove(Object key) {
        V oldVal = this.map.remove(key);
        this.fireMapPropertyChange(key, oldVal, null);
        return oldVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Map.Entry[] entries = new Map.Entry[this.size()];
        entries = this.entrySet().toArray(entries);
        this.map.clear();
        for (int i = 0; i < entries.length; ++i) {
            this.fireMapPropertyChange(entries[i].getKey(), entries[i].getValue(), null);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ObservableMap) {
            return ((Object)((ObservableMap)o).map).equals(this.map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    protected void fireMapPropertyChange(Object key, Object oldValue, Object newValue) {
        this.firePropertyChange(new MapPropertyChangeEvent((Object)this, key, oldValue, newValue));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements Map.Entry<K, V> {
        private Map.Entry<K, V> wrappedEntry;

        public Entry(Map.Entry<K, V> wrappedEntry) {
            this.wrappedEntry = wrappedEntry;
        }

        @Override
        public K getKey() {
            return this.wrappedEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.wrappedEntry.getValue();
        }

        @Override
        public V setValue(V value) {
            Object oldVal = this.wrappedEntry.setValue(value);
            ObservableMap.this.fireMapPropertyChange(this.wrappedEntry.getKey(), oldVal, value);
            return oldVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator<T>
    implements Iterator<T> {
        static final int TYPE_ENTRY = 0;
        static final int TYPE_KEY = 1;
        static final int TYPE_VALUE = 2;
        int type;
        Iterator<Map.Entry<K, V>> it;
        Map.Entry<K, V> last;

        public EntryIterator(int type) {
            this.type = type;
            this.it = ObservableMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            switch (this.type) {
                case 0: {
                    return (T)new Entry(this.last);
                }
                case 1: {
                    return (T)this.last.getKey();
                }
                case 2: {
                    return (T)this.last.getValue();
                }
            }
            throw new RuntimeException("Internal state error.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            this.it.remove();
            try {
                ObservableMap.this.fireMapPropertyChange(this.last.getKey(), this.last.getValue(), null);
            }
            finally {
                this.last = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public int size() {
            return ObservableMap.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            return ObservableMap.this.containsValue(obj);
        }

        @Override
        public void clear() {
            ObservableMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new EntryIterator(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ObservableMap.this.size();
        }

        @Override
        public void clear() {
            ObservableMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return ObservableMap.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            return ObservableMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            if (!ObservableMap.this.containsKey(obj)) {
                return false;
            }
            ObservableMap.this.remove(obj);
            return true;
        }

        @Override
        public void clear() {
            ObservableMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new EntryIterator(1);
        }
    }
}

