/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSet
extends AbstractSet<Object> {
    private Set<String> matches = new HashSet<String>();
    private Set<Object> patterns = new HashSet<Object>();
    private Pattern combinedPattern = null;

    public Set<String> getExactMatches() {
        return this.matches;
    }

    @Override
    public int size() {
        return this.patterns.size();
    }

    @Override
    public Iterator<Object> iterator() {
        this.combinedPattern = null;
        return this.patterns.iterator();
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof Pattern) {
            return this.patterns.add(o);
        }
        if (o instanceof String) {
            return this.patterns.add(Pattern.compile((String)o));
        }
        throw new IllegalArgumentException("Object was not a string or pattern.");
    }

    public void compile() {
        if (this.combinedPattern != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (Pattern pattern : this.patterns) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("(?:" + pattern.pattern() + ")");
        }
        this.combinedPattern = Pattern.compile(sb.toString());
    }

    public boolean matches(CharSequence seq) {
        this.compile();
        if (seq instanceof String && this.matches.contains(seq)) {
            return true;
        }
        Matcher m = this.combinedPattern.matcher(seq);
        if (m.matches()) {
            return true;
        }
        return this.matches.contains(((Object)seq).toString());
    }
}

