/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import org.progeeks.util.ProgressReporter;

public class ProgressReporterReader
extends FilterReader {
    private ProgressReporter reporter;
    private long bytesRead = 0L;
    private boolean done = false;

    public ProgressReporterReader(Reader in, ProgressReporter reporter, long estimatedSize) {
        super(in);
        this.reporter = reporter;
        reporter.setMaximum((int)estimatedSize);
        reporter.setProgress((int)this.bytesRead);
    }

    protected void updateBytesRead(long delta) {
        if (delta < 0L) {
            return;
        }
        this.bytesRead += delta;
        this.reporter.setProgress((int)this.bytesRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        try {
            int n = super.read();
            return n;
        }
        finally {
            this.updateBytesRead(1L);
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        int read = super.read(cbuf, off, len);
        this.updateBytesRead(read);
        return read;
    }

    public long skip(long n) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled read.");
        }
        long skipped = super.skip(n);
        this.updateBytesRead(skipped);
        return skipped;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported.");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported.");
    }

    public void close() throws IOException {
        if (!this.done) {
            this.reporter.done();
        }
        this.done = true;
        super.close();
    }
}

