/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import org.progeeks.util.ProgressReporter;

public class ProgressReporterWriter
extends FilterWriter {
    private ProgressReporter reporter;
    private long charsWritten = 0L;
    private boolean done = false;

    public ProgressReporterWriter(Writer out, ProgressReporter reporter, long estimatedSize) {
        super(out);
        this.reporter = reporter;
        reporter.setMaximum((int)estimatedSize);
        reporter.setProgress((int)this.charsWritten);
    }

    protected void updateCharsWritten(long delta) {
        this.charsWritten += delta;
        this.reporter.setProgress((int)this.charsWritten);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled write.");
        }
        super.write(cbuf, off, len);
        this.updateCharsWritten(len);
    }

    public void write(int c) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled write.");
        }
        super.write(c);
        this.updateCharsWritten(1L);
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.reporter.isCanceled()) {
            throw new InterruptedIOException("User canceled write.");
        }
        super.write(str, off, len);
        this.updateCharsWritten(len);
    }

    public void close() throws IOException {
        if (!this.done) {
            this.reporter.done();
        }
        this.done = true;
        super.close();
    }
}

